package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.payload.CrmOpportunityMilestonePlanPayload;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityMilestonePlanQuery;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityMilestonePlanVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityMilestonePlanDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityMilestonePlanDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmOpportunityMilestonePlanRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 里程碑计划
 *
 * @author zoey
 * @date 2023-11-01
 */
@Repository
@RequiredArgsConstructor
public class CrmOpportunityMilestonePlanDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmOpportunityMilestonePlanRepo repo;
    private final QCrmOpportunityMilestonePlanDO qdo = QCrmOpportunityMilestonePlanDO.crmOpportunityMilestonePlanDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityMilestonePlanVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CrmOpportunityMilestonePlanVO.class,
                qdo.id,
                qdo.oppoId,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 关键里程碑
                qdo.milestone,
                // 负责人
                qdo.directorUserId,
                // 状态
                qdo.state,
                // 开始时间
                qdo.dateFrom,
                // 结束时间
                qdo.dateTo
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CrmOpportunityMilestonePlanVO> getJpaQueryWhere(CrmOpportunityMilestonePlanQuery query) {
        JPAQuery<CrmOpportunityMilestonePlanVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
            jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(CrmOpportunityMilestonePlanQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
            .select(qdo.count())
            .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(CrmOpportunityMilestonePlanQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 关键里程碑 精确 */
        if (!ObjectUtils.isEmpty(query.getMilestone())) {
            list.add(qdo.milestone.eq(query.getMilestone()));
        }
        /** 负责人 精确 */
        if (!ObjectUtils.isEmpty(query.getDirectorUserId())) {
            list.add(qdo.directorUserId.eq(query.getDirectorUserId()));
        }
        /** 状态 精确 */
        if (!ObjectUtils.isEmpty(query.getState())) {
            list.add(qdo.state.eq(query.getState()));
        }
        /** 开始时间 精确 */
        if (!ObjectUtils.isEmpty(query.getDateFrom())) {
            list.add(qdo.dateFrom.eq(query.getDateFrom()));
        }
        /** 结束时间 精确 */
        if (!ObjectUtils.isEmpty(query.getDateTo())) {
            list.add(qdo.dateTo.eq(query.getDateTo()));
        }
        /** 商机id 精确 */
        if (!ObjectUtils.isEmpty(query.getOppoId())) {
            list.add(qdo.oppoId.eq(query.getOppoId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CrmOpportunityMilestonePlanVO queryByKey(Long id) {
        JPAQuery<CrmOpportunityMilestonePlanVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CrmOpportunityMilestonePlanVO> queryListDynamic(CrmOpportunityMilestonePlanQuery query) {
        JPAQuery<CrmOpportunityMilestonePlanVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CrmOpportunityMilestonePlanVO> queryPaging(CrmOpportunityMilestonePlanQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<CrmOpportunityMilestonePlanVO> jpaQuery = getJpaQueryWhere(query);
        List<CrmOpportunityMilestonePlanVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<CrmOpportunityMilestonePlanVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CrmOpportunityMilestonePlanDO save(CrmOpportunityMilestonePlanDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CrmOpportunityMilestonePlanDO> saveAll(List<CrmOpportunityMilestonePlanDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CrmOpportunityMilestonePlanPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 关键里程碑
        if (payload.getMilestone() != null) {
            update.set(qdo.milestone, payload.getMilestone());
        }
        // 负责人
        if (payload.getDirectorUserId() != null) {
            update.set(qdo.directorUserId, payload.getDirectorUserId());
        }
        // 状态
        if (payload.getState() != null) {
            update.set(qdo.state, payload.getState());
        }
        // 开始时间
        if (payload.getDateFrom() != null) {
            update.set(qdo.dateFrom, payload.getDateFrom());
        }
        // 结束时间
        if (payload.getDateTo() != null) {
            update.set(qdo.dateTo, payload.getDateTo());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 关键里程碑
            if (nullFields.contains("milestone")) {
                update.setNull(qdo.milestone);
            }
            // 负责人
            if (nullFields.contains("directorUserId")) {
                update.setNull(qdo.directorUserId);
            }
            // 状态
            if (nullFields.contains("state")) {
                update.setNull(qdo.state);
            }
            // 开始时间
            if (nullFields.contains("dateFrom")) {
                update.setNull(qdo.dateFrom);
            }
            // 结束时间
            if (nullFields.contains("dateTo")) {
                update.setNull(qdo.dateTo);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

