package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpportunityDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @Author carl.wang
 * @Description
 * @date
 **/
public interface CrmOpportunityRepo extends JpaRepository<CrmOpportunityDO, Long>, QuerydslPredicateExecutor<CrmOpportunityDO>, JpaSpecificationExecutor<CrmOpportunityDO> {
    /**
     * 查询组织数据
     *
     * @param orgIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT id ,org_name as orgName FROM prd_org_organization  where id in (?1) and delete_flag=0")
    List<Map<String, Object>> queryOrgs(Set<Long> orgIds);

    /**
     * 查询员工数据
     *
     * @param userIds
     * @return
     */
    @Query(nativeQuery = true, value = "SELECT user_id as userId,employee_name as employeeName FROM prd_org_employee  where user_id in (?1) and delete_flag=0")
    List<Map<String, Object>> queryEmployees(Set<Long> userIds);

//    /**
//     * 查询地址簿数据
//     *
//     * @param userIds
//     * @return
//     */
//    @Query(nativeQuery = true, value = "SELECT id ,book_name as bookName FROM prd_ab  where id in (?1) and delete_flag=0")
//    List<Map<String, Object>> queryBooks(Set<Long> userIds);
//
    @Query(nativeQuery = true, value = "SELECT book_id ,partner_name as bookName FROM com_business_partner  where book_id in (?1) and delete_flag=0")
    List<Map<String, Object>> queryBookList(Set<Long> bookIds);

    @Query("select o.id from CrmOpportunityDO o where o.deleteFlag=0 and o.formalCustomerId=?1")
    List<Long> queryByFormalCustomerId(Long customerId);


    @Query("select o.id from CrmOpportunityDO o where o.deleteFlag=0 and o.formalCustomerId is null")
    List<Long> findNotBindOppos();

    @Query(value = "select id from CrmOpportunityDO where oppoIdV4 = ?1 and deleteFlag=0 ORDER BY  createTime desc ")
    List<Long> getIdByV4(Long oppoIdV4);

    @Query("update CrmOpportunityDO set deleteFlag=1 where id=?1")
    @Modifying
    void deleteSoft(Long id);

    @Query("select o.id from CrmOpportunityDO o where o.oppoIdV4=?1 and o.deleteFlag=0")
    Long queryOppoIdByV4(Long reasonId);

    @Query("select id as oppoId,oppoIdV4 as oppoIdV4 from CrmOpportunityDO where deleteFlag=0")
    List<Map<String, Object>> getV4AndV5OppoIds();
}
