package com.elitesland.tw.tw5.server.prd.humanresources.eval.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdEvaluateConfigPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEvaluateConfigPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEvaluateConfigPointService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEvaluateConfigPointVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;


/**
 * @author : WWW
 * @date : 2023-11-24
 * @desc : 评价配置点表
 */

@RestController
@RequestMapping("/api/prdEvaluateConfigPoint")
@RequiredArgsConstructor
@Api(value = "评价配置点表", tags = {"评价配置点表"})
public class PrdEvaluateConfigPointController {

    private final PrdEvaluateConfigPointService prdEvaluateConfigPointService;


    @GetMapping("get/{id}")
    @ApiOperation("详情-评价配置点表")
    public TwOutputUtil<PrdEvaluateConfigPointVO> get(@PathVariable Long id) {

        PrdEvaluateConfigPointVO res = prdEvaluateConfigPointService.get(id);
        return TwOutputUtil.ok(res);

    }


    @PostMapping("save")
    @ApiOperation("新增-评价配置点表")
    public TwOutputUtil<Long> save(@RequestBody PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        PrdEvaluateConfigPointVO res = prdEvaluateConfigPointService.save(prdEvaluateConfigPointPayload);
        return TwOutputUtil.ok(res.getId());

    }


    @PostMapping("update")
    @ApiOperation("修改-评价配置点表")
    public TwOutputUtil<Long> update(@RequestBody PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        PrdEvaluateConfigPointVO res = prdEvaluateConfigPointService.update(prdEvaluateConfigPointPayload);
        return TwOutputUtil.ok(res.getId());

    }

    @PostMapping("updateState")
    @ApiOperation("修改-评价配置点表")
    public TwOutputUtil<Long> updateState(@RequestBody PrdEvaluateConfigPointPayload prdEvaluateConfigPointPayload) {

        Long res = prdEvaluateConfigPointService.updateByCondition(prdEvaluateConfigPointPayload);
        return TwOutputUtil.ok(res);

    }


    @DeleteMapping("del")
    @ApiOperation("删除-评价配置点表")
    public TwOutputUtil<Long> del(Long[] ids) {

        Long res = prdEvaluateConfigPointService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);

    }


    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-评价配置点表")
    public TwOutputUtil<PagingVO<PrdEvaluateConfigPointVO>> page(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        PagingVO<PrdEvaluateConfigPointVO> res = prdEvaluateConfigPointService.page(prdEvaluateConfigPointQuery);
        return TwOutputUtil.ok(res);

    }

    @GetMapping("getList")
    @ApiOperation("详情-评价配置点表")
    public TwOutputUtil<PrdEvaluateConfigPointVO> getList(PrdEvaluateConfigPointQuery prdEvaluateConfigPointQuery) {

        List<PrdEvaluateConfigPointVO> res = prdEvaluateConfigPointService.getList(prdEvaluateConfigPointQuery);
        return TwOutputUtil.ok(res);

    }

}

