package com.elitesland.tw.tw5.server.prd.humanresources.resource.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.WorkOrderApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.WorkOrderApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.WorkOrderApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.WorkOrderApplyVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/api/workorder")
@RequiredArgsConstructor
@Api(value = "派工单", tags = {"派工单"})
public class WorkOrderApplyController {

    private final WorkOrderApplyService workOrderApplyService;


    /**
     * 派工单申请
     *
     * @param payload
     * @return result
     */
    @ApiOperation("派工单申请")
    @PostMapping("/apply")
    @GlobalTransactional
    public TwOutputUtil apply(@RequestBody WorkOrderApplyPayload payload) {
        workOrderApplyService.submit(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 派工单申请流程详情
     *
     * @param procId
     * @return result
     */
    @ApiOperation("派工单申请流程详情")
    @UdcNameClass
    @GetMapping("/apply/procdetail/{procId}")
    public TwOutputUtil<WorkOrderApplyVO> queryByProcId(@PathVariable String procId) {
        return TwOutputUtil.ok(workOrderApplyService.queryByProcId(procId));
    }

    /**
     * 派工单申请详情
     *
     * @param id
     * @return result
     */
    @ApiOperation("派工单申请详情")
    @UdcNameClass
    @GetMapping("/apply/detail/{id}")
    public TwOutputUtil<WorkOrderApplyVO> queryByKey(@PathVariable Long id) {
        return TwOutputUtil.ok(workOrderApplyService.queryByKey(id));
    }

    /**
     * 派工单申请列表
     *
     * @param query
     * @return result
     */
    @ApiOperation("派工单申请列表")
    @GetMapping("/apply/list")
    @UdcNameClass
    public TwOutputUtil<PagingVO<WorkOrderApplyVO>> page(WorkOrderApplyQuery query) {
        return TwOutputUtil.ok(workOrderApplyService.queryPaging(query));
    }

}
