package com.elitesland.tw.tw5.server.prd.inv.controller;


import com.elitesland.tw.tw5.api.prd.inv.payload.InvInvoiceDetailPayload;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceDetailQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceDetailService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceDetailVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitescloud.cloudt.common.base.PagingVO;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 发票明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Api(tags = "发票明细表")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/invInvoiceDetail")
@Slf4j
public class InvInvoiceDetailController {

private final InvInvoiceDetailService invInvoiceDetailService;

    /**
     * 发票明细表-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("发票明细表-新增")
    public TwOutputUtil<InvInvoiceDetailVO> insert(@RequestBody InvInvoiceDetailPayload payload){
         return TwOutputUtil.ok(invInvoiceDetailService.insert(payload));
    }

    /**
     * 发票明细表-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("发票明细表-更新")
    public TwOutputUtil<InvInvoiceDetailVO> update(@RequestBody InvInvoiceDetailPayload payload){
        return TwOutputUtil.ok(invInvoiceDetailService.update(payload));
    }

    /**
     * 发票明细表-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("发票明细表-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody InvInvoiceDetailPayload payload){
        return TwOutputUtil.ok(invInvoiceDetailService.updateByKeyDynamic(payload));
    }

    /**
     * 发票明细表-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("发票明细表-主键查询")
    public TwOutputUtil<InvInvoiceDetailVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(invInvoiceDetailService.queryByKey(key));
    }

    /**
     * 发票明细表-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("发票明细表-分页")
    public TwOutputUtil<PagingVO<InvInvoiceDetailVO>> paging(InvInvoiceDetailQuery query) {
        return TwOutputUtil.ok(invInvoiceDetailService.queryPaging(query));
    }

    /**
     * 发票明细表-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("发票明细表-查询列表")
    public TwOutputUtil<List<InvInvoiceDetailVO>> queryList(InvInvoiceDetailQuery query) {
        return TwOutputUtil.ok(invInvoiceDetailService.queryListDynamic(query));
    }

    /**
     * 发票明细表-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("发票明细表-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         invInvoiceDetailService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

