package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 发票核销明细表
 *
 * @author zoey
 * @date 2023-12-05
 */
@Entity
@Table(name = "inv_invoice_ver_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_invoice_ver_detail", comment = "发票核销明细表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvInvoiceVerDetailDO extends BaseModel implements Serializable {
    /**
     * 付款申请单ID
     */
    @Comment("付款申请单ID")
    @Column()
    private Long paymentApplyId;
    /**
     * 发票号
     */
    @Comment("发票号")
    @Column()
    private String invoiceNo;
    /**
     * 本次核销金额
     */
    @Comment("本次核销金额")
    @Column()
    private BigDecimal theAmt;
    /**
     * 发票金额
     */
    @Comment("发票金额")
    @Column()
    private BigDecimal invoiceAmt;
    /**
     * 税率
     */
    @Comment("税率")
    @Column()
    private String rate;
    /**
     * 发票类型
     */
    @Comment("发票类型")
    @Column()
    private String invoiceType;
    /**
     * 搜索类型
     */
    @Comment("搜索类型")
    @Column()
    private String searchType;
    /**
     * 发票查验状态
     */
    @Comment("发票查验状态")
    @Column()
    private String inspection;
    /**
     * 发票日期
     */
    @Comment("发票日期")
    @Column()
    private LocalDate invoiceDate;
    /**
     * 发票代码
     */
    @Comment("发票代码")
    @Column()
    private String invoiceCode;
    /**
     * 本人OR其他 true为本人，false为其他
     */
    @Comment("本人OR其他")
    @Column()
    private Boolean selfFlag;
    /**
     * 关联采购明细Id
     */
    @Comment("关联采购明细Id")
    @Column()
    private Long purConOrAgreementDetailId;

    /**
     * 发票凭证
     */
    @ApiModelProperty("发票凭证")
    @Column()
    private String invoiceVoucher;

    /** jde单据公司 */
    @ApiModelProperty("jde单据公司")
    @Column()
    private String jdeCompany;
    /** jde单据号  */
    @ApiModelProperty("jde单据号 ")
    @Column()
    private String jdeDocumentNo;
    /** jde单据类型 */
    @ApiModelProperty("jde单据类型")
    @Column()
    private String jdeDocumentType;
    /** jde付款项 */
    @ApiModelProperty("jde付款项")
    @Column()
    private String jdePaymentItem;
    /** jde发票凭证失败原因 */
    @Column()
    @ApiModelProperty("jde发票凭证失败原因")
    private String jdeInvoiceFailReason;

    /** 税额 */
    @ApiModelProperty("税额")
    @Column()
    private BigDecimal taxAmount;

    public void copy(InvInvoiceVerDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
