package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "t_attendance_other")
@org.hibernate.annotations.Table(appliesTo = "t_attendance_other", comment = "其他方式打卡表 1个资源1天只有1条打卡记录")
@Data
@Where(clause = "delete_flag= 0")
public class TAttendanceOtherDO extends BaseModel {

    @Comment("打卡人员")
    @Column()
    private Long attendanceResId;

    @Comment("打卡日期")
    @Column()
    private LocalDate attendanceDate;

    @Comment("上班时间")
    @Column()
    private String attendanceTimeStart;

    @Comment("下班时间")
    @Column()
    private String attendanceTimeEnd;

    @Comment("打卡经度")
    @Column()
    private String attendanceSiteLongitude;

    @Comment("打卡维度")
    @Column()
    private String attendanceSiteLatitude;

    @Comment("打卡位置")
    @Column()
    private String attendanceLocation;

    @Comment("打卡说明")
    @Column()
    private String attendanceRemark;

    @Comment("打卡设备")
    @Column()
    private String attendanceDevice;

    @Comment("4.0主键id")
    @Column(name = "attendance_other_id_v4")
    private Long attendanceOtherIdV4;

    public void copy(TAttendanceOtherDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
