package com.elitesland.tw.tw5.server.prd.my.repo;

import com.elitesland.tw.tw5.server.prd.my.entity.TimesheetPlanDO;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import java.math.BigDecimal;
import java.sql.Date;
import java.time.LocalDate;
import java.util.List;

/**
* 工时-工作计划
*
* @author duwh
* @date 2022-12-09
*/
public interface TimesheetPlanRepo extends JpaRepository<TimesheetPlanDO, Long>, JpaSpecificationExecutor<TimesheetPlanDO> {

    @Modifying
    @Query("update TimesheetPlanDO set taskName=?2,taskApplyStatus=?3,eqva=?4 where taskId=?1")
    void updateByTaskId(Long taskIdV4, String taskName, String taskStatus, BigDecimal eqvaQty);


    @Query("SELECT workDate FROM TimesheetPlanDO WHERE deleteFlag=0 AND tsUserId = ?3 AND (ext5 IS NULL OR ext5<>'EMPTY') AND workDate between ?1 and ?2 GROUP BY workDate")
    List<LocalDate> queryPlanDateList(LocalDate firstDay, LocalDate lastDay, Long tsUserId);

    @Query("select tdo from TimesheetPlanDO tdo where workDate >= ?1 and deleteFlag=0")
    List<TimesheetPlanDO> queryWorkPlanList(LocalDate today);

    @Query("update TimesheetPlanDO set deleteFlag=1 where id in ?1")
    @Modifying
    void deleteSoft(List<Long> singletonList);
}
