package com.elitesland.tw.tw5.server.prd.org.controller;

import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgCompanyService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 公司管理
 *
 * @author wangding
 */
@RestController
@RequiredArgsConstructor
//@RequestMapping(API_ORG)
@RequestMapping("/api/org")
@Slf4j
public class PrdOrgCompanyController {

    private final PrdOrgCompanyService service;

    /**
     * 列表查询
     *
     * @param relateType 相关主档(不传默认内部公司查询)
     * @return result
     */
    @ApiOperation("列表查询")
    @GetMapping("/company/queryList")
    public TwOutputUtil queryList(String relateType) {
        return TwOutputUtil.ok(service.queryList(relateType));
    }

}
