package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name = "prd_org_sync_log")
@org.hibernate.annotations.Table(appliesTo = "prd_org_sync_log", comment = "数据同步日志表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgSyncLogDO extends BaseModel {

    private static final long serialVersionUID = 1L;

    @Comment("同步类型")
    @Column()
    private String syncType;

    @Comment("同步时间")
    @Column()
    private LocalDateTime syncTime;

    @Comment("同步记录")
    @Column()
    private String syncData;

}
