package com.elitesland.tw.tw5.server.prd.partner.common.service;


import cn.hutool.extra.spring.SpringUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAccountPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAccountQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAccountService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAccountVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemLogService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.PrdSystemObjectEnum;
import com.elitesland.tw.tw5.server.prd.partner.common.convert.BookAccountConvert;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BookAccountDAO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookAccountDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookAccountRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * 业务伙伴-账户信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BookAccountServiceImpl extends BaseServiceImpl implements BookAccountService {

    private final BookAccountRepo bookAccountRepo;
    private final BookAccountDAO bookAccountDAO;
    private final PrdSystemLogService logService;
    @Override
    public PagingVO<BookAccountVO> queryPaging(BookAccountQuery query){
        return bookAccountDAO.queryPaging(query);
    }

    @Override
    public List<BookAccountVO> queryListDynamic(BookAccountQuery query){
        return bookAccountDAO.queryListDynamic(query);
    }

    @Override
    public BookAccountVO queryByKey(Long key) {
        BookAccountVO bookAccountVO = bookAccountDAO.queryByKey(key);
        if(bookAccountVO==null){
            throw TwException.error("","银行账号对象不存在");
        }
        return bookAccountVO;
    }

    /**
     * 根据bookId查询默认
     *
     * @param bookId bookId
     * @return {@link BookAccountVO}
     */
    @Override
    public BookAccountVO queryDefaultByBookId(Long bookId) {
        return bookAccountDAO.queryDefaultByBookId(bookId);
    }

    /**
     * 根据bookIdList查询默认
     *
     * @param bookIdList bookIdList
     * @return {@link BookAccountVO}
     */
    @Override
    public List<PrdAbAccountPayload> queryTwBookAccountListByBookId(List<Long> bookIdList) {
        return bookAccountDAO.queryTwBookAccountListByBookId(bookIdList);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookAccountVO insert(BookAccountPayload payload,Boolean logFlag) {
        //如果默认值是true就将原来的默认数据置为false
        /**
         * 如果是新增的第一条 置为默认 不管他选择了没有
         * 如果新增的不是第一条  看他这条是不是默认 是默认 将之前的默认数据置为false 不是默认不管
         **/

        BookAccountDO defaultDO = bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
        if(payload.getIsDefault()!=null&&payload.getIsDefault()&&defaultDO!=null){
            defaultDO.setIsDefault(false);
            bookAccountRepo.save(defaultDO);
        }
        //空 说明是新增的第一条 新增的第一条置为默认
        if(defaultDO==null){
            payload.setIsDefault(true);
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        //操作记录
        if(logFlag&&payload.getPartnerId()!=null){
            // 获取变更日志
//            final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
//            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsCreateLog);
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "新增了一条账户信息");

        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(payload.getBookId()));
        return BookAccountConvert.INSTANCE.toVo(bookAccountRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchInsert(List<BookAccountVO> voList) {
        //批量插入的时候要注意先删除表中其他数据 只适用于全删全插
        if(!CollectionUtils.isEmpty(voList)){
            List<BookAccountVO> collect = voList.stream().filter(p -> p.getIsDefault()!=null && p.getIsDefault().equals(true)).collect(Collectors.toList());
            //当插入的数据没有默认的时候 选一个默认给他
            if (CollectionUtils.isEmpty(collect)) {
                collect.stream().forEach(p -> p.setIsDefault(false));
                voList.get(0).setIsDefault(true);
            } else {
                if (collect.size() > 1) {
                    throw TwException.error("", "银行信息不能提交多条默认的数据");
                }
                //将不是默认的数据捞出来 然后置为false(前端传过来的时候是空 所以要给值)
                List<BookAccountVO> collectFalse = voList.stream().filter(p -> p.getIsDefault() == null || !p.getIsDefault()).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collectFalse)) {
                    collectFalse.stream().forEach(p -> p.setIsDefault(false));
                }
            }
            List<BookAccountDO> bookAccountDOS = BookAccountConvert.INSTANCE.toEntity(voList);
            bookAccountRepo.saveAll(bookAccountDOS);
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(voList.get(0).getBookId()));
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BookAccountVO update(BookAccountPayload payload,Boolean logFlag) {
        BookAccountDO entity = bookAccountRepo.findById(payload.getId()).orElseGet(BookAccountDO::new);
        Assert.notNull(entity.getId(), "不存在");
        // 变更日志用
//        BookAccountDO entityLog = new BookAccountDO();
//        BeanUtils.copyProperties(entity, entityLog);
        //如果默认值是true就将原来的默认数据置为false
        if(payload.getIsDefault()!=null&&payload.getIsDefault()){
            BookAccountDO defaultDO = bookAccountRepo.findByBookIdAndIsDefault(payload.getBookId(), true);
            //确认不是自己
            if(defaultDO!=null&&!defaultDO.getId().equals(payload.getId())){
                defaultDO.setIsDefault(false);
                bookAccountRepo.save(defaultDO);
            }
        }
        BookAccountDO entityDo = BookAccountConvert.INSTANCE.toDo(payload);
        entityDo.setId(entity.getId());
        final BookAccountDO save = bookAccountRepo.save(entityDo);

        //操作记录
        if (logFlag&&null != payload.getPartnerId()) {
//            // 修改NULL值特殊处理
//            final StringBuilder fieldsUpdateLog = changeFieldLogUtil.nullFieldsProcess(payload, entityLog, entity);
//            //获取变更日志
//            fieldsUpdateLog.append(changeFieldLogUtil.getFieldsUpdateLog(entityDo, entityLog));
//            if (org.springframework.util.StringUtils.hasText(fieldsUpdateLog)) {
//                logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), fieldsUpdateLog.toString());
//            }
            logService.saveNewLog(payload.getPartnerId(), PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "修改了一条账户信息");
        }
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(entity.getBookId()));
        return BookAccountConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys,Long bookId,Long partnerId,Boolean logFlag) {
        if (!keys.isEmpty()) {
//            keys.stream().forEach(id -> {
//                Optional<BookAccountDO> optional = bookAccountRepo.findById(id);
//                if (!optional.isEmpty()) {
//                    BookAccountDO entity = optional.get();
//                    bookAccountRepo.save(entity);
//                }
//             });
            bookAccountDAO.deleteSoft(keys);
            //如果删除只剩最后一条 就设为默认账户
            List<BookAccountDO> bookAccountDOS = bookAccountDAO.queryByBookId(bookId);
            if(bookAccountDOS!=null&&bookAccountDOS.size()==1){
                BookAccountDO bookAccountDO = bookAccountDOS.get(0);
                bookAccountDO.setIsDefault(true);
                bookAccountRepo.save(bookAccountDO);
            }
            if(logFlag){
                logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 "+keys.size()+" 条账户信息");
            }
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }

    }

    @Override
    @Transactional
    public void deleteSoftBykeys(List<Long> keys, Long bookId, Long partnerId) {
        if (!keys.isEmpty()) {
            bookAccountDAO.deleteSoft(keys);
            logService.saveNewLog(partnerId, PrdSystemObjectEnum.BUSINESS_PARTNER.getCode(), "删除了 "+keys.size()+" 条银行账户信息");
            //更新业务伙伴的更新时间 方便数据同步到4.0
            BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
            businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
        }
    }

    @Override
    public Long count(BookAccountQuery query) {
        return bookAccountDAO.count(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteByBookId(Long bookId) {
        bookAccountDAO.deleteByBookId(bookId);
        //更新业务伙伴的更新时间 方便数据同步到4.0
        BusinessPartnerService businessPartnerService = SpringUtil.getBean(BusinessPartnerService.class);
        businessPartnerService.updateBusinessParnerModifyTime(Collections.singletonList(bookId));
    }

    @Override
    public Map<Long, List<BookAccountVO>> queryByBookIdList(List<Long> bookIdList) {
        List<BookAccountVO> bookAccountVOS = bookAccountDAO.queryByBookIdList(bookIdList);
        return bookAccountVOS.stream().collect(Collectors.groupingBy(BookAccountVO::getBookId));
    }

    @Override
    public Map<Long, List<BookAccountVO>> queryByIdList(List<Long> idList) {
        List<BookAccountVO> bookAccountVOS = bookAccountDAO.queryByIdList(idList);
        return bookAccountVOS.stream().collect(Collectors.groupingBy(BookAccountVO::getId));
    }

    @Override
    public List<BookAccountVO> queryInternalList(BookAccountQuery bookAccountQuery) {
        return bookAccountDAO.queryInternalList(bookAccountQuery);
    }
    @Override
    @Transactional
    public void saveAll(List<BookAccountVO> bookAccountVOList) {
        bookAccountDAO.saveAll(BookAccountConvert.INSTANCE.toEntity(bookAccountVOList));
    }

}
