package com.elitesland.tw.tw5.server.prd.partner.strategy.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessStrategyRefPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessStrategyRefQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessStrategyRefService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessStrategyRefVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 分级策略业务伙伴映射关系
 *
 * @folder 分级策略-业务伙伴映射关系
 * @author wanlgy
 * @date 2023-06-19
 */
@Api(tags = "分级策略业务伙伴映射关系")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessStrategyRef")
@Slf4j
public class BusinessStrategyRefController {

private final BusinessStrategyRefService businessStrategyRefService;

    /**
     * 分级策略业务伙伴映射关系-新增
     *
     * @folder 分级策略-业务伙伴映射关系
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("分级策略业务伙伴映射关系-新增")
    public TwOutputUtil<BusinessStrategyRefVO> insert(@RequestBody BusinessStrategyRefPayload payload){
         return TwOutputUtil.ok(businessStrategyRefService.insert(payload));
    }

    /**
     * 分级策略业务伙伴映射关系-更新
     *
         * @folder 分级策略-业务伙伴映射关系
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("分级策略业务伙伴映射关系-更新")
    public TwOutputUtil<BusinessStrategyRefVO> update(@RequestBody BusinessStrategyRefPayload payload){
        return TwOutputUtil.ok(businessStrategyRefService.update(payload));
    }

    /**
     * 分级策略业务伙伴映射关系-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 分级策略-业务伙伴映射关系
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("分级策略业务伙伴映射关系-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessStrategyRefPayload payload){
        return TwOutputUtil.ok(businessStrategyRefService.updateByKeyDynamic(payload));
    }

    /**
     * 分级策略业务伙伴映射关系-主键查询
     *
     * @folder 分级策略-业务伙伴映射关系
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("分级策略业务伙伴映射关系-主键查询")
    public TwOutputUtil<BusinessStrategyRefVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessStrategyRefService.queryByKey(key));
    }

    /**
     * 分级策略业务伙伴映射关系-分页
     *
         * @folder 分级策略-业务伙伴映射关系
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("分级策略业务伙伴映射关系-分页")
    public TwOutputUtil<PagingVO<BusinessStrategyRefVO>> paging(BusinessStrategyRefQuery query) {
        return TwOutputUtil.ok(businessStrategyRefService.queryPaging(query));
    }

    /**
     * 分级策略业务伙伴映射关系-查询列表
     *
     * @folder 分级策略-业务伙伴映射关系
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("分级策略业务伙伴映射关系-查询列表")
    public TwOutputUtil<List<BusinessStrategyRefVO>> queryList(BusinessStrategyRefQuery query) {
        return TwOutputUtil.ok(businessStrategyRefService.queryListDynamic(query));
    }

    /**
     * 分级策略业务伙伴映射关系-删除
     *
         * @folder 分级策略-业务伙伴映射关系
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("分级策略业务伙伴映射关系-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         businessStrategyRefService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

