package com.elitesland.tw.tw5.server.prd.partner.strategy.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.partner.strategy.payload.BusinessModelIndexPayload;
import com.elitesland.tw.tw5.api.prd.partner.strategy.query.BusinessModelIndexQuery;
import com.elitesland.tw.tw5.api.prd.partner.strategy.service.BusinessModelIndexService;
import com.elitesland.tw.tw5.api.prd.partner.strategy.vo.BusinessModelIndexVO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.convert.BusinessModelIndexConvert;
import com.elitesland.tw.tw5.server.prd.partner.strategy.dao.BusinessModelIndexDAO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.entity.BusinessModelIndexDO;
import com.elitesland.tw.tw5.server.prd.partner.strategy.repo.BusinessModelIndexRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;
import java.util.Optional;

/**
 * 分级策略模型指标
 *
 * @author wangly
 * @date 2023-06-19
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessModelIndexServiceImpl extends BaseServiceImpl implements BusinessModelIndexService {

    private final BusinessModelIndexRepo businessModelIndexRepo;
    private final BusinessModelIndexDAO businessModelIndexDAO;

    @Override
    public PagingVO<BusinessModelIndexVO> queryPaging(BusinessModelIndexQuery query){
        return businessModelIndexDAO.queryPaging(query);
    }

    @Override
    public List<BusinessModelIndexVO> queryListDynamic(BusinessModelIndexQuery query){
        return businessModelIndexDAO.queryListDynamic(query);
    }

    @Override
    public BusinessModelIndexVO queryByKey(Long key) {
        BusinessModelIndexDO entity = businessModelIndexRepo.findById(key).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessModelIndexVO vo = BusinessModelIndexConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessModelIndexVO insert(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entityDo = BusinessModelIndexConvert.INSTANCE.toDo(payload);
        return BusinessModelIndexConvert.INSTANCE.toVo(businessModelIndexRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessModelIndexVO update(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entity = businessModelIndexRepo.findById(payload.getId()).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessModelIndexDO entityDo = BusinessModelIndexConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessModelIndexConvert.INSTANCE.toVo(businessModelIndexRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessModelIndexPayload payload) {
        BusinessModelIndexDO entity = businessModelIndexRepo.findById(payload.getId()).orElseGet(BusinessModelIndexDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessModelIndexDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessModelIndexDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoftByModelId(Long modelId) {
        businessModelIndexDAO.deleteSoftByModelId(modelId);
    }
}
