package com.elitesland.tw.tw5.server.prd.pms.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsMaCheckPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsMaCheckQuery;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsMaCheckVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsMaCheckDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsMaCheckDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsMaConfigDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsMaCheckRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目经理任务书核对
 *
 * @author carl
 * @date 2023-09-19
 */
@Repository
@RequiredArgsConstructor
public class PmsMaCheckDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PmsMaCheckRepo repo;
    private final QPmsMaCheckDO qdo = QPmsMaCheckDO.pmsMaCheckDO;
    private final QPmsMaConfigDO qdoConfig = QPmsMaConfigDO.pmsMaConfigDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsMaCheckVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PmsMaCheckVO.class,
                qdo.id,
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 配置id
                qdo.configId,
                // 项目id
                qdo.projId,
                // 完成标识
                qdo.finishFlag,
                // 完成时间
                qdo.finishTime
        )).from(qdo);
    }

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PmsMaCheckVO> getJpaQuerySelect0() {
        return jpaQueryFactory.select(Projections.bean(PmsMaCheckVO.class,
                qdoConfig.id.as("configId"),
                //qdo.remark,
                //qdo.createUserId,
                //qdo.creator,
                //qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                qdoConfig.sortIndex,
                qdoConfig.projectStage,
                qdoConfig.keyTask

        )).from(qdoConfig);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PmsMaCheckVO> getJpaQueryWhere(PmsMaCheckQuery query) {
        JPAQuery<PmsMaCheckVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PmsMaCheckQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PmsMaCheckQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 配置id 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 完成标识 精确 */
        if (!ObjectUtils.isEmpty(query.getFinishFlag())) {
            list.add(qdo.finishFlag.eq(query.getFinishFlag()));
        }
        /** 完成时间 精确 */
        if (!ObjectUtils.isEmpty(query.getFinishTime())) {
            list.add(qdo.finishTime.eq(query.getFinishTime()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PmsMaCheckVO queryByKey(Long id) {
        JPAQuery<PmsMaCheckVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsMaCheckVO> queryConfigList(PmsMaCheckQuery query) {
        JPAQuery<PmsMaCheckVO> jpaQuery = getJpaQuerySelect0();
        return jpaQuery.fetch();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PmsMaCheckVO> queryListDynamic(PmsMaCheckQuery query) {
        JPAQuery<PmsMaCheckVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PmsMaCheckVO> queryPaging(PmsMaCheckQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PmsMaCheckVO> jpaQuery = getJpaQueryWhere(query);
        List<PmsMaCheckVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PmsMaCheckVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PmsMaCheckDO save(PmsMaCheckDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PmsMaCheckDO> saveAll(List<PmsMaCheckDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PmsMaCheckPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 配置id
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 项目id
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 完成标识
        if (payload.getFinishFlag() != null) {
            update.set(qdo.finishFlag, payload.getFinishFlag());
        }
        // 完成时间
        if (payload.getFinishTime() != null) {
            update.set(qdo.finishTime, payload.getFinishTime());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 配置id
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 项目id
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 完成标识
            if (nullFields.contains("finishFlag")) {
                update.setNull(qdo.finishFlag);
            }
            // 完成时间
            if (nullFields.contains("finishTime")) {
                update.setNull(qdo.finishTime);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}

