package com.elitesland.tw.tw5.server.prd.pms.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 项目汇报管理
 *
 * @author carl
 * @date 2023-09-05
 */
@Entity
@Table(name = "pms_project_brief", indexes = {
        @Index(name = "proj_index", columnList = "proj_id")
})
@org.hibernate.annotations.Table(appliesTo = "pms_project_brief", comment = "项目汇报管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsProjectBriefDO extends BaseModel implements Serializable {
    /**
     * 汇报编号
     */
    @Comment("汇报编号")
    @Column()
    private String briefNo;

    /**
     * 汇报状态
     */
    @Comment("汇报状态")
    @Column()
    private String briefStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 财务期间
     */
    @Comment("财务期间")
    @Column()
    private LocalDate finPeriodDate;
    /**
     * 提交日期
     */
    @Comment("提交日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 提交资源userid
     */
    @Comment("提交资源userid")
    @Column()
    private Long applyUserId;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column(columnDefinition = "varchar(40)")
    private String projName;
    /**
     * 费用预算总金额
     */
    @Comment("费用预算总金额")
    @Column()
    private BigDecimal feeBudgetAmt;
    /**
     * 费用预算已拨付金额
     */
    @Comment("费用预算已拨付金额")
    @Column()
    private BigDecimal feeReleasedAmt;
    /**
     * 费用预算已使用金额
     */
    @Comment("费用预算已使用金额")
    @Column()
    private BigDecimal feeUsedAmt;
    /**
     * 当量预算总数
     */
    @Comment("当量预算总数")
    @Column()
    private BigDecimal eqvaBudgetCnt;
    /**
     * 当量预算总金额
     */
    @Comment("当量预算总金额")
    @Column()
    private BigDecimal eqvaBudgetAmt;
    /**
     * 当量已拨付数量
     */
    @Comment("当量已拨付数量")
    @Column()
    private BigDecimal eqvaReleasedQty;
    /**
     * 当量已拨付金额
     */
    @Comment("当量已拨付金额")
    @Column()
    private BigDecimal eqvaReleasedAmt;
    /**
     * 当量已派发数量
     */
    @Comment("当量已派发数量")
    @Column()
    private BigDecimal eqvaDistedQty;
    /**
     * 当量已派发金额
     */
    @Comment("当量已派发金额")
    @Column()
    private BigDecimal eqvaDistedAmt;
    /**
     * 当量已结算数量
     */
    @Comment("当量已结算数量")
    @Column()
    private BigDecimal eqvaSettledQty;
    /**
     * 当量已结算金额
     */
    @Comment("当量已结算金额")
    @Column()
    private BigDecimal eqvaSettledAmt;
    /**
     * 当量派发百分比
     */
    @Comment("当量派发百分比")
    @Column()
    private BigDecimal eqvaDistedPercnet;
    /**
     * 当量结算百分比
     */
    @Comment("当量结算百分比")
    @Column()
    private BigDecimal eqvaSettledPercent;
    /**
     * 报告完工百分比
     */
    @Comment("报告完工百分比")
    @Column()
    private BigDecimal reprotCompPercent;
    /**
     * 调整完工百分比
     */
    @Comment("调整完工百分比")
    @Column()
    private BigDecimal confirmCompPercent;
    /**
     * 财务调整说明
     */
    @Comment("财务调整说明")
    @Column()
    private String confirmCompDesc;
    /**
     * 项目金额
     */
    @Comment("项目金额")
    @Column()
    private BigDecimal projAmt;
    /**
     * 税率
     */
    @Comment("税率")
    @Column()
    private BigDecimal taxRate;
    /**
     * 已收款金额
     */
    @Comment("已收款金额")
    @Column()
    private BigDecimal recvedAmt;
    /**
     * 已开票金额
     */
    @Comment("已开票金额")
    @Column()
    private BigDecimal invoicedAmt;
    /**
     * 确认收入金额
     */
    @Comment("确认收入金额")
    @Column()
    private BigDecimal confirmedAmt;
    /**
     * 当期确认收入
     */
    @Comment("当期确认收入")
    @Column()
    private BigDecimal confirmAmt;
    /**
     * 实际确认收入百分比
     */
    @Comment("实际确认收入百分比")
    @Column()
    private BigDecimal confirmedPercent;
    /**
     * 申请拨付费用金额
     */
    @Comment("申请拨付费用金额")
    @Column()
    private BigDecimal applyFeeAmt;
    /**
     * 申请拨付当量数
     */
    @Comment("申请拨付当量数")
    @Column()
    private BigDecimal applyEqvaCnt;
    /**
     * 申请拨付当量金额
     */
    @Comment("申请拨付当量金额")
    @Column()
    private BigDecimal applyEqvaAmt;
    /**
     * 实际拨付费用金额
     */
    @Comment("实际拨付费用金额")
    @Column()
    private BigDecimal approveFeeAmt;
    /**
     * 实际拨付当量数
     */
    @Comment("实际拨付当量数")
    @Column()
    private BigDecimal approveEqvaCnt;
    /**
     * 实际拨付当量金额
     */
    @Comment("实际拨付当量金额")
    @Column()
    private BigDecimal approveEqvaAmt;
    /**
     * 币种
     */
    @Comment("币种")
    @Column()
    private String currCode;
    /**
     * 进度汇报说明
     */
    @Comment("进度汇报说明")
    @Column()
    private String briefDesc;
    /**
     * 费用申请说明
     */
    @Comment("费用申请说明")
    @Column()
    private String feeApplyDesc;
    /**
     * 当量申请说明
     */
    @Comment("当量申请说明")
    @Column()
    private String eqvaApplyDesc;
    /**
     * 项目进度状态
     */
    @Comment("项目进度状态")
    @Column()
    private String projProcessStatus;
    /**
     * 风险描述
     */
    @Comment("风险描述")
    @Column()
    private String riskDesc;
    /**
     * 预计还会发生的报销费用
     */
    @Comment("预计还会发生的报销费用")
    @Column()
    private BigDecimal predictReimAmt;
    /**
     * 预计还会发生的劳务费用
     */
    @Comment("预计还会发生的劳务费用")
    @Column()
    private BigDecimal predictLaborAmt;
    /**
     * 已发生的劳务费用
     */
    @Comment("已发生的劳务费用")
    @Column()
    private BigDecimal passedLaborAmt;
    /**
     * 自动汇报标识
     */
    @Comment("自动汇报标识")
    @Column(columnDefinition = "tinyint NOT NULL DEFAULT 0")
    private Integer autoReportFlag;


    public void copy(PmsProjectBriefDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
