package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplateActPayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectTemplatePayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectTemplateQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectTemplateEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectTemplateConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectTemplateDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectTemplateDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectTemplateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.List;

/**
 * 项目模板
 *
 * @author xxb
 * @date 2023-08-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsProjectTemplateServiceImpl extends BaseServiceImpl implements PmsProjectTemplateService {

    private final PmsProjectTemplateRepo pmsProjectTemplateRepo;
    private final PmsProjectTemplateDAO pmsProjectTemplateDAO;
    private final CacheUtil cacheUtil;


    private final PmsProjectTemplateActService pmsProjectTemplateActService;

    @Override
    public PagingVO<PmsProjectTemplateVO> paging(PmsProjectTemplateQuery query) {
        PagingVO<PmsProjectTemplateVO> paging = pmsProjectTemplateDAO.paging(query);
        if (!ObjectUtils.isEmpty(paging.getRecords())) {
            paging.getRecords().forEach(record -> transferData(record));
        }
        return paging;
    }

    void transferData(PmsProjectTemplateVO vo) {
        if (ProjectTemplateEnum.ENABLE.getCode().equals(vo.getTemplateStatus())) {
            vo.setTemplateStatusName(ProjectTemplateEnum.ENABLE.getDesc());
        }
        if (ProjectTemplateEnum.DISABLE.getCode().equals(vo.getTemplateStatus())) {
            vo.setTemplateStatusName(ProjectTemplateEnum.DISABLE.getDesc());
        }
        vo.setSuitProjectTypeDesc(cacheUtil.transferSystemSelection("salecon:work_type", vo.getSuitProjectType()));
        vo.setTmplTypeDesc(cacheUtil.transferSystemSelection("BU:SUIT_TYPY", vo.getTmplType()));
        vo.setCreator(cacheUtil.getUserName(vo.getCreateUserId()));

    }


    @Override
    public List<PmsProjectTemplateVO> queryListDynamic(PmsProjectTemplateQuery query) {
        List<PmsProjectTemplateVO> records = pmsProjectTemplateDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(records)) {
            records.forEach(record -> transferData(record));
        }
        return records;
    }

    @Override
    public PmsProjectTemplateVO queryByKey(Long key) {
        PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByKey(key);
        if (!ObjectUtils.isEmpty(pmsProjectTemplateVO)) {
            transferData(pmsProjectTemplateVO);
            //查询 项目活动
            pmsProjectTemplateVO.setActList(pmsProjectTemplateActService.queryByTemplateId(key));
        }
        return pmsProjectTemplateVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectTemplateVO insert(PmsProjectTemplatePayload payload) {
        // 非空  重复验证
        if (ObjectUtils.isEmpty(payload.getTemplateName())) {
            throw TwException.error("", "名称不可为空，请核验！");
        }
        PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByName(payload.getTemplateName());
        if (!ObjectUtils.isEmpty(pmsProjectTemplateVO)) {
            throw TwException.error("", "名称可不重复，请核验！");
        }
        if (ObjectUtils.isEmpty(payload.getTemplateStatus())) {
            // 新建 默认启用状态
            payload.setTemplateStatus(ProjectTemplateEnum.ENABLE.getCode());
        }

        //保存模板
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entityDo = pmsProjectTemplateRepo.save(entityDo);
        PmsProjectTemplateVO templateVO = PmsProjectTemplateConvert.INSTANCE.toVo(entityDo);

        //保存模板活动
        List<PmsProjectTemplateActPayload> actList = payload.getActList();
        if (!ObjectUtils.isEmpty(actList)) {
            actList.forEach(v -> v.setTemplateId(templateVO.getId()));
            templateVO.setActList(pmsProjectTemplateActService.batchSave(actList));
        }

//        //记录日志
//        final String fieldsCreateLog = "新增模板：【" + entityDo.getTemplateName() + "】";
//       // final String fieldsCreateLog = changeFieldLogUtil.getFieldsCreateLog(entityDo);
//        logService.saveNewLog(templateVO.getId(), ComLogTypeEnum.pms_project_template.getCode(), fieldsCreateLog);

        return templateVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsProjectTemplateVO update(PmsProjectTemplatePayload payload) {
        // 重复验证
        PmsProjectTemplateDO entity = pmsProjectTemplateRepo.findById(payload.getId()).orElseGet(PmsProjectTemplateDO::new);
        if (!entity.getTemplateName().equals(payload.getTemplateName())) {
            PmsProjectTemplateVO pmsProjectTemplateVO = pmsProjectTemplateDAO.queryByName(payload.getTemplateName());
            if (!ObjectUtils.isEmpty(pmsProjectTemplateVO)) {
                throw TwException.error("", "名称可不重复，请核验！");
            }
        }
        Assert.notNull(entity.getId(), "不存在");

        //更新模板
        PmsProjectTemplateDO entityDo = PmsProjectTemplateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        PmsProjectTemplateVO templateVO = PmsProjectTemplateConvert.INSTANCE.toVo(pmsProjectTemplateRepo.save(entity));

        //更新模板活动
        List<PmsProjectTemplateActPayload> actList = payload.getActList();
        if (!ObjectUtils.isEmpty(actList)) {
            actList.forEach(v -> v.setTemplateId(payload.getId()));
            templateVO.setActList(pmsProjectTemplateActService.batchSave(actList));
        }
        return templateVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            //删除项目模板  无需校验
            pmsProjectTemplateDAO.deleteSoft(keys);
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateStatus(List<Long> keys, Integer templateStatus) {
        if (ObjectUtils.isEmpty(templateStatus)) {
            throw TwException.error("", "切换状态不能为空，请核验！");
        }
        if (!templateStatus.equals(ProjectTemplateEnum.DISABLE.getCode()) && !templateStatus.equals(ProjectTemplateEnum.ENABLE.getCode())) {
            throw TwException.error("", "状态值不符合，请核验！");
        }
        if (!keys.isEmpty()) {
            return pmsProjectTemplateDAO.updateStatus(keys, templateStatus);
        } else {
            throw TwException.error("", "操作数据不可为空，请核验！");
        }
    }

}
