package com.elitesland.tw.tw5.server.prd.purchase.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;
import java.time.LocalDate;
import java.math.BigDecimal;

/**
 * 预付款收据管理
 *
 * @author wangly
 * @date 2024-05-27
 */
@Entity
@Table(name = "bill_ver_detail", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "bill_ver_detail", comment = "预付款收据管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BillVerDetailDO extends BaseModel implements Serializable  {
    /** 付款申请单ID */
    @Comment("付款申请单ID")
    @Column()
    private Long paymentApplyId;
    /** 票据号 */
    @Comment("票据号")
    @Column()
    private String billNo;
    /** 本次核销金额 */
    @Comment("本次核销金额")
    @Column()
    private BigDecimal theAmt;
    /** 票据金额 */
    @Comment("票据金额")
    @Column()
    private BigDecimal invoiceAmt;
    /** 已核销金额 */
    @Comment("已核销金额")
    @Column()
    private BigDecimal writtenOffAmt;
    /** 税率 */
    @Comment("税率")
    @Column()
    private String rate;
    /** 票据日期 */
    @Comment("票据日期")
    @Column()
    private LocalDate invoiceDate;
    /** 关联采购明细Id */
    @Comment("关联采购明细Id")
    @Column()
    private Long purConOrAgreementDetailId;
    /** 关联采购明细Id */
    @Comment("关联采购明细Id")
    @Column()
    private Long purConDetailId;
    /** 票据附件 */
    @Comment("票据附件")
    @Column()
    private String fileCode;
    /** jde票据公司 */
    @Comment("jde票据公司")
    @Column()
    private String jdecompany;
    /** jde单据号 */
    @Comment("jde单据号")
    @Column()
    private String jdedocumentno;
    /** jde单据类型 */
    @Comment("jde单据类型")
    @Column()
    private String jdedocumenttype;
    /** jde付款项 */
    @Comment("jde付款项")
    @Column()
    private String jdepaymentitem;
    /** jde发票凭证失败原因 */
    @Comment("jde发票凭证失败原因")
    @Column()
    private String jdeinvoicefailreason;
    /** 预留字段1 */
    @Comment("预留字段1")
    @Column()
    private String ext1;
    /** 预留字段2 */
    @Comment("预留字段2")
    @Column()
    private String ext2;
    /** 预留字段3 */
    @Comment("预留字段3")
    @Column()
    private String ext3;
    /** 预留字段4 */
    @Comment("预留字段4")
    @Column()
    private String ext4;
    /** 预留字段5 */
    @Comment("预留字段5")
    @Column()
    private String ext5;
    /** 预留字段6 */
    @Comment("预留字段6")
    @Column()
    private String ext6;
    /** 预留字段7 */
    @Comment("预留字段7")
    @Column()
    private String ext7;
    /** 预留字段8 */
    @Comment("预留字段8")
    @Column()
    private String ext8;

    /**
     * 发票凭证
     */
    @ApiModelProperty("发票凭证")
    @Column()
    private String invoiceVoucher;

    public void copy(BillVerDetailDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
