package com.elitesland.tw.tw5.server.prd.schedule.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmActActivityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmActActivityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActActivityVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.prj.vo.PrjProjectMemberVO;
import com.elitesland.tw.tw5.api.prd.schedule.payload.*;
import com.elitesland.tw.tw5.api.prd.schedule.query.PrdActivityCalendarQuery;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdActivityCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdCalendarService;
import com.elitesland.tw.tw5.api.prd.schedule.sercvice.PrdScheduleService;
import com.elitesland.tw.tw5.api.prd.schedule.vo.*;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.QyWx.service.QyWxCommunicationService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.FunctionSelectionEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.schedule.convert.PrdActivityCalendarConvert;
import com.elitesland.tw.tw5.server.prd.schedule.dao.PrdActivityCalendarDAO;
import com.elitesland.tw.tw5.server.prd.schedule.entity.PrdActivityCalendarDO;
import com.elitesland.tw.tw5.server.prd.schedule.repo.PrdActivityCalendarRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;


@Service
@RequiredArgsConstructor
@Slf4j
public class PrdActivityCalendarServiceImpl extends BaseServiceImpl implements PrdActivityCalendarService {

    private final PrdActivityCalendarRepo prdActivityCalendarRepo;
    private final PrdActivityCalendarDAO prdActivityCalendarDAO;

    private final CrmActActivityService activityService;

    private final PrdScheduleService scheduleService;

    private final PrdCalendarService calendarService;

    private final CacheUtil cacheUtil;

    private final QyWxCommunicationService wxService;
    private final PrdSystemRoleService roleService;


    @Override
    public PagingVO<PrdActivityCalendarVO> queryPaging(PrdActivityCalendarQuery query) {
        CrmActActivityQuery actActivityQuery = new CrmActActivityQuery();
        activityService.paging(actActivityQuery);
        return prdActivityCalendarDAO.queryPaging(query);
    }

    @Override
    public List<PrdActivityCalendarVO> queryListDynamic(PrdActivityCalendarQuery query) {
        return prdActivityCalendarDAO.queryListDynamic(query);
    }

    @Override
    public PrdActivityCalendarVO queryByKey(Long key) {
        PrdActivityCalendarDO entity = prdActivityCalendarRepo.findById(key).orElseGet(PrdActivityCalendarDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PrdActivityCalendarVO vo = PrdActivityCalendarConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdActivityCalendarVO insert(PrdActivityCalendarPayload payload) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!ObjectUtils.isEmpty(payload.getParticipantsList())) {
            String participants = payload.getParticipantsList().stream()
                    .map(Object::toString)
                    .collect(Collectors.joining(","));
            payload.setParticipants(participants);
        }
        PrdActivityCalendarDO entityDo = PrdActivityCalendarConvert.INSTANCE.toDo(payload);
        //创建日程
        List<PrdCalendarVO> prdCalendarVOList = calendarService.queryByUser(loginUserId);
        PrdCalendarVO prdCalendarVO = prdCalendarVOList.get(0);
        PrdSchedulePayload schedulePayload = new PrdSchedulePayload();
        if (!ObjectUtils.isEmpty(payload.getId())) {
            PrdActivityCalendarDO entity = prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
            Assert.notNull(entity.getId(), "不存在");
            PrdScheduleVO prdScheduleVO = scheduleService.queryDetail(entity.getScheduleId());
            schedulePayload.setQyWxScheduleId(prdScheduleVO.getQyWxScheduleId());
            schedulePayload.setId(entity.getScheduleId());
        }
        schedulePayload.setStartTime(entityDo.getStartTime());
        schedulePayload.setEndTime(entityDo.getEndTime());
        schedulePayload.setLocation(entityDo.getLocation());
        schedulePayload.setTitle(entityDo.getTitle());
        schedulePayload.setCalId(prdCalendarVO.getId());
        PrdScheduleRepeatPayload repeatPayload = new PrdScheduleRepeatPayload();
        repeatPayload.setRepeatInterval(1);
        schedulePayload.setRepeat(repeatPayload);
        schedulePayload.setAllDay(0);
        schedulePayload.setIsRepeat(0);
        schedulePayload.setCalId(prdCalendarVO.getId());
        List<PrdScheduleAttendeesPayload> attendances = new ArrayList<>();
        PrdScheduleAttendeesPayload loginPayload = new PrdScheduleAttendeesPayload();
        loginPayload.setUserId(loginUserId);
        attendances.add(loginPayload);
        if (!ObjectUtils.isEmpty(payload.getParticipantsList())) {
            for (Long userId : payload.getParticipantsList()) {
                PrdScheduleAttendeesPayload attendeesPayload = new PrdScheduleAttendeesPayload();
                attendeesPayload.setUserId(userId);
                attendances.add(attendeesPayload);
            }
        }
        if (!ObjectUtils.isEmpty(payload.getManageUserId())) {
            PrdScheduleAttendeesPayload manager = new PrdScheduleAttendeesPayload();
            manager.setUserId(payload.getManageUserId());
            attendances.add(manager);
        }
        schedulePayload.setAttendees(attendances);
        schedulePayload.setCreateUserId(loginUserId);
        PrdScheduleVO prdScheduleVO = scheduleService.insertOrUpdate(schedulePayload);
        entityDo.setScheduleId(prdScheduleVO.getId());
        return PrdActivityCalendarConvert.INSTANCE.toVo(prdActivityCalendarRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdActivityCalendarVO update(PrdActivityCalendarPayload payload) {
        PrdActivityCalendarDO entity = prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
        PrdActivityCalendarDO entityDo = PrdActivityCalendarConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PrdActivityCalendarConvert.INSTANCE.toVo(prdActivityCalendarRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PrdActivityCalendarPayload payload) {
        PrdActivityCalendarDO entity = prdActivityCalendarRepo.findById(payload.getId()).orElseGet(PrdActivityCalendarDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = prdActivityCalendarDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            prdActivityCalendarDAO.deleteSoft(keys);
        }
    }

    @Override
    public PrdActivityCalendarAbleVO queryList(PrdActivityCalendarQuery query) {
        PrdActivityCalendarAbleVO prdActivityCalendarAbleVO = new PrdActivityCalendarAbleVO();
        Long loginUserId = GlobalUtil.getLoginUserId();
        List<Long> userIds = roleService.queryUserIdByRoleCode(RoleEnum.MARKET_RES.getCode());
        Boolean createable = userIds.contains(loginUserId);
        prdActivityCalendarAbleVO.setCreateable(createable);
        CrmActActivityQuery actActivityQuery = new CrmActActivityQuery();
        if (!ObjectUtils.isEmpty(query.getYearMonth())) {
            String dateString = query.getYearMonth() + "-01";
            DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE;
            LocalDate localDate = LocalDate.parse(dateString, formatter);
            query.setYearMonthDate(localDate);
            actActivityQuery.setYearMonthDate(localDate);
        }
        if (!ObjectUtils.isEmpty(query.getProjectTime())) {
            actActivityQuery.setProjectTime(query.getProjectTime());
        }
        List<CrmActActivityVO> actActivityVOList = activityService.queryListDynamic(actActivityQuery);
        List<PrdActivityCalendarVO> actActivityVoList = new ArrayList<>();
        LocalDateTime now = LocalDateTime.now();
        for (CrmActActivityVO activityVO : actActivityVOList) {
            CrmActActivityVO crmActActivityVO = activityService.queryByKey(activityVO.getId());
            PrdActivityCalendarVO activityCalendarVO = new PrdActivityCalendarVO();
            activityCalendarVO.setId(activityVO.getId());
            activityCalendarVO.setProjectName(activityVO.getProjectName());
            activityCalendarVO.setStartTime(activityVO.getStartTime().atTime(0, 0, 0));
            activityCalendarVO.setEndTime(activityVO.getEndTime().atTime(23, 59, 59));
            activityCalendarVO.setActivityAddr(activityVO.getActivityAddr());
            activityCalendarVO.setType(cacheUtil.transferSystemSelection(FunctionSelectionEnum.CrmPlanDetailType.getCode(), activityVO.getDetailType()));
            activityCalendarVO.setScale(activityVO.getActivityScale());
            activityCalendarVO.setSourceType("activity");
            activityCalendarVO.setManageUserId(activityVO.getManageUserId());
            activityCalendarVO.setLocation(activityVO.getActivityAddr());
            List<PrjProjectMemberVO> memberVOS = crmActActivityVO.getMemberVOS();
            List<String> participantsNameList = new ArrayList<>();
            for (PrjProjectMemberVO prjProjectMemberVO : memberVOS) {
                participantsNameList.add(prjProjectMemberVO.getEmployeeName());
            }
            activityCalendarVO.setParticipantsNameList(participantsNameList);
            if (activityCalendarVO.getStartTime().isAfter(now)) {
                activityCalendarVO.setStatus("未开始");
            }
            if (activityCalendarVO.getEndTime().isBefore(now)) {
                activityCalendarVO.setStatus("已结束");
            }
            if (activityCalendarVO.getStartTime().isBefore(now) && activityCalendarVO.getEndTime().isAfter(now)) {
                activityCalendarVO.setStatus("进行中");
            }
            activityCalendarVO.setEditable(false);
            boolean containsUser = false;
            if (activityVO.getScheduleId() != null) {
                PrdScheduleVO prdScheduleVO = scheduleService.queryDetail(activityVO.getScheduleId());
                List<PrdScheduleAttendeesVO> attendeesVOS = prdScheduleVO.getAttendeesVOS();
                containsUser = attendeesVOS.stream()
                        .anyMatch(attendeesVO -> attendeesVO.getUserId().equals(loginUserId));
            }
            activityCalendarVO.setSync(containsUser);
            actActivityVoList.add(activityCalendarVO);
        }
        List<PrdActivityCalendarVO> allCalender = new ArrayList<>(actActivityVoList);
        List<PrdActivityCalendarVO> activityCalendarVOList = prdActivityCalendarDAO.queryListDynamic(query);
        activityCalendarVOList.forEach(prdActivityCalendarVO -> {
            prdActivityCalendarVO.setSourceType("appActivity");
            prdActivityCalendarVO.setProjectName(prdActivityCalendarVO.getTitle());
            if (!ObjectUtils.isEmpty(prdActivityCalendarVO.getParticipants())) {
                String[] participantsArray = prdActivityCalendarVO.getParticipants().split(",");
                List<Long> participantsList = Arrays.stream(participantsArray)
                        .map(Long::parseLong)
                        .collect(Collectors.toList());
                prdActivityCalendarVO.setParticipantsList(participantsList);
            }
            if (prdActivityCalendarVO.getStartTime().isAfter(now)) {
                prdActivityCalendarVO.setStatus("未开始");
            }
            if (prdActivityCalendarVO.getEndTime().isBefore(now)) {
                prdActivityCalendarVO.setStatus("已结束");
            }
            if (prdActivityCalendarVO.getStartTime().isBefore(now) && prdActivityCalendarVO.getEndTime().isAfter(now)) {
                prdActivityCalendarVO.setStatus("进行中");
            }
            boolean containsUser = false;
            if (prdActivityCalendarVO.getScheduleId() != null) {
                PrdScheduleVO prdScheduleVO = scheduleService.queryDetail(prdActivityCalendarVO.getScheduleId());
                List<PrdScheduleAttendeesVO> attendeesVOS = prdScheduleVO.getAttendeesVOS();
                containsUser = attendeesVOS.stream()
                        .anyMatch(attendeesVO -> attendeesVO.getUserId().equals(loginUserId));
            }
            prdActivityCalendarVO.setSync(containsUser);
            prdActivityCalendarVO.setEditable(prdActivityCalendarVO.getCreateUserId().equals(loginUserId));
            if (!ObjectUtils.isEmpty(prdActivityCalendarVO.getParticipantsList())) {
                List<String> participantsNameList = new ArrayList<>();
                for (Long userId : prdActivityCalendarVO.getParticipantsList()) {
                    String userName = cacheUtil.getUserName(userId);
                    participantsNameList.add(userName);
                }
                prdActivityCalendarVO.setParticipantsNameList(participantsNameList);
            }

        });
        allCalender.addAll(activityCalendarVOList);
        allCalender.sort(Comparator.comparing(PrdActivityCalendarVO::getStartTime).reversed());
        prdActivityCalendarAbleVO.setActivityCalendarVOList(allCalender);
        return prdActivityCalendarAbleVO;
    }

    @Override
    @Transactional
    public void syncSchedule(Long id, String type) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        PrdOrgEmployeeVO employee = cacheUtil.getEmployee(loginUserId);
        String wecomId = employee.getWecomId();
        if (type.equals("activity")) {
            CrmActActivityVO crmActActivityVO = activityService.queryByKey(id);
            Long scheduleId = crmActActivityVO.getScheduleId();
            if (scheduleId != null) {
                List<QyWxScheduleAttendeesPayload> attendees = new ArrayList<>();
                QyWxScheduleAttendeesPayload qyWxScheduleAttendeesPayload = new QyWxScheduleAttendeesPayload();
                qyWxScheduleAttendeesPayload.setUserid(wecomId);
                attendees.add(qyWxScheduleAttendeesPayload);
                PrdScheduleVO prdScheduleVO = scheduleService.queryDetail(scheduleId);
                QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
                qyWxSchedulePayload.setSchedule_id(prdScheduleVO.getQyWxScheduleId());
                qyWxSchedulePayload.setAttendees(attendees);
                scheduleService.addAttendees(scheduleId, loginUserId);
                wxService.addAttendees(qyWxSchedulePayload);
            } else {
                PrdSchedulePayload schedulePayload = new PrdSchedulePayload();
                schedulePayload.setId(scheduleId);
                schedulePayload.setStartTime(crmActActivityVO.getStartTime().atTime(0, 0, 0));
                schedulePayload.setEndTime(crmActActivityVO.getEndTime().atTime(23, 59, 59));
                schedulePayload.setLocation(crmActActivityVO.getActivityAddr());
                schedulePayload.setTitle(crmActActivityVO.getProjectName());
                List<PrdScheduleAttendeesPayload> attendeesPayloadList = new ArrayList<>();
                PrdScheduleAttendeesPayload attendeesPayload = new PrdScheduleAttendeesPayload();
                attendeesPayload.setUserId(loginUserId);
                attendeesPayloadList.add(attendeesPayload);
                schedulePayload.setAttendees(attendeesPayloadList);
                List<PrdCalendarVO> prdCalendarVOList = calendarService.queryByUser(loginUserId);
                PrdCalendarVO prdCalendarVO = prdCalendarVOList.get(0);
                Long calId = prdCalendarVO.getId();
                schedulePayload.setCreateUserId(loginUserId);
                PrdScheduleRepeatPayload repeatPayload = new PrdScheduleRepeatPayload();
                repeatPayload.setRepeatInterval(1);
                schedulePayload.setRepeat(repeatPayload);
                schedulePayload.setAllDay(0);
                schedulePayload.setIsRepeat(0);
                schedulePayload.setCalId(calId);
                PrdScheduleVO prdScheduleVO = scheduleService.insertOrUpdate(schedulePayload);
                activityService.updateSchedule(id, prdScheduleVO.getId());
            }
        } else {
            PrdActivityCalendarVO activityCalendarVO = queryByKey(id);
            Long scheduleId = activityCalendarVO.getScheduleId();
            List<QyWxScheduleAttendeesPayload> attendees = new ArrayList<>();
            QyWxScheduleAttendeesPayload qyWxScheduleAttendeesPayload = new QyWxScheduleAttendeesPayload();
            qyWxScheduleAttendeesPayload.setUserid(wecomId);
            attendees.add(qyWxScheduleAttendeesPayload);
            PrdScheduleVO prdScheduleVO = scheduleService.queryDetail(scheduleId);
            QyWxSchedulePayload qyWxSchedulePayload = new QyWxSchedulePayload();
            qyWxSchedulePayload.setSchedule_id(prdScheduleVO.getQyWxScheduleId());
            qyWxSchedulePayload.setAttendees(attendees);
            scheduleService.addAttendees(scheduleId, loginUserId);
            wxService.addAttendees(qyWxSchedulePayload);
        }
    }

}

