package com.elitesland.tw.tw5.server.prd.shorturl.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

/**
 * 短链服务关系表
 *
 * @author duwh
 * @date 2023-05-19
 */
@Entity
@Table(name = "prd_short_url_ref", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "prd_short_url_ref", comment = "短链服务关系表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class ShortUrlRefDO extends BaseModel implements Serializable  {
    /** 短链地址 */
    @Comment("短链地址")
    @Column()
    private String shortUrl;
    /** 短链地址-相对地址 */
    @Comment("短链地址-相对地址")
    @Column()
    private String shortUrlRelative;
    /** 短链地址识别码 */
    @Comment("短链地址识别码")
    @Column()
    private String code;
    /** 长链地址 */
    @Comment("长链地址")
    @Column()
    private String longUrl;
    /** 访问数量 */
    @Comment("访问数量")
    @Column()
    private Integer visitNum = 0;
    /** 拓展1 */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /** 拓展2 */
    @Comment("拓展2")
    @Column()
    private String ext2;
    /** 拓展3 */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /** 拓展4 */
    @Comment("拓展4")
    @Column()
    private String ext4;
    /** 拓展5 */
    @Comment("拓展5")
    @Column()
    private String ext5;

    public void copy(ShortUrlRefDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
