package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemBusinessObjectPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemBusinessObjectQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemBusinessObjectService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemBusinessObjectVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 业务对象
 *
 * @Author Bill
 * @Date 2023/9/15 11:27
 **/
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/system")
@Slf4j
public class PrdSystemBusinessObjectController {

    private final PrdSystemBusinessObjectService service;

    /**
     * 业务对象新增
     * @param payload
     * @return
     */
    @PostMapping("/businessObject")
    public TwOutputUtil insert(PrdSystemBusinessObjectPayload payload){
        return TwOutputUtil.ok(service.insert(payload));
    }

    /**
     * 业务对象更新
     * @param payload
     * @return
     */
    @PutMapping("/businessObject")
    public TwOutputUtil update(PrdSystemBusinessObjectPayload payload){
        return TwOutputUtil.ok(service.update(payload));
    }


    /**
     * 分页
     * @param query
     * @return
     */
    @GetMapping("/businessObject/paging")
    public TwOutputUtil paging(PrdSystemBusinessObjectQuery query){
        PagingVO<PrdSystemBusinessObjectVO> paging = service.paging(query);
        return TwOutputUtil.ok(paging);
    }

    /**
     * 业务对象删除
     *
     * @param keys
     * @return
     */
    @DeleteMapping("/businessObject/deleteSoft")
    public TwOutputUtil deleteSoft(Long[] keys){
        service.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    /**
     * 主键查询
     * @return
     */
    @GetMapping("/businessObject/{id}")
    public TwOutputUtil get(@PathVariable Long id){
        return TwOutputUtil.ok(service.get(id));
    }

    /**
     * 业务对象附带 功能列表
     * @return
     */
    @GetMapping("/businessObject/listFunction")
    public TwOutputUtil listFunction() {
        return TwOutputUtil.ok(service.listFunction());
    }

    /**
     * 业务对象的 对应 角色下配置信息获取
     * @param query
     * @return
     */
    @GetMapping("/businessObject/listObjectConfig")
    public TwOutputUtil listObjectConfig(PrdSystemBusinessObjectQuery query) {
        return TwOutputUtil.ok(service.listObjectConfig(query));
    }

    /**
     * 功能对应的 角色下的配置信息 获取
     * @param query
     * @return
     */
    @GetMapping("/businessObject/listFunctionConfig")
    public TwOutputUtil listFunctionConfig(PrdSystemBusinessObjectQuery query) {
        return TwOutputUtil.ok(service.listFunctionConfig(query));
    }

    /**
     * 带拥有权限规则的功能
     * @param query
     * @return
     */
    @GetMapping("/businessObject/listRuleFunction")
    public TwOutputUtil listRuleFunction(PrdSystemBusinessObjectQuery query){
        return TwOutputUtil.ok(service.listFunction(query));
    }

}
