package com.elitesland.tw.tw5.server.prd.system.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.system.payload.PrdSystemPermissionTableFieldsPayload;
import com.elitesland.tw.tw5.api.prd.system.query.PrdSystemPermissionTableFieldsQuery;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemPermissionTableFieldsService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdSystemPermissionTableFieldsVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @folder 页面配置
 * @date 2023-06-14
 */
@Api(tags = "业务对象权限字段明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/permissionBusinessTableFields")
@Slf4j
public class PrdSystemPermissionTableFieldsController {

    private final PrdSystemPermissionTableFieldsService businessTableFieldsService;

    /**
     * 业务对象字段明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PostMapping
    @ApiOperation("业务对象字段明细-新增")
    public TwOutputUtil<PrdSystemPermissionTableFieldsVO> insert(@RequestBody PrdSystemPermissionTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.insert(payload));
    }

    /**
     * 业务对象字段明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-查询列表")
    public TwOutputUtil<List<PrdSystemPermissionTableFieldsVO>> queryList(PrdSystemPermissionTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryListDynamic(query));
    }

    /**
     * 业务对象字段明细-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping
    @ApiOperation("业务对象字段明细-更新")
    public TwOutputUtil<PrdSystemPermissionTableFieldsVO> update(@RequestBody PrdSystemPermissionTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.update(payload));
    }

    /**
     * 业务对象字段明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping("update")
    @ApiOperation("业务对象字段明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PrdSystemPermissionTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.updateByKeyDynamic(payload));
    }

    /**
     * 业务对象字段明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-主键查询")
    public TwOutputUtil<PrdSystemPermissionTableFieldsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTableFieldsService.queryByKey(key));
    }

    /**
     * 业务对象字段明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-分页")
    public TwOutputUtil<PagingVO<PrdSystemPermissionTableFieldsVO>> paging(PrdSystemPermissionTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryPaging(query));
    }


    /**
     * 业务对象字段明细-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 页面配置
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务对象字段明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessTableFieldsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

