package com.elitesland.tw.tw5.server.prd.system.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_system_role")
@org.hibernate.annotations.Table(appliesTo = "prd_system_role", comment = "系统角色表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdSystemRoleDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;


    @Comment("角色编号")
    @Column()
    private String roleCode;

    @Comment("角色名称")
    @Column()
    private String roleName;

    @Comment("角色排序")
    @Column()
    private Integer sortIndex;

    @Comment("角色启用状态")
    @Column()
    private Boolean enabled;
}
