/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimBusItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimItemConfigRefPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimBusItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimItemConfigRefQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimBusItemConfigService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimItemConfigRefService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimBusItemConfigVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimItemConfigRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimBusItemConfigConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimBusItemConfigDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimBusItemConfigDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimBusItemConfigRepo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class AccReimBusItemConfigServiceImpl
extends BaseServiceImpl
implements AccReimBusItemConfigService {
    private static final Logger log = LoggerFactory.getLogger(AccReimBusItemConfigServiceImpl.class);
    private final AccReimBusItemConfigRepo repo;
    private final AccReimBusItemConfigDAO dao;
    private final AccReimItemConfigRefService accReimItemConfigRefService;
    private final AccBusinessItemService accBusinessItemService;

    public PagingVO<AccReimBusItemConfigVO> queryPaging(AccReimBusItemConfigQuery query) {
        return this.dao.queryPaging(query);
    }

    public List<AccReimBusItemConfigVO> queryListDynamic(AccReimBusItemConfigQuery query) {
        List<AccReimBusItemConfigVO> accReimBusItemConfigVOS = this.dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimBusItemConfigVOS)) {
            List configIds = accReimBusItemConfigVOS.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            AccReimItemConfigRefQuery refQuery = new AccReimItemConfigRefQuery();
            refQuery.setReimItemConfigIds(configIds);
            List accReimItemConfigRefVOS = this.accReimItemConfigRefService.queryListDynamic(refQuery);
            Map<Long, List<AccReimItemConfigRefVO>> refMap = accReimItemConfigRefVOS.stream().collect(Collectors.groupingBy(AccReimItemConfigRefVO::getReimItemConfigId));
            accReimBusItemConfigVOS.forEach(vo -> {
                List detail = (List)refMap.get(vo.getId());
                if (!ObjectUtils.isEmpty((Object)detail)) {
                    List busItemIds = detail.stream().map(AccReimItemConfigRefVO::getBusAccItemId).collect(Collectors.toList());
                    AccBusinessItemQuery businessItemQuery = new AccBusinessItemQuery();
                    businessItemQuery.setIdList(busItemIds);
                    List accBusinessItemVOS = this.accBusinessItemService.queryListDynamic(businessItemQuery);
                    if (!ObjectUtils.isEmpty((Object)accBusinessItemVOS)) {
                        vo.setBusItemVolist(accBusinessItemVOS);
                    }
                }
            });
        }
        return accReimBusItemConfigVOS;
    }

    public AccReimBusItemConfigVO queryByKey(Long key) {
        AccReimBusItemConfigVO accReimBusItemConfigVO = this.dao.queryByKey(key);
        AccReimItemConfigRefQuery query = new AccReimItemConfigRefQuery();
        query.setReimItemConfigId(key);
        List accReimItemConfigRefVOS = this.accReimItemConfigRefService.queryListDynamic(query);
        if (!ObjectUtils.isEmpty((Object)accReimItemConfigRefVOS)) {
            List busItemIds = accReimItemConfigRefVOS.stream().map(AccReimItemConfigRefVO::getBusAccItemId).collect(Collectors.toList());
            AccBusinessItemQuery businessItemQuery = new AccBusinessItemQuery();
            businessItemQuery.setIdList(busItemIds);
            List accBusinessItemVOS = this.accBusinessItemService.queryListDynamic(businessItemQuery);
            if (!ObjectUtils.isEmpty((Object)accBusinessItemVOS)) {
                accReimBusItemConfigVO.setBusItemVolist(accBusinessItemVOS);
            }
        }
        return accReimBusItemConfigVO;
    }

    @Transactional
    public AccReimBusItemConfigVO insert(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigQuery query = new AccReimBusItemConfigQuery();
        query.setReasonType(payload.getReasonType());
        query.setReimDocType(payload.getReimDocType());
        List<AccReimBusItemConfigVO> accReimBusItemConfigVOS = this.dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimBusItemConfigVOS)) {
            log.error("\u5f53\u524d\u62a5\u9500\u7c7b\u578b\u3001\u4e8b\u7531\u7c7b\u578b\u5bf9\u5e94\u7684\u79d1\u76ee\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01,\u62a5\u9500\u7c7b\u578b is {}\uff0c\u4e8b\u7531\u7c7b\u578b is {}", (Object)payload.getReimDocType(), (Object)payload.getReasonType());
            throw TwException.error("", "\u5f53\u524d\u62a5\u9500\u7c7b\u578b\u3001\u4e8b\u7531\u7c7b\u578b\u5bf9\u5e94\u7684\u79d1\u76ee\u914d\u7f6e\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
        }
        AccReimBusItemConfigDO entityDo = AccReimBusItemConfigConvert.INSTANCE.toDo(payload);
        AccReimBusItemConfigVO vo = AccReimBusItemConfigConvert.INSTANCE.toVo((AccReimBusItemConfigDO)this.repo.save(entityDo));
        ArrayList refPayloads = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)payload.getBusItemIdList())) {
            payload.getBusItemIdList().forEach(busItemId -> {
                AccReimItemConfigRefPayload refPayload = new AccReimItemConfigRefPayload();
                refPayload.setBusAccItemId(busItemId);
                refPayload.setReimItemConfigId(vo.getId());
                refPayloads.add(refPayload);
            });
        }
        this.accReimItemConfigRefService.batchInsert(refPayloads);
        return vo;
    }

    @Transactional
    public AccReimBusItemConfigVO update(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigDO entity = this.repo.findById(payload.getId()).orElseGet(AccReimBusItemConfigDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        AccReimBusItemConfigDO entityDo = AccReimBusItemConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimBusItemConfigConvert.INSTANCE.toVo((AccReimBusItemConfigDO)this.repo.save(entity));
    }

    @Transactional
    public void updateByKeyDynamic(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigVO vo = this.dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error("", "\u5f53\u524d\u79d1\u76ee\u914d\u7f6e\u4e0d\u5b58\u5728\uff0cid:" + payload.getId());
        }
        this.dao.updateByKeyDynamic(payload);
        this.accReimItemConfigRefService.delByReimConfigId(vo.getId());
        ArrayList refPayloads = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)payload.getBusItemIdList())) {
            payload.getBusItemIdList().forEach(busItemId -> {
                AccReimItemConfigRefPayload refPayload = new AccReimItemConfigRefPayload();
                refPayload.setBusAccItemId(busItemId);
                refPayload.setReimItemConfigId(vo.getId());
                refPayloads.add(refPayload);
            });
        }
        this.accReimItemConfigRefService.batchInsert(refPayloads);
    }

    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.dao.deleteSoft(keys);
            keys.forEach(arg_0 -> ((AccReimItemConfigRefService)this.accReimItemConfigRefService).delByReimConfigId(arg_0));
        }
    }

    public AccReimBusItemConfigServiceImpl(AccReimBusItemConfigRepo repo, AccReimBusItemConfigDAO dao, AccReimItemConfigRefService accReimItemConfigRefService, AccBusinessItemService accBusinessItemService) {
        this.repo = repo;
        this.dao = dao;
        this.accReimItemConfigRefService = accReimItemConfigRefService;
        this.accBusinessItemService = accBusinessItemService;
    }
}

