/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.administration.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.administration.payload.CertificationLicensePayload;
import com.elitesland.tw.tw5.api.prd.administration.query.CertificationLicenseQuery;
import com.elitesland.tw.tw5.api.prd.administration.service.CertificationLicenseService;
import com.elitesland.tw.tw5.api.prd.administration.vo.CertificationLicenseVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.server.prd.administration.convert.CertificationLicenseConvert;
import com.elitesland.tw.tw5.server.prd.administration.dao.CertificationLicenseDAO;
import com.elitesland.tw.tw5.server.prd.administration.entity.CertificationLicenseDO;
import com.elitesland.tw.tw5.server.prd.administration.repo.CertificationLicenseRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import com.xxl.job.core.log.XxlJobLogger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class CertificationLicenseServiceImpl
extends BaseServiceImpl
implements CertificationLicenseService {
    private static final Logger log = LoggerFactory.getLogger(CertificationLicenseServiceImpl.class);
    private final CertificationLicenseRepo certificationLicenseRepo;
    private final CertificationLicenseDAO certificationLicenseDAO;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;
    private final FileUtil fileUtil;

    public PagingVO<CertificationLicenseVO> queryPaging(CertificationLicenseQuery query) {
        PagingVO<CertificationLicenseVO> certificationLicenseVOPagingVO = this.certificationLicenseDAO.queryPaging(query);
        if (!CollectionUtils.isEmpty((Collection)certificationLicenseVOPagingVO.getRecords())) {
            certificationLicenseVOPagingVO.stream().forEach(p -> this.translate((CertificationLicenseVO)p));
        }
        return certificationLicenseVOPagingVO;
    }

    public List<CertificationLicenseVO> queryListDynamic(CertificationLicenseQuery query) {
        List<CertificationLicenseVO> certificationLicenseVOS = this.certificationLicenseDAO.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(certificationLicenseVOS)) {
            certificationLicenseVOS.stream().forEach(p -> this.translate((CertificationLicenseVO)p));
        }
        return certificationLicenseVOS;
    }

    public CertificationLicenseVO queryByKey(Long key) {
        CertificationLicenseDO entity = this.certificationLicenseRepo.findById(key).orElseGet(CertificationLicenseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CertificationLicenseVO vo = CertificationLicenseConvert.INSTANCE.toVo(entity);
        this.translate(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public CertificationLicenseVO insert(CertificationLicensePayload payload) {
        CertificationLicenseDO entityDo = CertificationLicenseConvert.INSTANCE.toDo(payload);
        return CertificationLicenseConvert.INSTANCE.toVo((CertificationLicenseDO)this.certificationLicenseRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public CertificationLicenseVO update(CertificationLicensePayload payload) {
        CertificationLicenseDO entity = this.certificationLicenseRepo.findById(payload.getId()).orElseGet(CertificationLicenseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        CertificationLicenseDO entityDo = CertificationLicenseConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return CertificationLicenseConvert.INSTANCE.toVo((CertificationLicenseDO)this.certificationLicenseRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CertificationLicensePayload payload) {
        CertificationLicenseDO entity = this.certificationLicenseRepo.findById(payload.getId()).orElseGet(CertificationLicenseDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.certificationLicenseDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.certificationLicenseDAO.deleteSoft(keys);
        }
    }

    private void translate(CertificationLicenseVO vo) {
        vo.setFileData(this.fileUtil.getFileDatas(vo.getFileCode()));
    }

    @Transactional(rollbackFor={Exception.class})
    public void certificationLicenseInvaildAlter() {
        LocalDateTime time = LocalDateTime.now();
        XxlJobLogger.log((String)"\u8d44\u8d28\u8bc1\u7167\u8fc7\u671f\u63d0\u9192\u5f00\u59cb...", (Object[])new Object[0]);
        XxlJobLogger.log((String)("certificationLicenseInvaild localDateTime\uff1a" + time), (Object[])new Object[0]);
        CertificationLicenseQuery query = new CertificationLicenseQuery();
        query.setValidDateEnd(LocalDate.now().plusMonths(1L));
        List<CertificationLicenseVO> certificationLicenseVOS = this.queryListDynamic(query);
        if (!CollectionUtils.isEmpty(certificationLicenseVOS)) {
            certificationLicenseVOS.forEach(p -> {
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setContentBigType("businessMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("\u5b9a\u65f6\u4efb\u52a1");
                String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
                ado.setMessageCode(code);
                ado.setIsEnable(0);
                ado.setObjectId(p.getId());
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_people");
                ado.setNoticeWay("instation");
                ado.setTriggerWay("timing");
                ado.setTenantId(p.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                String content = "";
                ado.setMessageTitle("\u8d44\u8d28\u8bc1\u4e66\u8fc7\u671f\u63d0\u9192");
                ado.setMessageContent(content);
                ado.setTriggerTime(LocalDateTime.now());
                ado.setNoticeSource(p.getCreateUserId().toString());
                PrdMessageConfigDO save1 = (PrdMessageConfigDO)this.repoMessage.save(ado);
                this.messageConfigService.releaseMessage(Arrays.asList(PrdMessageConfigConvert.INSTANCE.toVo(save1)));
            });
        }
        XxlJobLogger.log((String)"\u8d44\u8d28\u8bc1\u7167\u8fc7\u671f\u63d0\u9192\u7ed3\u675f...", (Object[])new Object[0]);
    }

    public CertificationLicenseServiceImpl(CertificationLicenseRepo certificationLicenseRepo, CertificationLicenseDAO certificationLicenseDAO, PrdMessageConfigService messageConfigService, PrdMessageConfigRepo repoMessage, FileUtil fileUtil) {
        this.certificationLicenseRepo = certificationLicenseRepo;
        this.certificationLicenseDAO = certificationLicenseDAO;
        this.messageConfigService = messageConfigService;
        this.repoMessage = repoMessage;
        this.fileUtil = fileUtil;
    }
}

