/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.visit.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmCustomerOperationQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOperationPlanDetailQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmCustomerOperationService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOperationPlanDetailService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgDataRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookAddressService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookContactsService;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookContactsVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.partner.identity.vo.BusinessCustomerInfoVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoListPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanAutoPayload;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitPlanService;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitTaskService;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.crontask.XxlJobInfo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanPersonTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.convert.VisitPlanConvert;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.dao.VisitPlanDetailDAO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerTypeEnum;
import com.elitesland.tw.tw5.server.prd.system.convert.PrdMessageConfigConvert;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdMessageConfigDAO;
import com.elitesland.tw.tw5.server.prd.system.entity.PrdMessageConfigDO;
import com.elitesland.tw.tw5.server.prd.system.repo.PrdMessageConfigRepo;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class VisitPlanServiceImpl
extends BaseServiceImpl
implements VisitPlanService {
    private static final Logger log = LoggerFactory.getLogger(VisitPlanServiceImpl.class);
    private final VisitPlanDAO visitPlanDAO;
    private final VisitPlanDetailDAO visitPlanDetailDAO;
    private final VisitTaskService visitTaskService;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final BusinessPartnerService businessPartnerService;
    private final BookAddressService bookAddressService;
    private final BookContactsService bookContactsService;
    private final CrmLeadsService leadsService;
    private final CrmOpportunityService opportunityService;
    private final PrdMessageConfigService messageConfigService;
    private final PrdMessageConfigRepo repoMessage;
    private final PrdMessageConfigRepo prdMessageConfigRepo;
    private final PrdMessageConfigDAO prdMessageConfigDAO;
    private final CrmOperationPlanDetailService crmOperationPlanDetailService;
    private final CrmCustomerOperationService crmCustomerOperationService;
    private final BusinessCustomerInfoService businessCustomerInfoService;

    public PagingVO<VisitPlanVO> queryPaging(VisitPlanQuery query) {
        this.dataPermissionFlag(query);
        if (query.getVisitPerson() != null) {
            query.setVisitPersonNameStr(query.getVisitPerson() + ",");
        }
        if (query.getAccompanyPerson() != null) {
            query.setAccompanyPersonNameStr(query.getAccompanyPerson() + ",");
        }
        PagingVO<VisitPlanVO> visitPlanVOPagingVO = this.visitPlanDAO.queryPaging(query);
        List records = visitPlanVOPagingVO.getRecords();
        records.forEach(this::tranVisitPlanVo);
        return visitPlanVOPagingVO;
    }

    public VisitPlanVO queryByKey(Long key) {
        VisitPlanVO vo = this.visitPlanDAO.findByKey(key);
        this.tranVisitPlanVo(vo);
        return vo;
    }

    private void tranVisitPlanVo(VisitPlanVO vo) {
        if (StringUtils.hasText((String)vo.getVisitPlanType())) {
            vo.setVisitPlanTypeDesc(this.cacheUtil.transferSystemSelection("crm:visit:task_plan:type", vo.getVisitPlanType()));
            if (VisitTaskPlanTypeEnum.general_plan.getCode().equals(vo.getVisitPlanType())) {
                vo.setVisitDate(vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString());
            } else {
                String dateFrom = vo.getVisitDateFrom() == null ? "" : vo.getVisitDateFrom().toString();
                String dateTo = vo.getVisitDateTo() == null ? "" : vo.getVisitDateTo().toString();
                vo.setVisitDate(dateFrom + "~" + dateTo);
            }
        }
        if (StringUtils.hasText((String)vo.getVisitPlanStatus())) {
            vo.setVisitPlanStatus(this.cacheUtil.transferSystemSelection("crm:visit:task_plan:status", vo.getVisitPlanStatus()));
        }
        if (StringUtils.hasText((String)vo.getExtString1())) {
            String visitPersonStr = vo.getExtString1().substring(0, vo.getExtString1().length() - 1);
            String visitPersonNameStr = this.getPersonNameStr(visitPersonStr);
            List<Long> visitPersonList = Stream.of(visitPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setVisitPersonNameStr(visitPersonNameStr);
            vo.setVisitPersonList(visitPersonList);
        }
        if (StringUtils.hasText((String)vo.getExtString2())) {
            String accompanyPersonStr = vo.getExtString2().substring(0, vo.getExtString2().length() - 1);
            String accompanyPersonNameStr = this.getPersonNameStr(accompanyPersonStr);
            List<Long> accompanyPersonList = Stream.of(accompanyPersonStr.split(",")).map(Long::valueOf).toList();
            vo.setAccompanyPersonNameStr(accompanyPersonNameStr);
            vo.setAccompanyPersonList(accompanyPersonList);
        }
        if (StringUtils.hasText((String)vo.getObjType())) {
            vo.setObjTypeDesc(this.cacheUtil.transferSystemSelection("crm:visit:obj_type", vo.getObjType()));
        }
        if (vo.getCreateUserId() != null) {
            vo.setCreateUserName(this.cacheUtil.getUserName(vo.getCreateUserId()));
        }
        if (null == vo.getPartnerId()) {
            log.warn("\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\u672a\u5173\u8054\u5ba2\u6237\uff1b\u9500\u552e\u62dc\u8bbf\u8ba1\u5212\uff1a{}", (Object)vo);
            return;
        }
        BusinessPartnerVO simpleVO = this.businessPartnerService.queryByKeySimple(vo.getPartnerId());
        if (null != simpleVO) {
            BusinessCustomerInfoVO businessCustomerInfoVO;
            BookContactsVO bookContactsVO;
            Long bookId = simpleVO.getBookId();
            if (null == bookId) {
                log.warn("\u5ba2\u6237\u6570\u636e\u5f02\u5e38\uff1b\u627e\u4e0d\u5230bookId;  partnerId:{}", (Object)vo.getPartnerId());
                return;
            }
            BookAddressVO bookAddressVO = this.bookAddressService.queryDefaultByBookId(bookId);
            if (bookAddressVO != null) {
                vo.setBookId(bookId);
                vo.setCompanyAddress(bookAddressVO.getDetailAddress());
                vo.setLongitudeLatitude(bookAddressVO.getLongitudeLatitude());
            }
            if (null != (bookContactsVO = this.bookContactsService.queryDefaultByBookId(bookId))) {
                vo.setContactsName(bookContactsVO.getContactsName());
                vo.setContactsPhone(bookContactsVO.getContactsPhone());
            }
            if (null != (businessCustomerInfoVO = this.businessCustomerInfoService.queryByPartnerId(vo.getPartnerId()))) {
                vo.setCustomerStage(businessCustomerInfoVO.getCustomerStage());
            }
        }
    }

    private String getPersonNameStr(String visitPersonStr) {
        return Stream.of(visitPersonStr.split(",")).map(e -> {
            Long visitPersonId = Long.valueOf(e);
            String userName = this.cacheUtil.getUserName(visitPersonId);
            return userName == null ? "" : userName;
        }).collect(Collectors.joining(","));
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public VisitPlanVO insert(VisitPlanPayload payload) {
        VisitPlanDO save = this.commonSaveVisitPlan(payload);
        return VisitPlanConvert.INSTANCE.toVo(save);
    }

    private VisitPlanDO commonSaveVisitPlan(VisitPlanPayload payload) {
        this.saveVisitPersonStr(payload);
        VisitPlanDO entityDo = VisitPlanConvert.INSTANCE.toDo(payload);
        entityDo.setVisitPlanStatus(VisitTaskPlanStatusEnum.incomplete.getCode());
        VisitPlanDO save = this.visitPlanDAO.save(entityDo);
        this.saveVisitPlanDetail(payload.getVisitPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        this.saveVisitPlanDetail(payload.getAccompanyPersonList(), save.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());
        this.visitTaskService.generateTaskByPlanId(save.getId());
        this.createNotice(payload, save);
        this.accompanyNotice(payload, save);
        this.visitNotice(payload, save);
        return save;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public VisitPlanVO insertAuto(VisitPlanAutoPayload visitPlanAutoPayload) {
        Object partnerName = visitPlanAutoPayload.getPartnerName();
        LocalDateTime now = LocalDateTime.now();
        VisitPlanPayload payload = new VisitPlanPayload();
        if (StringUtils.hasText((String)partnerName)) {
            BusinessPartnerSimpleVO vo = this.businessPartnerService.queryByPartnerName((String)partnerName);
            if (null != vo) {
                Long partnerId = vo.getId();
                payload.setPartnerId(partnerId);
            } else {
                BusinessPartnerPayload businessPartnerPayload = new BusinessPartnerPayload();
                businessPartnerPayload.setPartnerName((String)partnerName);
                businessPartnerPayload.setDetailAddress(visitPlanAutoPayload.getCustomAdress());
                businessPartnerPayload.setPartnerIdentity(BusinessPartnerIdentityEnum.CUSTOMER.getCode());
                businessPartnerPayload.setContactsPhone(visitPlanAutoPayload.getContactsPhone());
                businessPartnerPayload.setContactsName(visitPlanAutoPayload.getContactsName());
                businessPartnerPayload.setCountry(visitPlanAutoPayload.getCountry());
                businessPartnerPayload.setProvince(visitPlanAutoPayload.getProvince());
                businessPartnerPayload.setCity(visitPlanAutoPayload.getCity());
                businessPartnerPayload.setDistrict(visitPlanAutoPayload.getDistrict());
                businessPartnerPayload.setProvinceName(visitPlanAutoPayload.getProvinceName());
                businessPartnerPayload.setCityName(visitPlanAutoPayload.getCityName());
                businessPartnerPayload.setDistrictName(visitPlanAutoPayload.getDistrictName());
                businessPartnerPayload.setLongitudeLatitude(visitPlanAutoPayload.getLongitudeLatitude());
                businessPartnerPayload.setCustomerFlag(Boolean.valueOf(true));
                businessPartnerPayload.setPartnerType(BusinessPartnerTypeEnum.ORGANIZATION.getCode());
                businessPartnerPayload.setInsideOrOutSide(BusinessInsideOrOutSideEnum.OUTSIDE.getCode());
                BusinessPartnerVO businessPartnerSave = this.businessPartnerService.insert(businessPartnerPayload);
                payload.setPartnerId(businessPartnerSave.getId());
            }
        } else {
            throw TwException.error("", "partnerName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Date date = new Date();
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
        String nowStr = format.format(date);
        partnerName = nowStr + "-" + (String)partnerName + "-" + GlobalUtil.getLoginUserName();
        payload.setVisitPlanName((String)partnerName);
        payload.setCustomAdress(visitPlanAutoPayload.getCustomAdress());
        LocalDate visitDate = now.plusDays(7L).toLocalDate();
        payload.setVisitDateFrom(visitDate);
        payload.setVisitDateTo(visitDate);
        payload.setRemindTime(now.plusDays(6L));
        payload.setVisitTimes("1");
        ArrayList<Long> visitPersonList = new ArrayList<Long>();
        visitPersonList.add(GlobalUtil.getLoginUserId());
        payload.setVisitPersonList(visitPersonList);
        payload.setVisitPlanType(VisitTaskPlanTypeEnum.general_plan.getCode());
        VisitPlanDO save = this.commonSaveVisitPlan(payload);
        return VisitPlanConvert.INSTANCE.toVo(save);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public List<VisitPlanVO> insertListAuto(VisitPlanAutoListPayload payload) {
        ArrayList<VisitPlanVO> result = new ArrayList<VisitPlanVO>();
        List visitPlanAutoPayloadList = payload.getVisitPlanAutoPayloadList();
        visitPlanAutoPayloadList.forEach(plan -> result.add(this.insertAuto((VisitPlanAutoPayload)plan)));
        return result;
    }

    private void notice(VisitPlanPayload payload, VisitPlanDO save) {
        String loginUserName = GlobalUtil.getLoginUserName();
        Long loginUserId = GlobalUtil.getLoginUserId();
        ArrayList<Long> noticePersonList = new ArrayList<Long>();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.prdOrgEmployeeService.queryEmployeeRef(loginUserId);
        if (prdOrgEmployeeRefVO != null && prdOrgEmployeeRefVO.getParentId() != null) {
            noticePersonList.add(prdOrgEmployeeRefVO.getParentId());
        }
        if (payload.getAccompanyPersonList() != null) {
            noticePersonList.addAll(payload.getAccompanyPersonList());
        }
        if (noticePersonList.size() > 0) {
            ArrayList messageConfigDOS = new ArrayList();
            noticePersonList.forEach(userId -> {
                String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
                Long visitPlanId = save.getId();
                String content = loginUserName + " \u65b0\u589e\u4e86\u4e00\u6761\u62dc\u8bbf\u8ba1\u5212 <a href=\"/customerVisit/visitPlanDetail?id=" + visitPlanId + "\">" + save.getVisitPlanName() + "</a> \u3002";
                PrdMessageConfigDO ado = new PrdMessageConfigDO();
                ado.setMessageCode(code);
                ado.setMessageTitle("\u65b0\u589e\u62dc\u8bbf\u8ba1\u5212");
                ado.setMessageContent(content);
                ado.setCreateUserId(loginUserId);
                ado.setContentBigType("businessMessage");
                ado.setContentType("systemMessage");
                ado.setCreateSource("\u65b0\u589e\u62dc\u8bbf\u8ba1\u5212");
                ado.setIsEnable(0);
                ado.setMessageType(2);
                ado.setNoticeScope("appoint_people");
                ado.setNoticeSource("" + userId);
                ado.setNoticeWay("instation");
                ado.setTenantId(save.getTenantId());
                ado.setReleaseSource("profileMessage");
                ado.setReleaseStatus(3);
                ado.setTriggerTime(LocalDateTime.now());
                messageConfigDOS.add(ado);
            });
            List messageConfigDOS1 = this.repoMessage.saveAll(messageConfigDOS);
            List messageConfigVOS = messageConfigDOS1.stream().map(PrdMessageConfigConvert.INSTANCE::toVo).collect(Collectors.toList());
            this.messageConfigService.releaseMessage(messageConfigVOS);
        }
    }

    private void createNotice(VisitPlanPayload payload, VisitPlanDO save) {
        String loginUserName = GlobalUtil.getLoginUserName();
        Long loginUserId = GlobalUtil.getLoginUserId();
        List accompanyPersonList = payload.getAccompanyPersonList();
        List visitPersonList = payload.getVisitPersonList();
        Set visitPersonParentList = this.prdOrgEmployeeService.queryParentIdByIds(visitPersonList);
        HashSet noticePersonList = new HashSet();
        if (!CollectionUtils.isEmpty((Collection)accompanyPersonList)) {
            noticePersonList.addAll(accompanyPersonList);
        }
        if (!CollectionUtils.isEmpty((Collection)visitPersonParentList)) {
            noticePersonList.addAll(visitPersonParentList);
        }
        if (!CollectionUtils.isEmpty((Collection)visitPersonList)) {
            noticePersonList.addAll(visitPersonList);
        }
        if (noticePersonList.size() > 0) {
            PrdMessageConfigDO ado = new PrdMessageConfigDO();
            ado.setCreateUserId(loginUserId);
            ado.setContentBigType("businessMessage");
            ado.setContentType("visit");
            ado.setCreateSource("\u4e2a\u4eba");
            ado.setIsEnable(0);
            ado.setMessageType(2);
            ado.setObjectId(save.getId());
            ado.setAction("visitPlan");
            ado.setNoticeScope("appoint_people");
            ado.setNoticeWay("instation");
            ado.setTenantId(save.getTenantId());
            ado.setReleaseSource("profileMessage");
            ado.setReleaseStatus(3);
            String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
            Long visitPlanId = save.getId();
            String content = loginUserName + " \u65b0\u5efa\u4e86\u4e00\u6761\u62dc\u8bbf\u8ba1\u5212 <a href=\"/customerVisit/visitPlanDetail?id=" + visitPlanId + "\">" + save.getVisitPlanName() + "</a> \u3002";
            ado.setMessageCode(code);
            ado.setMessageTitle("\u65b0\u5efa\u62dc\u8bbf\u8ba1\u5212");
            ado.setMessageContent(content);
            ado.setTriggerTime(LocalDateTime.now());
            StringJoiner noticeSource = new StringJoiner(",");
            noticePersonList.forEach(userId -> noticeSource.add("" + userId));
            ado.setNoticeSource("" + noticeSource);
            PrdMessageConfigDO save1 = (PrdMessageConfigDO)this.repoMessage.save(ado);
            this.messageConfigService.releaseMessage(Arrays.asList(PrdMessageConfigConvert.INSTANCE.toVo(save1)));
        }
    }

    public void accompanyNotice(VisitPlanPayload payload, VisitPlanDO save) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (payload.getRemindTime() == null) {
            return;
        }
        List accompanyPersonList = payload.getAccompanyPersonList();
        PrdMessageConfigDO ado = new PrdMessageConfigDO();
        ado.setCreateUserId(loginUserId);
        ado.setContentBigType("businessMessage");
        ado.setContentType("visit");
        ado.setCreateSource("\u4e2a\u4eba");
        ado.setIsEnable(0);
        ado.setObjectId(save.getId());
        ado.setAction("visitPlan");
        ado.setMessageType(2);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setTriggerWay("timing");
        ado.setTenantId(save.getTenantId());
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(0);
        String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
        String content = "\u60a8\u6709\u4e00\u6761\u62dc\u8bbf\u8ba1\u5212\u5f85\u534f\u8bbf\uff0c\u8bf7\u6ce8\u610f\u65f6\u95f4";
        ado.setMessageCode(code);
        ado.setMessageTitle("\u534f\u8bbf\u63d0\u9192");
        ado.setMessageContent(content);
        ado.setTriggerTime(payload.getRemindTime());
        if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
            StringJoiner noticeSource = new StringJoiner(",");
            accompanyPersonList.forEach(userId -> noticeSource.add("" + userId));
            ado.setNoticeSource(String.valueOf(noticeSource));
            this.messageConfigService.insert(PrdMessageConfigConvert.INSTANCE.toPayload(ado));
        }
    }

    public void visitNotice(VisitPlanPayload payload, VisitPlanDO save) {
        if (payload.getRemindTime() == null) {
            return;
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        List visitPersonList = payload.getVisitPersonList();
        PrdMessageConfigDO ado = new PrdMessageConfigDO();
        ado.setCreateUserId(loginUserId);
        ado.setContentBigType("businessMessage");
        ado.setContentType("visit");
        ado.setCreateSource("\u4e2a\u4eba");
        ado.setIsEnable(0);
        ado.setObjectId(save.getId());
        ado.setAction("visitPlan");
        ado.setMessageType(2);
        ado.setNoticeScope("appoint_people");
        ado.setNoticeWay("instation");
        ado.setTriggerWay("timing");
        ado.setTenantId(save.getTenantId());
        ado.setReleaseSource("profileMessage");
        ado.setReleaseStatus(0);
        String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
        String content = "\u60a8\u6709\u4e00\u6761\u62dc\u8bbf\u4efb\u52a1\u5f85\u6267\u884c\uff0c\u8bf7\u6ce8\u610f\u65f6\u95f4";
        ado.setMessageCode(code);
        ado.setMessageTitle("\u62dc\u8bbf\u4efb\u52a1\u63d0\u9192");
        ado.setMessageContent(content);
        ado.setTriggerTime(payload.getRemindTime());
        if (visitPersonList != null && visitPersonList.size() > 0) {
            StringJoiner noticeSource = new StringJoiner(",");
            visitPersonList.forEach(userId -> noticeSource.add("" + userId));
            ado.setNoticeSource(String.valueOf(noticeSource));
            this.messageConfigService.insert(PrdMessageConfigConvert.INSTANCE.toPayload(ado));
        }
    }

    private void saveVisitPersonStr(VisitPlanPayload payload) {
        List visitPersonList = payload.getVisitPersonList();
        if (visitPersonList == null || visitPersonList.size() < 1) {
            throw new RuntimeException("\u65b0\u5efa\u8ba1\u5212 \u62dc\u8bbf\u6210\u5458\u5fc5\u586b");
        }
        String visitPersonStr = visitPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
        payload.setExtString1(visitPersonStr);
        List accompanyPersonList = payload.getAccompanyPersonList();
        if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
            String accompanyPersonStr = accompanyPersonList.stream().sorted().map(Object::toString).collect(Collectors.joining(",", "", ","));
            payload.setExtString2(accompanyPersonStr);
        }
        String visitPersonParentStr = visitPersonList.stream().map(visitPersonId -> {
            PrdOrgDataRefVO defaultOrgInfoByUserId = this.cacheUtil.getDefaultOrgInfoByUserId((Long)visitPersonId);
            if (defaultOrgInfoByUserId == null) {
                return -1L;
            }
            return defaultOrgInfoByUserId.getParentId() == null ? -1L : defaultOrgInfoByUserId.getParentId();
        }).map(Object::toString).distinct().collect(Collectors.joining(",", "", ","));
        payload.setExtString3(visitPersonParentStr);
    }

    private void saveVisitPlanDetail(List<Long> visitPersonList, Long visitPlanId, String visitTaskPlanPersonType) {
        if (visitPersonList != null && visitPersonList.size() > 0) {
            for (Long visitPersonId : visitPersonList) {
                VisitPlanDetailDO ado = new VisitPlanDetailDO();
                ado.setVisitPlanId(visitPlanId);
                ado.setVisitPersonId(visitPersonId);
                ado.setVisitPersonType(visitTaskPlanPersonType);
                this.visitPlanDetailDAO.save(ado);
            }
        }
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public long update(VisitPlanPayload payload) {
        VisitPlanVO vo;
        Long userId;
        if (payload.getId() == null || payload.getId() < 0L) {
            throw TwException.error("1", "\u62dc\u8bbf\u8ba1\u5212id\u6709\u8bef");
        }
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode()));
        if (!rolePermission.booleanValue() && !(userId = GlobalUtil.getLoginUserId()).equals((vo = this.visitPlanDAO.findByKey(payload.getId())).getCreateUserId())) {
            throw TwException.error("1", "\u53ea\u6709\u521b\u5efa\u4eba\u53ef\u4ee5\u4fee\u6539\u8ba1\u5212\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u662f\u521b\u5efa\u4eba");
        }
        long count = this.visitTaskService.countByPlanId(payload.getId());
        if (count > 0L) {
            throw TwException.error("1", "\u8be5\u8ba1\u5212\u4e0b\u7684\u4efb\u52a1\u5df2\u7ecf\u5f00\u59cb\u6267\u884c\uff0c\u4e0d\u80fd\u4fee\u6539\u8ba1\u5212");
        }
        this.saveVisitPersonStr(payload);
        long l = this.visitPlanDAO.updateByKeyDynamic(payload);
        this.visitPlanDetailDAO.deleteByVisitPlanId(payload.getId());
        this.saveVisitPlanDetail(payload.getVisitPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.visit_person.getCode());
        this.saveVisitPlanDetail(payload.getAccompanyPersonList(), payload.getId(), VisitTaskPlanPersonTypeEnum.accompany_person.getCode());
        this.visitTaskService.generateTaskByPlanId(payload.getId());
        List<PrdMessageConfigDO> prdMessageConfigDOS = this.repoMessage.findByObjectIdAndAction(payload.getId(), "visitPlan");
        prdMessageConfigDOS.stream().filter(prdMessageConfigDO -> !"\u65b0\u5efa\u62dc\u8bbf\u8ba1\u5212".equals(prdMessageConfigDO.getMessageTitle())).forEach(prdMessageConfigDO -> {
            if ("\u62dc\u8bbf\u4efb\u52a1\u63d0\u9192".equals(prdMessageConfigDO.getMessageTitle())) {
                List visitPersonList = payload.getVisitPersonList();
                noticeSource = new StringJoiner(",");
                if (visitPersonList != null && visitPersonList.size() > 0) {
                    visitPersonList.forEach(userId -> noticeSource.add("" + userId));
                } else {
                    noticeSource.setEmptyValue("");
                }
                prdMessageConfigDO.setNoticeSource(String.valueOf(noticeSource));
            } else if ("\u534f\u8bbf\u63d0\u9192".equals(prdMessageConfigDO.getMessageTitle())) {
                List accompanyPersonList = payload.getAccompanyPersonList();
                noticeSource = new StringJoiner(",");
                if (accompanyPersonList != null && accompanyPersonList.size() > 0) {
                    accompanyPersonList.forEach(userId -> noticeSource.add("" + userId));
                } else {
                    noticeSource.setEmptyValue("");
                }
                prdMessageConfigDO.setNoticeSource(String.valueOf(noticeSource));
            }
            if (prdMessageConfigDO.getReleaseStatus() == 3) {
                if (!"".equals(prdMessageConfigDO.getNoticeSource()) && !payload.getRemindTime().truncatedTo(ChronoUnit.HOURS).isEqual(prdMessageConfigDO.getTriggerTime().truncatedTo(ChronoUnit.HOURS))) {
                    PrdMessageConfigDO ado = new PrdMessageConfigDO();
                    BeanUtils.copyProperties((Object)prdMessageConfigDO, (Object)ado);
                    ado.setTriggerTime(payload.getRemindTime());
                    ado.setId(null);
                    ado.setReleaseStatus(0);
                    String code = this.generateSeqNum("MESSAGE_CONFIG_NO", new String[0]);
                    ado.setMessageCode(code);
                    ado.setCreateTime(null);
                    PrdMessageConfigDO save = (PrdMessageConfigDO)this.prdMessageConfigRepo.save(ado);
                    XxlJobInfo xxlJobInfo = new XxlJobInfo();
                    xxlJobInfo.setAuthor(save.getCreator());
                    xxlJobInfo.setJobGroup(3);
                    xxlJobInfo.setJobCron(save.getTriggerTimeExpression());
                    xxlJobInfo.setJobDesc(save.getMessageTitle());
                    xxlJobInfo.setExecutorHandler("xxl-job-executor-message");
                    xxlJobInfo.setExecutorParam("" + save.getId());
                    xxlJobInfo.setTriggerStatus(save.getIsEnable() == 0 ? 1 : 0);
                    this.prdMessageConfigDAO.saveXxlJob(xxlJobInfo);
                }
            } else {
                prdMessageConfigDO.setTriggerTime(payload.getRemindTime());
                this.messageConfigService.update(PrdMessageConfigConvert.INSTANCE.toPayload((PrdMessageConfigDO)prdMessageConfigDO));
            }
        });
        return l;
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public long completeVisitPlan(Long visitPlanId) {
        if (visitPlanId == null) {
            throw TwException.error("1", "\u62dc\u8bbf\u8ba1\u5212id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return this.visitPlanDAO.completeVisitPlan(visitPlanId);
    }

    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            keys.stream().forEach(id -> {
                VisitPlanVO visitPlanVO = this.visitPlanDAO.queryByKey((Long)id);
                if (!visitPlanVO.getCreateUserId().equals(GlobalUtil.getLoginUserId())) {
                    throw TwException.error("1", "\u53ea\u6709\u521b\u5efa\u4eba\u53ef\u4ee5\u5220\u9664\u8ba1\u5212\uff0c\u5f53\u524d\u767b\u9646\u7528\u6237\u4e0d\u662f\u521b\u5efa\u4eba");
                }
                long count = this.visitTaskService.countByPlanId(id);
                if (count > 0L) {
                    throw TwException.error("1", "\u62dc\u8bbf\u4efb\u52a1\u5df2\u5f00\u59cb/\u5df2\u5b8c\u6210\uff0c\u4e0d\u80fd\u5220\u9664\u62dc\u8bbf\u8ba1\u5212");
                }
            });
        }
        if (!keys.isEmpty()) {
            this.visitPlanDAO.deleteSoft(keys);
            keys.stream().forEach(id -> this.visitTaskService.deleteSoftByPlanId(id));
        }
    }

    public Map<String, Integer> visitPlanCount() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        VisitPlanQuery query = new VisitPlanQuery();
        this.dataPermissionFlag(query);
        if (query.getVisitPerson() != null) {
            query.setVisitPersonNameStr(query.getVisitPerson() + ",");
        }
        if (query.getAccompanyPerson() != null) {
            query.setAccompanyPersonNameStr(query.getAccompanyPerson() + ",");
        }
        List<VisitPlanVO> visitPlans = this.visitPlanDAO.queryListDynamic(query);
        result.put("visitPlan_count", visitPlans.size());
        long count = visitPlans.stream().filter(e -> e.getVisitPlanStatus().equals(VisitTaskPlanStatusEnum.incomplete.getCode())).count();
        result.put("incomplete_VisitPlan_count", (int)count);
        Map<String, Long> collect = visitPlans.stream().collect(Collectors.groupingBy(VisitPlanVO::getVisitPlanType, Collectors.counting()));
        Arrays.stream(VisitTaskPlanTypeEnum.values()).forEach(key -> {
            if (collect.containsKey(key.getCode())) {
                result.put(key.getCode() + "_count", ((Long)collect.get(key.getCode())).intValue());
            } else {
                result.put(key.getCode() + "_count", 0);
            }
        });
        return result;
    }

    public String getVisitCustomAddress(Long bookId) {
        BookAddressVO bookAddressVO = this.bookAddressService.queryDefaultByBookId(bookId);
        if (bookAddressVO == null) {
            return null;
        }
        return bookAddressVO.getDetailAddress();
    }

    public List<BookAddressVO> getVisitCustomAddressList(Long bookId) {
        List bookAddressVOS = this.bookAddressService.queryByBookId(bookId);
        if (bookAddressVOS == null) {
            return null;
        }
        return bookAddressVOS;
    }

    public List<Map<String, Object>> visitCustomRelationInfo(Long partnerId, String objType) {
        if (VisitTaskPlanObjTypeEnum.LEAD.getCode().equals(objType)) {
            BusinessPartnerVO businessPartnerVO = this.businessPartnerService.queryByKey(partnerId);
            String customerName = businessPartnerVO.getPartnerName();
            List crmLeadsListVOS = this.leadsService.queryListByCustomName(customerName);
            List<Map<String, Object>> list = crmLeadsListVOS.stream().map(e -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", e.getId());
                result.put("name", e.getLeadsName());
                return result;
            }).toList();
            return list;
        }
        if (VisitTaskPlanObjTypeEnum.OPPO.getCode().equals(objType)) {
            List crmActProjectVOS = this.opportunityService.queryListByCustomId(partnerId);
            List<Map<String, Object>> list = crmActProjectVOS.stream().map(e -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", e.getId());
                result.put("name", e.getProjectName());
                return result;
            }).toList();
            return list;
        }
        CrmCustomerOperationQuery crmCustomerOperationQuery = new CrmCustomerOperationQuery();
        crmCustomerOperationQuery.setCustomerId(partnerId);
        List crmCustomerOperationVOS = this.crmCustomerOperationService.queryList(crmCustomerOperationQuery);
        if (!CollectionUtils.isEmpty((Collection)crmCustomerOperationVOS)) {
            CrmOperationPlanDetailQuery crmOperationPlanDetailQuery = new CrmOperationPlanDetailQuery();
            List collect = crmCustomerOperationVOS.stream().map(p -> p.getId()).collect(Collectors.toList());
            crmOperationPlanDetailQuery.setOperIdList(collect);
            List operationPlanByCustomId = this.crmOperationPlanDetailService.queryList(crmOperationPlanDetailQuery);
            List<Map<String, Object>> list = operationPlanByCustomId.stream().map(e -> {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("id", e.getId());
                result.put("name", e.getPlanName());
                return result;
            }).toList();
            return list;
        }
        return null;
    }

    private void dataPermissionFlag(VisitPlanQuery query) {
        Long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALE_VISIT_PIC.getCode(), RoleEnum.SALE_ADMIN.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
        if (!rolePermission.booleanValue()) {
            query.setLoginUserId(userId);
        }
    }

    public VisitPlanServiceImpl(VisitPlanDAO visitPlanDAO, VisitPlanDetailDAO visitPlanDetailDAO, VisitTaskService visitTaskService, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService, BusinessPartnerService businessPartnerService, BookAddressService bookAddressService, BookContactsService bookContactsService, CrmLeadsService leadsService, CrmOpportunityService opportunityService, PrdMessageConfigService messageConfigService, PrdMessageConfigRepo repoMessage, PrdMessageConfigRepo prdMessageConfigRepo, PrdMessageConfigDAO prdMessageConfigDAO, CrmOperationPlanDetailService crmOperationPlanDetailService, CrmCustomerOperationService crmCustomerOperationService, BusinessCustomerInfoService businessCustomerInfoService) {
        this.visitPlanDAO = visitPlanDAO;
        this.visitPlanDetailDAO = visitPlanDetailDAO;
        this.visitTaskService = visitTaskService;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
        this.businessPartnerService = businessPartnerService;
        this.bookAddressService = bookAddressService;
        this.bookContactsService = bookContactsService;
        this.leadsService = leadsService;
        this.opportunityService = opportunityService;
        this.messageConfigService = messageConfigService;
        this.repoMessage = repoMessage;
        this.prdMessageConfigRepo = prdMessageConfigRepo;
        this.prdMessageConfigDAO = prdMessageConfigDAO;
        this.crmOperationPlanDetailService = crmOperationPlanDetailService;
        this.crmCustomerOperationService = crmCustomerOperationService;
        this.businessCustomerInfoService = businessCustomerInfoService;
    }
}

