/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.basebu.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdBaseBuChangePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdBaseBuChangeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdBaseBuChangeVO;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeEqvaRatioPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeePayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgEmployeeRefPayload;
import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgRolePayload;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/BASE_BU_CHANGE/callBack"})
@Transactional
public class PrdBaseBuChangeCallback
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PrdBaseBuChangeCallback.class);
    public final PrdBaseBuChangeService prdBaseBuChangeService;
    private final PrdOrgEmployeeDAO prdOrgEmployeeDAO;
    private final PrdOrgOrganizationDAO prdOrgOrganizationDAO;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            throw new BusinessException("\u83b7\u53d6\u7684businessKey\u4e3a\u7a7a");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        Long id = Long.valueOf(businessKey);
        PrdBaseBuChangeVO prdBaseBuChangeVO = this.prdBaseBuChangeService.get(id);
        PrdBaseBuChangePayload prdBaseBuChangePayload = new PrdBaseBuChangePayload();
        prdBaseBuChangePayload.setId(id);
        if (prdBaseBuChangeVO != null) {
            Boolean isUp = false;
            PrdOrgEmployeePayload prdOrgEmployeePayload = new PrdOrgEmployeePayload();
            prdOrgEmployeePayload.setResourceStatus("3");
            prdOrgEmployeePayload.setUserId(prdBaseBuChangeVO.getUserId());
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                }
                case INVALID: {
                    prdBaseBuChangePayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case REJECTED: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    String[] roleIds;
                    isUp = true;
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdBaseBuChangePayload.setApprovedTime(LocalDateTime.now());
                    if (null == prdBaseBuChangeVO.getNewJoinDate()) {
                        prdBaseBuChangeVO.setNewJoinDate(LocalDate.now());
                    }
                    if (!prdBaseBuChangeVO.getNewJoinDate().isEqual(LocalDate.now()) && !prdBaseBuChangeVO.getNewJoinDate().isBefore(LocalDate.now())) break;
                    prdOrgEmployeePayload.setSalaryMethod(prdBaseBuChangeVO.getSalaryType());
                    prdOrgEmployeePayload.setSalaryPeriod(prdBaseBuChangeVO.getSalaryCycle());
                    prdOrgEmployeePayload.setCooperationMode(prdBaseBuChangeVO.getCooperateType());
                    BigDecimal eqvaRatio = BigDecimal.ONE;
                    prdOrgEmployeePayload.setEqvaRatio(eqvaRatio);
                    prdOrgEmployeePayload.setExtString1(prdBaseBuChangeVO.getJobGrade());
                    this.prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
                    PrdOrgEmployeeEqvaRatioPayload employeeEqvaRatioDO = new PrdOrgEmployeeEqvaRatioPayload();
                    employeeEqvaRatioDO.setUserId(prdBaseBuChangeVO.getUserId());
                    employeeEqvaRatioDO.setEqvaRatio(eqvaRatio);
                    employeeEqvaRatioDO.setStartDate(LocalDate.now());
                    employeeEqvaRatioDO.setEndDate(null);
                    this.prdOrgEmployeeEqvaRatioService.upsertEqvaRatio(employeeEqvaRatioDO);
                    PrdOrgEmployeeRefPayload prdOrgEmployeeRefPayload = new PrdOrgEmployeeRefPayload();
                    prdOrgEmployeeRefPayload.setOrgId(prdBaseBuChangeVO.getOldBuId());
                    prdOrgEmployeeRefPayload.setNewOrgId(prdBaseBuChangeVO.getNewBuId());
                    prdOrgEmployeeRefPayload.setUserId(prdBaseBuChangeVO.getUserId());
                    prdOrgEmployeeRefPayload.setParentId(prdBaseBuChangeVO.getNewPUserId());
                    prdOrgEmployeeRefPayload.setIsDefault(Integer.valueOf(0));
                    prdOrgEmployeeRefPayload.setJoinDate(prdBaseBuChangeVO.getNewJoinDate());
                    this.prdOrgEmployeeDAO.updateEmployeeRefByUserId(prdOrgEmployeeRefPayload);
                    if (!StringUtils.isNotBlank((CharSequence)prdBaseBuChangeVO.getNewRoleId())) break;
                    for (String str : roleIds = prdBaseBuChangeVO.getNewRoleId().split(",")) {
                        PrdOrgRoleDO prdOrgRoleDO = this.prdOrgOrganizationDAO.queryRoleByKey(Long.valueOf(str));
                        if (null == prdOrgRoleDO) {
                            throw new BusinessException("\u672a\u627e\u5230\u8be5\u89d2\u8272" + str);
                        }
                        Object roleEmployees = prdOrgRoleDO.getRoleEmployees();
                        if (StringUtils.isNotBlank((CharSequence)roleEmployees)) {
                            roleEmployees = (String)roleEmployees + ",";
                        }
                        roleEmployees = (String)roleEmployees + prdBaseBuChangeVO.getUserId();
                        PrdOrgRolePayload prdOrgRolePayload = new PrdOrgRolePayload();
                        prdOrgRolePayload.setId(Long.valueOf(str));
                        prdOrgRolePayload.setRoleEmployees((String)roleEmployees);
                        long l = this.prdOrgOrganizationDAO.updateRole(prdOrgRolePayload);
                    }
                    break;
                }
                case APPROVING: {
                    prdBaseBuChangePayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    prdOrgEmployeePayload.setResourceStatus("5");
                }
            }
            Long l = this.prdBaseBuChangeService.updateByCondition(prdBaseBuChangePayload);
            if (!isUp.booleanValue()) {
                this.prdOrgEmployeeDAO.updateByUserId(prdOrgEmployeePayload);
            }
        }
        return WorkflowResult.success(null);
    }

    public PrdBaseBuChangeCallback(PrdBaseBuChangeService prdBaseBuChangeService, PrdOrgEmployeeDAO prdOrgEmployeeDAO, PrdOrgOrganizationDAO prdOrgOrganizationDAO, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService) {
        this.prdBaseBuChangeService = prdBaseBuChangeService;
        this.prdOrgEmployeeDAO = prdOrgEmployeeDAO;
        this.prdOrgOrganizationDAO = prdOrgOrganizationDAO;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
    }
}

