/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.org.dao;

import com.elitesland.tw.tw5.api.prd.org.payload.PrdOrgVersionPayload;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgVersionVO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgVersionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgDimensionDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgEmployeeRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgOrganizationRefDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgRoleDO;
import com.elitesland.tw.tw5.server.prd.org.entity.QPrdOrgVersionDO;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgDimensionRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgEmployeeRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRefRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgOrganizationRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgRoleRepo;
import com.elitesland.tw.tw5.server.prd.org.repo.PrdOrgVersionRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.List;
import org.springframework.stereotype.Repository;

@Repository
public class PrdOrgVersionDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PrdOrgVersionRepo repo;
    private final PrdOrgDimensionRepo repoDimension;
    private final PrdOrgOrganizationRepo repoOrganization;
    private final PrdOrgOrganizationRefRepo repoOrganizationRef;
    private final PrdOrgRoleRepo repoRole;
    private final PrdOrgEmployeeRefRepo repoEmployeeRef;
    private final QPrdOrgVersionDO qdo = QPrdOrgVersionDO.prdOrgVersionDO;
    private final QPrdOrgDimensionDO qdoDimension = QPrdOrgDimensionDO.prdOrgDimensionDO;
    private final QPrdOrgOrganizationRefDO qdoOrganizationRef = QPrdOrgOrganizationRefDO.prdOrgOrganizationRefDO;
    private final QPrdOrgOrganizationDO qdoOrganization = QPrdOrgOrganizationDO.prdOrgOrganizationDO;
    private final QPrdOrgRoleDO qdoRole = QPrdOrgRoleDO.prdOrgRoleDO;
    private final QPrdOrgEmployeeRefDO qdoEmployeeRef = QPrdOrgEmployeeRefDO.prdOrgEmployeeRefDO;

    public List<PrdOrgEmployeeRefDO> queryOrgEmployeesByOrgId(Long orgId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoEmployeeRef).from((EntityPath)this.qdoEmployeeRef);
        jpaQuery.where((Predicate)this.qdoEmployeeRef.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoEmployeeRef.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdOrgEmployeeRefDO> saveEmployeeRefs(List<PrdOrgEmployeeRefDO> ados) {
        return this.repoEmployeeRef.saveAll(ados);
    }

    public List<PrdOrgRoleDO> queryOrgRolesByOrgId(Long orgId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoRole).from((EntityPath)this.qdoRole);
        jpaQuery.where((Predicate)this.qdoRole.orgId.eq((Object)orgId));
        jpaQuery.where((Predicate)this.qdoRole.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<PrdOrgRoleDO> saveRoles(List<PrdOrgRoleDO> ados) {
        return this.repoRole.saveAll(ados);
    }

    public List<PrdOrgOrganizationRefDO> saveOrganizationRefs(List<PrdOrgOrganizationRefDO> ados) {
        return this.repoOrganizationRef.saveAll(ados);
    }

    public PrdOrgOrganizationDO saveOrganization(PrdOrgOrganizationDO ado) {
        return (PrdOrgOrganizationDO)this.repoOrganization.save(ado);
    }

    public PrdOrgOrganizationDO queryOrg(Long key) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoOrganization).from((EntityPath)this.qdoOrganization);
        jpaQuery.where((Predicate)this.qdoOrganization.id.eq((Object)key));
        jpaQuery.where((Predicate)this.qdoOrganization.deleteFlag.eq((Object)0));
        return (PrdOrgOrganizationDO)jpaQuery.fetchFirst();
    }

    public PrdOrgVersionDO queryVersionByCode(Long dimensionId, String code) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.versionNo.eq((Object)code));
        jpaQuery.where((Predicate)this.qdo.dimensionId.eq((Object)dimensionId));
        return (PrdOrgVersionDO)jpaQuery.fetchFirst();
    }

    public List<PrdOrgOrganizationRefDO> queryOrgListByDimensionId(Long dimensionId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoOrganizationRef).from((EntityPath)this.qdoOrganizationRef);
        jpaQuery.where((Predicate)this.qdoOrganizationRef.dimensionId.eq((Object)dimensionId));
        jpaQuery.where((Predicate)this.qdoOrganizationRef.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PrdOrgDimensionDO queryByDimensionId(Long dimensionId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdoDimension).from((EntityPath)this.qdoDimension);
        jpaQuery.where((Predicate)this.qdoDimension.id.eq((Object)dimensionId));
        jpaQuery.where((Predicate)this.qdoDimension.deleteFlag.eq((Object)0));
        return (PrdOrgDimensionDO)jpaQuery.fetchFirst();
    }

    public PrdOrgVersionDO save(PrdOrgVersionDO ado) {
        return (PrdOrgVersionDO)this.repo.save(ado);
    }

    public PrdOrgDimensionDO saveDimension(PrdOrgDimensionDO ado) {
        return (PrdOrgDimensionDO)this.repoDimension.save(ado);
    }

    public long updateByKeyDynamic(PrdOrgVersionPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getVersionNo() != null) {
            update.set((Path)this.qdo.versionNo, (Object)payload.getVersionNo());
        }
        if (payload.getChangeRecord() != null) {
            update.set((Path)this.qdo.changeRecord, (Object)payload.getChangeRecord());
        }
        if (payload.getRemark() != null) {
            update.set((Path)this.qdo.remark, (Object)payload.getRemark());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0 && nullFields.contains("remark")) {
            update.setNull((Path)this.qdo.remark);
        }
        return update.execute();
    }

    public List<PrdOrgVersionVO> queryListByDimensionId(Long dimensionId) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PrdOrgVersionVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.dimensionId, this.qdo.versionNo, this.qdo.changeRecord, this.qdo.createUserId, this.qdo.createTime})).from((EntityPath)this.qdo);
        jpaQuery.where((Predicate)this.qdo.dimensionId.eq((Object)dimensionId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public long deleteSoft(Long key) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.eq((Object)key)});
        return update.execute();
    }

    public PrdOrgVersionDAO(JPAQueryFactory jpaQueryFactory, PrdOrgVersionRepo repo, PrdOrgDimensionRepo repoDimension, PrdOrgOrganizationRepo repoOrganization, PrdOrgOrganizationRefRepo repoOrganizationRef, PrdOrgRoleRepo repoRole, PrdOrgEmployeeRefRepo repoEmployeeRef) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.repoDimension = repoDimension;
        this.repoOrganization = repoOrganization;
        this.repoOrganizationRef = repoOrganizationRef;
        this.repoRole = repoRole;
        this.repoEmployeeRef = repoEmployeeRef;
    }
}

