/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.cal.query.CalResourcePriceQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityListVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeEqvaRatioService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeCommonService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskInfoPayload;
import com.elitesland.tw.tw5.api.prd.task.payload.TaskPackagePayload;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskPackageVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjectStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.TaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistBroadcastDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskPackageDAO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class PmsDistributeCommonServiceImpl
implements PmsDistributeCommonService {
    private static final Logger log = LoggerFactory.getLogger(PmsDistributeCommonServiceImpl.class);
    private final PmsDistributeDAO pmsDistributeDAO;
    private final PmsDistBroadcastDAO pmsDistBroadcastDAO;
    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final CrmOpportunityService opportunityService;
    private final TaskInfoDAO taskInfoDAO;
    private final TaskPackageDAO taskPackageDAO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService;
    private final CalResourceService calResourceService;
    private final BudgetCommonService budgetCommonService;
    private final WorkflowUtil workflowUtil;
    private final TransactionUtilService transactionUtilService;

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByReason(String reasonType, List<Long> reasonIds) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u6d3e\u53d1\u7c7b\u578b \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty(reasonIds)) {
            throw TwException.error("", "\u6d3e\u53d1\u4e8b\u7531ID \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        this.deleteSoftByList(this.pmsDistributeDAO.queryByReasons(reasonIds, reasonType));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoftByList(List<PmsDistributeVO> list) {
        if (!ObjectUtils.isEmpty(list)) {
            long count = list.stream().filter(v -> !DistributeEnum.distStatus.CREATE.getCode().equals(v.getDistStatus())).count();
            if (count > 0L) {
                throw TwException.error("", "\u4ec5\u6d3e\u53d1\u72b6\u6001\u4e3a\u65b0\u5efa\u4e14\u5ba1\u6279\u72b6\u6001\u672a\u63d0\u4ea4\u7684\u6570\u636e\u53ef\u4ee5\u5220\u9664\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List<Long> keys = list.stream().map(BaseViewModel::getId).collect(Collectors.toList());
            this.pmsDistributeDAO.deleteSoft(keys);
            keys = list.stream().filter(v -> DistributeEnum.distMethod.BROADCASTING.getCode().equals(v.getDistMethod())).map(v -> v.getId()).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(keys)) {
                this.pmsDistBroadcastDAO.deleteByDistIds(keys);
                this.pmsDistributeRespondDAO.deleteByDistIds(keys);
            }
        }
    }

    public void updateReasonStatus(PmsDistributeVO distributeVO) {
        if (DistributeEnum.distType.PROJECT.getCode().equals(distributeVO.getReasonType())) {
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
                this.pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.APPROVING.getCode(), distributeVO.getReceiverResId());
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
                this.pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.ACTIVE.getCode(), distributeVO.getReceiverResId());
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                this.pmsProjectService.updateProjStatus(distributeVO.getReasonId(), ProjectStatusEnum.CREATE.getCode(), null);
            }
        }
        if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType()) || DistributeEnum.distType.TASK_PACKAGE.getCode().equals(distributeVO.getReasonType())) {
            String status = "";
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTING.getCode())) {
                status = TaskStatusEnum.DISPATCH.getCode();
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.DISTRIBUTED.getCode())) {
                status = TaskStatusEnum.INPROCESS.getCode();
            }
            if (distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                status = TaskStatusEnum.CREATE.getCode();
            }
            this.updateFromDistribute(distributeVO, status);
        }
    }

    void checkBudget(List<TaskInfoVO> taskInfoVOs) {
        HashMap<String, List> projMap = new HashMap<String, List>();
        taskInfoVOs.forEach(taskInfoPayload -> {
            if (taskInfoPayload.getTaskParentId() == null) {
                Long reasonId;
                String reasonType = taskInfoPayload.getReasonType();
                String key = reasonType + "-" + (reasonId = taskInfoPayload.getReasonId());
                ArrayList<TaskInfoVO> taskInfoPayloads1 = (ArrayList<TaskInfoVO>)projMap.get(key);
                if (taskInfoPayloads1 == null) {
                    taskInfoPayloads1 = new ArrayList<TaskInfoVO>();
                }
                taskInfoPayloads1.add((TaskInfoVO)taskInfoPayload);
                projMap.put(key, taskInfoPayloads1);
            }
        });
        projMap.forEach((key, value) -> {
            String[] split = key.split("-");
            String reasonType = split[0];
            Long reasonId = Long.valueOf(split[1]);
            BigDecimal planAllEqva = value.stream().map(TaskInfoVO::getPlanEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.budgetCommonService.checkBudgetEqva(reasonId, reasonType, null, planAllEqva);
            Map<Long, List<TaskInfoVO>> collect = value.stream().filter(pay -> pay.getRelatedActId() != null).collect(Collectors.groupingBy(TaskInfoVO::getRelatedActId));
            collect.forEach((key0, value0) -> {
                BigDecimal planAllEqva0 = value.stream().map(TaskInfoVO::getPlanEqva).filter(Objects::nonNull).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                this.budgetCommonService.checkBudgetEqva(reasonId, reasonType, key0, planAllEqva0);
            });
        });
    }

    public void checkDistribute(PmsDistributeVO distributeVO) {
        if (DistributeEnum.distType.PROJECT.getCode().equals(distributeVO.getReasonType())) {
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(distributeVO.getReasonId());
            if (pmsProjectVO == null) {
                throw TwException.error("", "\u6d3e\u53d1\u9879\u76ee\u5b58\u5728");
            }
            if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.CREATE.getCode())) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u6d3e\u53d1");
            }
            CalAccountVO calAccountVO = this.calResourceService.queryAccount(CalAccTypeEnum.BU.getCode(), pmsProjectVO.getDeliBuId());
            BigDecimal avalQty = calAccountVO.getAvalQty() == null ? BigDecimal.ZERO : calAccountVO.getAvalQty();
            BigDecimal avalAmt = calAccountVO.getAvalAmt() == null ? BigDecimal.ZERO : calAccountVO.getAvalAmt();
            BigDecimal totalEqva = pmsProjectVO.getTotalEqva() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalEqva();
            BigDecimal totalCost = pmsProjectVO.getTotalCost() == null ? BigDecimal.ZERO : pmsProjectVO.getTotalCost();
            calAccountVO.setAvalQty(avalQty.subtract(totalEqva));
            calAccountVO.setAvalAmt(avalAmt.subtract(totalCost));
            this.calResourceService.checkAccount(calAccountVO);
        }
        if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType()) || DistributeEnum.distType.TASK_PACKAGE.getCode().equals(distributeVO.getReasonType())) {
            String reasonType = "";
            Long reasonId = 0L;
            ArrayList<TaskInfoVO> taskInfoVOs = new ArrayList<TaskInfoVO>();
            if (DistributeEnum.distType.TASK.getCode().equals(distributeVO.getReasonType())) {
                TaskInfoVO taskInfoVO = this.taskInfoDAO.queryByKey(distributeVO.getReasonId());
                if (taskInfoVO == null) {
                    throw TwException.error("", "\u6d3e\u53d1\u4efb\u52a1\u5b58\u5728");
                }
                if (!taskInfoVO.getTaskStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u4efb\u52a1\u6d3e\u53d1");
                }
                reasonType = taskInfoVO.getReasonType();
                reasonId = taskInfoVO.getReasonId();
                taskInfoVOs.add(taskInfoVO);
            } else {
                TaskPackageVO taskPackageVO = this.taskPackageDAO.queryByKey(distributeVO.getReasonId());
                reasonType = taskPackageVO.getReasonType();
                reasonId = taskPackageVO.getReasonId();
                if (taskPackageVO == null) {
                    throw TwException.error("", "\u6d3e\u53d1\u4efb\u52a1\u5305\u5b58\u5728");
                }
                if (!taskPackageVO.getTaskPackageStatus().equals(TaskStatusEnum.CREATE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u4e0b\u7684\u4efb\u52a1\u5305\u6d3e\u53d1");
                }
                List<TaskInfoVO> taskInfoVOS = this.taskInfoDAO.queryByTaskPackageId(distributeVO.getReasonId());
                taskInfoVOs.addAll(taskInfoVOS);
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(reasonId);
                if (pmsProjectVO == null) {
                    throw TwException.error("", "\u6d3e\u53d1\u9879\u76ee\u5b58\u5728");
                }
                if (!pmsProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\u6d3e\u53d1");
                }
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_BU.getCode())) {
                BuProjectVO buProjectVO = this.buProjectService.queryByKey(reasonId);
                if (buProjectVO == null) {
                    throw TwException.error("", "\u6d3e\u53d1\u9879\u76ee\u5b58\u5728");
                }
                if (!buProjectVO.getProjStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\u6d3e\u53d1");
                }
            }
            if (reasonType.equals(PmsReasonTypeEnum.PROJ_OPPO.getCode())) {
                CrmOpportunityQuery query = new CrmOpportunityQuery();
                query.setProjectId(reasonId);
                List crmOpportunityListVOS = this.opportunityService.queryListDynamic(query);
                if (ObjectUtils.isEmpty((Object)crmOpportunityListVOS)) {
                    throw TwException.error("", "\u4e8b\u7531\u4e0d\u5b58\u5728");
                }
                CrmOpportunityListVO crmOpportunityVO = (CrmOpportunityListVO)crmOpportunityListVOS.get(0);
                if (!crmOpportunityVO.getProjectStatus().equals(ProjectStatusEnum.ACTIVE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u9879\u76ee\u6fc0\u6d3b\u72b6\u6001\u6d3e\u53d1");
                }
            }
            this.checkBudget(taskInfoVOs);
            this.checkUserStatus(taskInfoVOs);
        }
    }

    void checkUserStatus(List<TaskInfoVO> taskInfoVOs) {
        taskInfoVOs.forEach(vo -> {
            PrdOrgEmployeeVO employee = this.cacheUtil.getEmployee(vo.getTaskResId());
            if (!employee.getResourceStatus().equals(SystemDefaultEnum.DefaultResourceStatus.getCode()) && !employee.getResourceStatus().equals(SystemDefaultEnum.LeaveIngResourceStatus.getCode())) {
                throw TwException.error("", "\u63a5\u5305\u8d44\u6e90\u72b6\u6001\u6682\u4e0d\u53ef\u63a5\u6536\u4efb\u52a1\u6d3e\u53d1");
            }
            if (!employee.getHrStatus().equals(SystemDefaultEnum.DefaultHrStatus.getCode())) {
                throw TwException.error("", "\u63a5\u5305\u8d44\u6e90\u72b6\u6001\u6682\u4e0d\u53ef\u63a5\u6536\u4efb\u52a1\u6d3e\u53d1");
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateFromDistribute(PmsDistributeVO distributeVO, String status) {
        String reasonType = distributeVO.getReasonType();
        Long reasonId = distributeVO.getReasonId();
        Long receiverResId = distributeVO.getReceiverResId();
        if (DistributeEnum.distType.TASK_PACKAGE.getCode().equals(reasonType)) {
            TaskPackageVO taskPackageVO = this.taskPackageDAO.queryByKey(reasonId);
            if (taskPackageVO == null) throw TwException.error("", "\u4fee\u6539\u6570\u636e\u4e0d\u5b58\u5728");
            TaskPackagePayload taskPackagePayload = new TaskPackagePayload();
            taskPackagePayload.setId(reasonId);
            taskPackagePayload.setTaskPackageStatus(status);
            if (!taskPackageVO.getReceiverResId().equals(receiverResId)) {
                String taskPackageName = taskPackageVO.getReasonName() + "\u4efb\u52a1\u5305-" + this.cacheUtil.getUserName(receiverResId) + "-" + taskPackageVO.getStartDate().toString() + "~" + taskPackageVO.getEndDate().toString();
                taskPackagePayload.setReceiverResId(receiverResId);
                taskPackagePayload.setTaskPackageName(taskPackageName);
                CalResourcePriceQuery query = new CalResourcePriceQuery();
                query.setResId(receiverResId);
                if (taskPackageVO.getReasonType().equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
                    query.setProjId(taskPackageVO.getReasonId());
                }
                BigDecimal bigDecimal = this.calResourceService.queryIncomePrice(query);
                taskPackagePayload.setIncomePrice(bigDecimal);
                taskPackagePayload.setReceiverBuId(this.cacheUtil.getDefaultOrgIdByUserId(receiverResId));
                taskPackagePayload.setEqvaRatio(this.prdOrgEmployeeEqvaRatioService.getEqvaRatio(receiverResId, null));
            }
            this.taskPackageDAO.updateByKeyDynamic(taskPackagePayload);
            this.taskInfoDAO.updateStatusByTaskPackageId(reasonId, status, receiverResId);
            return;
        } else {
            TaskInfoVO infoVO;
            Boolean isUp = true;
            if (status.equals(TaskStatusEnum.CREATE.getCode()) && (infoVO = this.taskInfoDAO.queryByKey0(reasonId)).getTaskParentId() != null) {
                TaskInfoVO infoVO1 = this.taskInfoDAO.queryByKey0(infoVO.getTaskParentId());
                BigDecimal totalEqva = infoVO1.getTotalEqva().add(infoVO.getPlanEqva());
                BigDecimal splitEqva = infoVO1.getSplitEqva().subtract(infoVO.getPlanEqva());
                TaskInfoPayload taskParentPayload = new TaskInfoPayload();
                taskParentPayload.setId(infoVO.getTaskParentId());
                taskParentPayload.setTotalEqva(totalEqva);
                taskParentPayload.setSplitEqva(splitEqva);
                this.taskInfoDAO.updateByKeyDynamic(taskParentPayload);
                this.taskInfoDAO.deleteSoft(List.of(reasonId));
                isUp = false;
            }
            if (!isUp.booleanValue()) return;
            this.taskInfoDAO.updateStatus(reasonId, status, receiverResId);
        }
    }

    public PmsDistributeCommonServiceImpl(PmsDistributeDAO pmsDistributeDAO, PmsDistBroadcastDAO pmsDistBroadcastDAO, PmsDistributeRespondDAO pmsDistributeRespondDAO, PmsProjectService pmsProjectService, BuProjectService buProjectService, CrmOpportunityService opportunityService, TaskInfoDAO taskInfoDAO, TaskPackageDAO taskPackageDAO, CacheUtil cacheUtil, PrdOrgEmployeeEqvaRatioService prdOrgEmployeeEqvaRatioService, CalResourceService calResourceService, BudgetCommonService budgetCommonService, WorkflowUtil workflowUtil, TransactionUtilService transactionUtilService) {
        this.pmsDistributeDAO = pmsDistributeDAO;
        this.pmsDistBroadcastDAO = pmsDistBroadcastDAO;
        this.pmsDistributeRespondDAO = pmsDistributeRespondDAO;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.opportunityService = opportunityService;
        this.taskInfoDAO = taskInfoDAO;
        this.taskPackageDAO = taskPackageDAO;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeEqvaRatioService = prdOrgEmployeeEqvaRatioService;
        this.calResourceService = calResourceService;
        this.budgetCommonService = budgetCommonService;
        this.workflowUtil = workflowUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

