/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.shorturl.service;

import cn.hutool.core.util.RandomUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.annotation.TenantTransaction;
import com.elitescloud.cloudt.core.annotation.common.TenantIsolateType;
import com.elitesland.tw.tw5.api.prd.shorturl.payload.ShortUrlRefPayload;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlConfQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.query.ShortUrlRefQuery;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlConfService;
import com.elitesland.tw.tw5.api.prd.shorturl.service.ShortUrlRefService;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlConfVO;
import com.elitesland.tw.tw5.api.prd.shorturl.vo.ShortUrlRefVO;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.URLShortenerUtil;
import com.elitesland.tw.tw5.server.prd.shorturl.convert.ShortUrlRefConvert;
import com.elitesland.tw.tw5.server.prd.shorturl.dao.ShortUrlRefDAO;
import com.elitesland.tw.tw5.server.prd.shorturl.entity.ShortUrlRefDO;
import com.elitesland.tw.tw5.server.prd.shorturl.repo.ShortUrlRefRepo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ShortUrlRefServiceImpl
extends BaseServiceImpl
implements ShortUrlRefService {
    private static final Logger log = LoggerFactory.getLogger(ShortUrlRefServiceImpl.class);
    private final ShortUrlRefRepo shortUrlRefRepo;
    private final ShortUrlRefDAO shortUrlRefDAO;
    @Autowired
    private ShortUrlConfService shortUrlConfService;

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public PagingVO<ShortUrlRefVO> queryPaging(ShortUrlRefQuery query) {
        return this.shortUrlRefDAO.queryPaging(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public List<ShortUrlRefVO> queryListDynamic(ShortUrlRefQuery query) {
        return this.shortUrlRefDAO.queryListDynamic(query);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO queryByKey(Long key) {
        ShortUrlRefDO entity = this.shortUrlRefRepo.findById(key).orElseGet(ShortUrlRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlRefVO vo = ShortUrlRefConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO queryByCodeAndAddVisitNum(String code) {
        if (StringUtils.hasText((String)code)) {
            ShortUrlRefVO shortUrlRefVO = this.shortUrlRefDAO.queryByCode(code.trim());
            if (null != shortUrlRefVO) {
                Integer visitNum = shortUrlRefVO.getVisitNum();
                if (null == visitNum) {
                    visitNum = 0;
                }
                ShortUrlRefPayload shortUrlRefPayload = new ShortUrlRefPayload();
                shortUrlRefPayload.setId(shortUrlRefVO.getId());
                shortUrlRefPayload.setVisitNum(Integer.valueOf(visitNum + 1));
                this.shortUrlRefDAO.updateByKeyDynamicNotLogin(shortUrlRefPayload);
            }
            return shortUrlRefVO;
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO insert(ShortUrlRefPayload payload) {
        ShortUrlRefDO entityDo = ShortUrlRefConvert.INSTANCE.toDo(payload);
        return ShortUrlRefConvert.INSTANCE.toVo((ShortUrlRefDO)this.shortUrlRefRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO saveRedirect(String longUrlSuffix) {
        ShortUrlConfVO shortUrlConfVO = new ShortUrlConfVO();
        shortUrlConfVO.setShortUrlRelative("/tw-server5-crm/s/r/");
        shortUrlConfVO.setShortUrlPre("https://crm.tw.elitesland.com/tw-server5-crm/s/r/");
        shortUrlConfVO.setLongUrlPre("https://crmapp.tw.elitesland.com/");
        return this.commonSave(longUrlSuffix, shortUrlConfVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO saveRedirect(String longUrlSuffix, String shortUrlRelative, String shortUrlPre, String longUrlPre) {
        ShortUrlConfVO shortUrlConfVO = new ShortUrlConfVO();
        shortUrlConfVO.setShortUrlRelative("/tw-server5-crm/s/r/");
        if (StringUtils.hasText((String)shortUrlRelative)) {
            shortUrlConfVO.setShortUrlRelative(shortUrlRelative);
        }
        shortUrlConfVO.setShortUrlPre("https://crm.tw.elitesland.com/tw-server5-crm/s/r/");
        if (StringUtils.hasText((String)shortUrlPre)) {
            shortUrlConfVO.setShortUrlPre(shortUrlPre);
        }
        shortUrlConfVO.setLongUrlPre("https://crmapp.tw.elitesland.com/");
        if (StringUtils.hasText((String)longUrlPre)) {
            shortUrlConfVO.setLongUrlPre(longUrlPre);
        }
        return this.commonSave(longUrlSuffix, shortUrlConfVO);
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO saveForward(String longUrlSuffix) {
        ShortUrlConfVO shortUrlConfVO = new ShortUrlConfVO();
        shortUrlConfVO.setShortUrlPre("https://crm.tw.elitesland.com/tw-server5-crm/s/f/");
        shortUrlConfVO.setLongUrlPre("https://crm.tw.elitesland.com/");
        return this.commonSave(longUrlSuffix, shortUrlConfVO);
    }

    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    private ShortUrlRefVO commonSave(String longUrlSuffix, ShortUrlConfVO shortUrlConfVO) {
        Long tenantId = GlobalUtil.getTenantId();
        ShortUrlConfQuery shortUrlConfQuery = new ShortUrlConfQuery();
        shortUrlConfQuery.setSecTenantId(tenantId);
        List shortUrlConfVOS = this.shortUrlConfService.queryListDynamic(shortUrlConfQuery);
        if (!CollectionUtils.isEmpty((Collection)shortUrlConfVOS)) {
            shortUrlConfVO = (ShortUrlConfVO)shortUrlConfVOS.get(0);
        }
        String shortUrlPre = shortUrlConfVO.getShortUrlPre();
        URLShortenerUtil urlShortenerUtil = new URLShortenerUtil(shortUrlPre);
        String longUrl = shortUrlConfVO.getLongUrlPre() + longUrlSuffix;
        String code = urlShortenerUtil.longToShortUrl(longUrl, RandomUtil.randomInt((int)10000));
        String shortUrl = shortUrlPre + code;
        ShortUrlRefQuery countQuery = new ShortUrlRefQuery();
        countQuery.setShortUrl(shortUrl);
        countQuery.setCode(code);
        countQuery.setLongUrl(longUrl);
        List<ShortUrlRefVO> shortUrlRefVOS = this.shortUrlRefDAO.queryListDynamic(countQuery);
        if (!CollectionUtils.isEmpty(shortUrlRefVOS)) {
            return shortUrlRefVOS.get(0);
        }
        ShortUrlRefPayload shortUrlRefPayload = new ShortUrlRefPayload();
        shortUrlRefPayload.setShortUrl(shortUrl);
        shortUrlRefPayload.setCode(code);
        shortUrlRefPayload.setLongUrl(longUrl);
        ShortUrlRefDO entityDo = ShortUrlRefConvert.INSTANCE.toDo(shortUrlRefPayload);
        return ShortUrlRefConvert.INSTANCE.toVo((ShortUrlRefDO)this.shortUrlRefRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public ShortUrlRefVO update(ShortUrlRefPayload payload) {
        ShortUrlRefDO entity = this.shortUrlRefRepo.findById(payload.getId()).orElseGet(ShortUrlRefDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ShortUrlRefDO entityDo = ShortUrlRefConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return ShortUrlRefConvert.INSTANCE.toVo((ShortUrlRefDO)this.shortUrlRefRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    @TenantTransaction(isolateType=TenantIsolateType.DEFAULT)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.shortUrlRefDAO.deleteSoft(keys);
        }
    }

    public ShortUrlRefServiceImpl(ShortUrlRefRepo shortUrlRefRepo, ShortUrlRefDAO shortUrlRefDAO) {
        this.shortUrlRefRepo = shortUrlRefRepo;
        this.shortUrlRefDAO = shortUrlRefDAO;
    }
}

