package com.elitesland.tw.tw5.server.common.crontask.payload;


import lombok.Data;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;

/**
 * 合同开票批次
 *
 * @author eason.shi
 * @since 2018-11-20
 */
@Data
public class TwInvBatchEntity implements Serializable {
    /**
     * id - T_INV_BATCH.ID
     */
    private Long id;

    /**
     * 批次号 - T_INV_BATCH.BATCH_NO
     */
    private String batchNo;

    /**
     * 批次状态 已申请/待开票/已开票/已取消 - T_INV_BATCH.BATCH_STATUS
     */
    private String batchStatus;

    /**
     * 发票信息ID - T_INV_BATCH.INVINFO_ID
     */
    private Long invinfoId;

    /**
     * 发票抬头 - T_INV_BATCH.INV_TITLE
     */
    @NotNull
    private String invTitle;

    /**
     * 发票类型 - T_INV_BATCH.INV_TYPE
     */
    @NotNull
    private String invType;

    /**
     * 税率 - T_INV_BATCH.TAX_RATE
     */
    private BigDecimal taxRate;

    /**
     * 递送方式 - T_INV_BATCH.DELI_METHOD
     */
    private String deliMethod;

    /**
     * 收件人 - T_INV_BATCH.CONTACT_PERSON
     */
    private String contactPerson;

    /**
     * 收件人地址 - T_INV_BATCH.INV_ADDR
     */
    private String invAddr;

    /**
     * 收件人邮箱 - T_INV_BATCH.INV_EMAIL
     */
    private String invEmail;

    /**
     * 收件人电话 - T_INV_BATCH.INV_TEL
     */
    private String invTel;

    /**
     * 开户行 - T_INV_BATCH.BANK_NAME
     */
    private String bankName;

    /**
     * 账号 - T_INV_BATCH.ACCOUNT_NO
     */
    private String accountNo;

    /**
     * 开票日期 - T_INV_BATCH.BATCH_DATE
     */
    private LocalDate batchDate;

    /**
     * 发票内容 - T_INV_BATCH.INV_CONTENT
     */
    private String invContent;

    /**
     * 发票商品ID - T_INV_BATCH.INV_ITEM_ID
     */
    private Long invItemId;


    /**
     * 付款方式 - T_INV_BATCH.PAY_METHOD
     */
    private String payMethod;

    /**
     * 开票说明 - T_INV_BATCH.INV_DESC
     */
    private String invDesc;

    /**
     * 备注 - T_INV_BATCH.REMARK
     */
    private String remark;

    /**
     * 合同收款计划ID集合
     */
    private List<Long> contractRecvPlanIds;

    private String apprStatus;

    /**
     * INV_AMT
     */
    private BigDecimal invAmt;//开票金额
    private Byte saveAbFlag;//是否自动保存开票信息到地址簿 0 不保存 1保存
    private LocalDate antiRecvDate;//预计到账日期
    private String addr;//地址 用于保存地址簿中 开票信息地址
    private String disDisc;//退票原因

    private String taxNo;//税号 仅用于界面显示
    private String currCode;//币种 仅用于界面显示

    private String invTelAb;//地址簿中的电话

    private String sendEmail;

    /**
     * 删除标志
     */
    private Long delFlag;
}
