package com.elitesland.tw.tw5.server.common.funConfig.service;

import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.funConfig.repo.BusinessDocTypeConfigPathExprRepo;
import com.elitesland.tw.tw5.server.common.funConfig.dao.BusinessDocTypeConfigPathExprDAO;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigPathExprConvert;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessDocTypeConfigPathExprService;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessDocTypeConfigPathExprPayload;
import com.elitesland.tw.tw5.server.common.funConfig.entity.BusinessDocTypeConfigPathExprDO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessDocTypeConfigPathExprVO;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessDocTypeConfigPathExprQuery;
import com.elitesland.tw.tw5.server.common.funConfig.convert.BusinessDocTypeConfigPathExprConvert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.util.*;

/**
 * 文档配置函数表达式
 *
 * @author wangly
 * @date 2024-07-02
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class BusinessDocTypeConfigPathExprServiceImpl extends BaseServiceImpl implements BusinessDocTypeConfigPathExprService {

    private final BusinessDocTypeConfigPathExprRepo businessDocTypeConfigPathExprRepo;
    private final BusinessDocTypeConfigPathExprDAO businessDocTypeConfigPathExprDAO;
    @Autowired
    @Lazy
    private  BusinessTableFieldsService businessTableFieldsService;

    @Override
    public PagingVO<BusinessDocTypeConfigPathExprVO> queryPaging(BusinessDocTypeConfigPathExprQuery query){
        return businessDocTypeConfigPathExprDAO.queryPaging(query);
    }

    @Override
    public List<BusinessDocTypeConfigPathExprVO> queryListDynamic(BusinessDocTypeConfigPathExprQuery query){
        return businessDocTypeConfigPathExprDAO.queryListDynamic(query);
    }

    @Override
    public BusinessDocTypeConfigPathExprVO queryByKey(Long key) {
        BusinessDocTypeConfigPathExprDO entity = businessDocTypeConfigPathExprRepo.findById(key).orElseGet(BusinessDocTypeConfigPathExprDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigPathExprVO vo = BusinessDocTypeConfigPathExprConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigPathExprVO insert(BusinessDocTypeConfigPathExprPayload payload) {
        // 先保存文档类型
        BusinessTableFieldsPayload fieldsPayload = new BusinessTableFieldsPayload();
        fieldsPayload.setId(payload.getId());
        fieldsPayload.setShowType(payload.getShowType());
        businessTableFieldsService.update(fieldsPayload);
        // 再保存文档配置
        BusinessDocTypeConfigPathExprQuery pathExprQuery = new BusinessDocTypeConfigPathExprQuery();
        pathExprQuery.setTableName(payload.getTableName());
        pathExprQuery.setField(payload.getField());
        List<BusinessDocTypeConfigPathExprVO> businessDocTypeConfigPathExprVOS = queryListDynamic(pathExprQuery);
        if (!CollectionUtils.isEmpty(businessDocTypeConfigPathExprVOS)) {
            throw TwException.error("","该字段已配置过公式，请勿重复配置");
        }
        BusinessDocTypeConfigPathExprDO entityDo = BusinessDocTypeConfigPathExprConvert.INSTANCE.toDo(payload);
        return BusinessDocTypeConfigPathExprConvert.INSTANCE.toVo(businessDocTypeConfigPathExprRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public BusinessDocTypeConfigPathExprVO update(BusinessDocTypeConfigPathExprPayload payload) {
        BusinessDocTypeConfigPathExprDO entity = businessDocTypeConfigPathExprRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigPathExprDO::new);
        Assert.notNull(entity.getId(), "不存在");
        BusinessDocTypeConfigPathExprDO entityDo = BusinessDocTypeConfigPathExprConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BusinessDocTypeConfigPathExprConvert.INSTANCE.toVo(businessDocTypeConfigPathExprRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(BusinessDocTypeConfigPathExprPayload payload) {
        BusinessDocTypeConfigPathExprDO entity = businessDocTypeConfigPathExprRepo.findById(payload.getId()).orElseGet(BusinessDocTypeConfigPathExprDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = businessDocTypeConfigPathExprDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            businessDocTypeConfigPathExprDAO.deleteSoft(keys);
        }
    }

    @Override
    public BusinessDocTypeConfigPathExprVO getFunctionExpr(String tableName, String field) {
        BusinessDocTypeConfigPathExprQuery query = new BusinessDocTypeConfigPathExprQuery();
        query.setTableName(tableName);
        query.setTableName(field);
        List<BusinessDocTypeConfigPathExprVO> businessDocTypeConfigPathExprVOS = queryListDynamic(query);
        if(CollectionUtils.isEmpty(businessDocTypeConfigPathExprVOS)){
            throw TwException.error("","表单字段"+tableName+"未配置公式");
        }
        return businessDocTypeConfigPathExprVOS.get(0);
    }
}
