package com.elitesland.tw.tw5.server.common.permission.annotation;

import com.elitesland.tw.tw5.server.common.permission.enums.FunctionTypeEnum;
import com.elitesland.tw.tw5.server.common.permission.enums.PermissionTypeEnum;

import java.lang.annotation.*;

/**
 * 权限控制接口 注解
 *
 * @author : JS
 * @date 2023/09/21
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Documented
public @interface PermissionFunction {

    /**
     * 功能 可维护多个
     * <pre>{@code
     * @PermissionFunction(functions = {
     *             @FunctionDetail(name = "查询", type = FunctionTypeEnum.TAB),
     *             @FunctionDetail(name = "分页", type = FunctionTypeEnum.TAB),
     *     })
     * 或者
     * @PermissionFunction(functions = @FunctionDetail(name = "查询", type = FunctionTypeEnum.TAB))
     * }</pre>
     */
    FunctionDetail[] functions();

    /**
     * 是否字段权限  默认为否
     */
    boolean fieldPermission() default false;

    /**
     * 权限类型
     */
    PermissionTypeEnum permissionType() default PermissionTypeEnum.FIELD_PERMISSION;

}
