package com.elitesland.tw.tw5.server.common.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmLeadsListVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmOpportunityVO;
import com.elitesland.tw.tw5.api.prd.org.query.PrdOrgOrganizationQuery;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.dao.TransferUtilDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.SaleConContractDAO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.SaleConContractRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 数据翻译
 */
@Service
@RequiredArgsConstructor
public class BusinessFollowServiceImpl {
    private final CacheUtil cacheUtil;
    private final TransferUtilDAO dao;
   // private final CrmCustomerDAO daoCustomer;
    private final CrmLeadsService leadService;
   // private final PrdAbAddressService serviceAbAddress;
    private final CrmOpportunityService opportunityService;
    private final HttpUtil httpUtil;
    //private final SaleConContractService saleConContractService;
   // private final CrmCustomerService customerService;
    private final UdcUtil udcUtil;
    private final SaleConContractRepo saleConContractRepo;
    private final SaleConContractDAO saleConContractDAO;
    private final PrdOrgOrganizationService orgService;
    private final BusinessPartnerService businessPartnerService;


    /**
     * 获取线索数据
     *
     * @param query
     * @return
     */
    public PagingVO<CrmLeadsListVO> queryLeadsFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));

        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setCurrent(query.getCurrent());
        leadsQuery.setSize(query.getSize());
   //     leadsQuery.setFormalCustomerId(customerId);

        leadsQuery.setFormalCustomerId(customerId);
        //2023/11/28 先把查询所有去掉
     //   leadsQuery.setIsPermission(!rolePermission);

        return leadService.paging(leadsQuery);
    }


    /**
     * 获取商机数据
     *
     * @param query
     * @return
     */
    public PagingVO<CrmOpportunityVO> queryOppoFollow(TwQueryParam query, Long customerId) {
        Boolean rolePermission = cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLATFORM_RES.getCode(), RoleEnum.CUST_OPER_MANAGER.getCode()));
        CrmOpportunityQuery oppoQuery = new CrmOpportunityQuery();
        oppoQuery.setCurrent(query.getCurrent());
        oppoQuery.setSize(query.getSize());
        oppoQuery.setFormalCustomerId(customerId);
        //2023/11/29 都默认走权限 wly
    //    oppoQuery.setIsPermission(!rolePermission);
        return opportunityService.paging(oppoQuery);
    }

    /**
     * 获取合同数量
     *
     * @param customerId
     * @return
     */
//    public Object queryContractNum(Long customerId) {
//        String url = "api/openReport/v1/sync/contractCount";
//       // PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
//        BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(customerId);
//        if (ObjectUtils.isEmpty(businessPartnerVO)) {
//            throw TwException.error("", "关联客户数据不存在，请核验！");
//        }
//        //获取4.0用户id
//        List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
//        Long userId4 = 0L;
//        if (!ObjectUtils.isEmpty(longs)) {
//            userId4 = longs.get(0);
//        }
//        Map<String, Object> map = new HashMap<>();
//        map.put("bookId", businessPartnerVO.getBookIdV4());
//        map.put("userId", userId4);
//        String result = httpUtil.sendSyncGet(url, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                return data.get("datum");
//            }
//        }
//        return 0;
//    }
//
//    /**
//     * 获取项目数量
//     *
//     * @param customerId
//     * @return
//     */
//    public Object queryProjectNum(Long customerId) {
//        String url = "api/openReport/v1/sync/countProjectNumByCustId";
//      //  PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
//        BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(customerId);
//        if (ObjectUtils.isEmpty(businessPartnerVO)) {
//            throw TwException.error("", "关联客户数据不存在，请核验！");
//        }
//        List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
//        Long userId4 = 0L;
//        if (!ObjectUtils.isEmpty(longs)) {
//            userId4 = longs.get(0);
//        }
//        Map<String, Object> map = new HashMap<>();
//       // map.put("bookId", prdAbVO.getBookIdV4());
//        map.put("bookId", businessPartnerVO.getBookId());
//        map.put("userId", userId4);
//        String result = httpUtil.sendSyncGet(url, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                return data.get("datum");
//            }
//        }
//        return 0;
//    }

    /**
     * 获取4.0的合同数据
     *
     * @param query
     * @return
     */
//    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId) {
//
//        Map<String, Object> resultMap = new HashMap<>();
//        resultMap.put("total", 0);
//        resultMap.put("records", new ArrayList<>());
//        String url = "api/openReport/v1/sync/contract";
//        PrdAbVO prdAbVO = daoCustomer.queryAbVOBykey(customerId);
//        if (ObjectUtils.isEmpty(prdAbVO)) {
//            throw TwException.error("", "关联客户数据不存在，请核验！");
//        }
//        //获取4.0用户id
//        List<Long> longs = dao.queryEmployeeTw4Ids(List.of(GlobalUtil.getLoginUserId()));
//        Long userId4 = 0L;
//        if (!ObjectUtils.isEmpty(longs)) {
//            userId4 = longs.get(0);
//        }
//        Map<String, Object> map = new HashMap<>();
//        map.put("bookId", prdAbVO.getBookIdV4());
//        map.put("userId", userId4);
//        map.put("offset", query.getPageRequest().getOffset());
//        map.put("limit", query.getPageRequest().getPageSize());
//        String result = httpUtil.sendSyncGet(url, map);
//        Map<String, Object> data = (Map) JSON.parse(result);
//        if ((data.get("ok") + "").equals("true")) {
//            if (!ObjectUtils.isEmpty(data.get("datum"))) {
//                Map<String, Object> datas = (Map<String, Object>) data.get("datum");
//                resultMap.put("total", datas.get("total"));
//                resultMap.put("records", datas.get("rows"));
//            }
//        }
//        return resultMap;
//    }


    /**
     * 获取4.0的合同数据
     *
     * @param query
     * @return
     */
    public Map<String, Object> queryContractFollow(TwQueryParam query, Long customerId) {
        // 客户id查询地址簿id 业务伙伴优化 todo
      //  Long custBookId = customerService.getCustBookId(customerId);
        BusinessPartnerVO businessPartnerVO = businessPartnerService.queryByKey(customerId);
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        saleConContractQuery.setMainType("SUB");
       // saleConContractQuery.setCustId(custBookId);
        saleConContractQuery.setCustId(businessPartnerVO.getBookId());
        // 查询合同列表
        //PagingVO<SaleConContractVO> saleConContractVOPagingVO = saleConContractService.queryPaging(saleConContractQuery);
        getPermissionParams(saleConContractQuery);
        PagingVO<SaleConContractVO> saleConContractVOPagingVO = saleConContractDAO.queryPaging(saleConContractQuery);
        List<SaleConContractVO> records = saleConContractVOPagingVO.getRecords();
        records = udcUtil.translateList(records);
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put("total", saleConContractVOPagingVO.getTotal());
        resultMap.put("records", records);
        return resultMap;
//        // 翻译合同id,和主合同id
//        String result = httpUtil.sendGet(tw4_url + get_v4_contractIds, new HashMap<>());
//        Map<String, Object> data = (Map) JSON.parse(result);
//        if ((data.get("ok") + "").equals("true")) {
//            Map<String, Object> V5AndV4Map = (Map<String, Object>) data.get("datum");
//            records.stream().forEach(e->{
//                e.setId(Long.valueOf(V5AndV4Map.get(e.getId()+"")+""));
//                e.setParentId(Long.valueOf(V5AndV4Map.get(e.getParentId()+"")+""));
//            });
//
//            Map<String, Object> resultMap = new HashMap<>();
//            resultMap.put("total", saleConContractVOPagingVO.getTotal());
//            resultMap.put("records", records);
//            return resultMap;
//        }else{
//            throw TwException.error("","无法查询到4.0的合同信息！");
//        }
    }

    private void getPermissionParams(SaleConContractQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        // 获取角色
        List<String> userSystemRoleCodes = cacheUtil.getSystemRoleCodes(loginUserId);
        // 销售副总裁(SALES_VP)、销售合同管理员(SALES_CONTRACT_ADMIN)、系统管理员(SYS)、财务负责人(FIN_PIC)、商务负责人(BUSINESS_MANAGER)、合同归档管理员(CONTRACT_FILING)、平台财务负责人(PLAT_FIN_PIC)、运营总裁(OPERATION_PRESIDENT)、财务核定(FIN_CHECK_PIC)可以看到全部
        List<String> roles = Arrays.asList("SALES_VP", "SALES_CONTRACT_ADMIN", "SYS", "FIN_PIC", "BUSINESS_MANAGER", "CONTRACT_FILING", "PLAT_FIN_PIC", "OPERATION_PRESIDENT", "FIN_CHECK_PIC", "PLAT_FINANCIAL_PERFORMANCE_STATISTICS");
        if ((!CollectionUtils.isEmpty(userSystemRoleCodes)) && CollectionUtils.containsAny(userSystemRoleCodes, roles)) {
            return;
        }
        // 查看当前登录人是哪个bu的leader
        PrdOrgOrganizationQuery orgQuery = new PrdOrgOrganizationQuery();
        orgQuery.setManageId(loginUserId);
        orgQuery.setSize(Integer.MAX_VALUE);
        PagingVO<PrdOrgOrganizationVO> paging = orgService.paging(orgQuery);
        List<PrdOrgOrganizationVO> records = paging.getRecords();
        if (!CollectionUtils.isEmpty(records)) {
            List<Long> orgIds = records.stream().map(PrdOrgOrganizationVO::getId).collect(Collectors.toList());
            query.setOrgIdsByPermission(orgIds);
        } else {
            query.setOrgIdsByPermission(new ArrayList<Long>());
        }
        // 设置负责人是当前登录人
        query.setUserIdsByPermission(Collections.singletonList(loginUserId));
    }

}
