package com.elitesland.tw.tw5.server.prd.acc.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimBusItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimItemConfigRefPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccBusinessItemQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimBusItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimItemConfigRefQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccBusinessItemService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimBusItemConfigService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimItemConfigRefService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBusinessItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimBusItemConfigVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimItemConfigRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimBusItemConfigConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimBusItemConfigDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimBusItemConfigDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimBusItemConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 报销科目配置管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimBusItemConfigServiceImpl extends BaseServiceImpl implements AccReimBusItemConfigService {

    private final AccReimBusItemConfigRepo repo;
    private final AccReimBusItemConfigDAO dao;
    private final AccReimItemConfigRefService accReimItemConfigRefService;
    private final AccBusinessItemService accBusinessItemService;

    @Override
    public PagingVO<AccReimBusItemConfigVO> queryPaging(AccReimBusItemConfigQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<AccReimBusItemConfigVO> queryListDynamic(AccReimBusItemConfigQuery query) {
        List<AccReimBusItemConfigVO> accReimBusItemConfigVOS = dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimBusItemConfigVOS)) {
            List<Long> configIds = accReimBusItemConfigVOS.stream().map(AccReimBusItemConfigVO::getId).collect(Collectors.toList());
            AccReimItemConfigRefQuery refQuery = new AccReimItemConfigRefQuery();
            refQuery.setReimItemConfigIds(configIds);
            List<AccReimItemConfigRefVO> accReimItemConfigRefVOS = accReimItemConfigRefService.queryListDynamic(refQuery);
            Map<Long, List<AccReimItemConfigRefVO>> refMap = accReimItemConfigRefVOS.stream().collect(Collectors.groupingBy(AccReimItemConfigRefVO::getReimItemConfigId));
            //赋明细
            accReimBusItemConfigVOS.forEach(
                    vo -> {
                        List<AccReimItemConfigRefVO> detail = refMap.get(vo.getId());
                        if (!ObjectUtils.isEmpty(detail)) {
                            List<Long> busItemIds = detail.stream().map(AccReimItemConfigRefVO::getBusAccItemId).collect(Collectors.toList());
                            AccBusinessItemQuery businessItemQuery = new AccBusinessItemQuery();
                            businessItemQuery.setIdList(busItemIds);
                            List<AccBusinessItemVO> accBusinessItemVOS = accBusinessItemService.queryListDynamic(businessItemQuery);
                            if (!ObjectUtils.isEmpty(accBusinessItemVOS)) {
                                vo.setBusItemVolist(accBusinessItemVOS);
                            }
                        }
                    }
            );
        }
        return accReimBusItemConfigVOS;
    }

    @Override
    public AccReimBusItemConfigVO queryByKey(Long key) {
        AccReimBusItemConfigVO accReimBusItemConfigVO = dao.queryByKey(key);
        AccReimItemConfigRefQuery query = new AccReimItemConfigRefQuery();
        query.setReimItemConfigId(key);
        List<AccReimItemConfigRefVO> accReimItemConfigRefVOS = accReimItemConfigRefService.queryListDynamic(query);
        //目前仅返回核算项目的实体list即可
        if (!ObjectUtils.isEmpty(accReimItemConfigRefVOS)) {
            List<Long> busItemIds = accReimItemConfigRefVOS.stream().map(AccReimItemConfigRefVO::getBusAccItemId).collect(Collectors.toList());
            AccBusinessItemQuery businessItemQuery = new AccBusinessItemQuery();
            businessItemQuery.setIdList(busItemIds);
            List<AccBusinessItemVO> accBusinessItemVOS = accBusinessItemService.queryListDynamic(businessItemQuery);
            if (!ObjectUtils.isEmpty(accBusinessItemVOS)) {
                accReimBusItemConfigVO.setBusItemVolist(accBusinessItemVOS);
            }
        }
        return accReimBusItemConfigVO;
    }

    @Override
    @Transactional
    public AccReimBusItemConfigVO insert(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigQuery query = new AccReimBusItemConfigQuery();
        query.setReasonType(payload.getReasonType());
        query.setReimDocType(payload.getReimDocType());
        List<AccReimBusItemConfigVO> accReimBusItemConfigVOS = dao.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(accReimBusItemConfigVOS)) {
            log.error("当前报销类型、事由类型对应的科目配置信息已存在，请勿重复添加！,报销类型 is {}，事由类型 is {}", payload.getReimDocType(), payload.getReasonType());
            throw TwException.error("", "当前报销类型、事由类型对应的科目配置信息已存在，请勿重复添加！");
        }
        AccReimBusItemConfigDO entityDo = AccReimBusItemConfigConvert.INSTANCE.toDo(payload);
        AccReimBusItemConfigVO vo = AccReimBusItemConfigConvert.INSTANCE.toVo(repo.save(entityDo));
        List<AccReimItemConfigRefPayload> refPayloads = new ArrayList<>();
        if (!ObjectUtils.isEmpty(payload.getBusItemIdList())) {
            payload.getBusItemIdList().forEach(
                    busItemId -> {
                        AccReimItemConfigRefPayload refPayload = new AccReimItemConfigRefPayload();
                        refPayload.setBusAccItemId(busItemId);
                        refPayload.setReimItemConfigId(vo.getId());
                        refPayloads.add(refPayload);
                    }
            );
        }
        accReimItemConfigRefService.batchInsert(refPayloads);
        return vo;
    }

    @Override
    @Transactional
    public AccReimBusItemConfigVO update(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigDO entity = repo.findById(payload.getId()).orElseGet(AccReimBusItemConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimBusItemConfigDO entityDo = AccReimBusItemConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimBusItemConfigConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public void updateByKeyDynamic(AccReimBusItemConfigPayload payload) {
        AccReimBusItemConfigVO vo = dao.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty(vo)) {
            throw TwException.error("", "当前科目配置不存在，id:" + payload.getId());
        }
        dao.updateByKeyDynamic(payload);
        //先删
        accReimItemConfigRefService.delByReimConfigId(vo.getId());
        //再存
        List<AccReimItemConfigRefPayload> refPayloads = new ArrayList<>();
        if (!ObjectUtils.isEmpty(payload.getBusItemIdList())) {
            payload.getBusItemIdList().forEach(
                    busItemId -> {
                        AccReimItemConfigRefPayload refPayload = new AccReimItemConfigRefPayload();
                        refPayload.setBusAccItemId(busItemId);
                        refPayload.setReimItemConfigId(vo.getId());
                        refPayloads.add(refPayload);
                    }
            );
        }
        accReimItemConfigRefService.batchInsert(refPayloads);
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
            keys.forEach(
                    accReimItemConfigRefService::delByReimConfigId
            );
        }
    }

}
