package com.elitesland.tw.tw5.server.prd.adm.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyQuery;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmBusitripApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.entity.QAdmBusitripApplyDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmBusitripApplyRepo;
import com.elitesland.tw.tw5.server.prd.pms.entity.QPmsProjectDO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Repository
@RequiredArgsConstructor
public class AdmBusitripApplyDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final AdmBusitripApplyRepo repo;
    private final QAdmBusitripApplyDO qdo = QAdmBusitripApplyDO.admBusitripApplyDO;
    private final QPmsProjectDO qPmsProjectDO = QPmsProjectDO.pmsProjectDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<AdmBusitripApplyVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(AdmBusitripApplyVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 申请单名称
                qdo.applyName,
                // 申请单号
                qdo.applyNo,
                // 申请状态
                qdo.applyStatus,
                // 审批状态
                qdo.apprStatus,
                //流程实例id
                qdo.procInstId,
                // 申请日期
                qdo.applyDate,
                // 事由类型 01 项目 02 售前 03 bu
                qdo.reasonType,
                // 事由id
                qdo.reasonId,
                //事由名称
                qdo.reasonName,
                // 申请人资源id
                qdo.applyResId,
                // 费用承担方（类型）
                qdo.expenseByType,
                // 费用承担bu_id
                qdo.expenseBuId,
                // 费用承担公司id
                qdo.ouId,
                //申请人buid
                qdo.applyBuId,
                // 出发日期
                qdo.beginDate,
                // 结束日期
                qdo.endDate,
                // 天数
                qdo.days,
                // 客户id
                qdo.custId,
                // 是否行政订票
                qdo.bookTicketFlag,
                //被驳回提交到提交人类型
                qdo.rejectType,
                //报销单ID
                qdo.reimId,
                //主服务地
                qdo.baseCity
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<AdmBusitripApplyVO> getJpaQueryWhere(AdmBusitripApplyQuery query) {
        JPAQuery<AdmBusitripApplyVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(AdmBusitripApplyQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(AdmBusitripApplyQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 申请单名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyName())) {
            list.add(qdo.applyName.like(SqlUtil.toSqlLikeString(query.getApplyName())));
        }
        /** 申请单号 模糊 */
        if (!ObjectUtils.isEmpty(query.getApplyNo())) {
            String likeStr = SqlUtil.toSqlLikeString(query.getApplyNo());
            list.add(qdo.applyNo.like(likeStr).or(qdo.applyName.like(likeStr)));
        }
        /** 申请状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyStatus())) {
            if (query.getApplyStatusFlag() != null && query.getApplyStatusFlag().intValue() == 0) {
                list.add(qdo.applyStatus.ne(query.getApplyStatus()));
            } else {
                list.add(qdo.applyStatus.eq(query.getApplyStatus()));
            }

        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }

        /** 事由类型 01 项目 02 售前 03 bu 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonType())) {
            list.add(qdo.reasonType.eq(query.getReasonType()));
        }
        /** 事由id 精确 */
        if (!ObjectUtils.isEmpty(query.getReasonId())) {
            list.add(qdo.reasonId.eq(query.getReasonId()));
        }
        /** 事由名称 模糊 */
        if (!ObjectUtils.isEmpty(query.getReasonName())) {
            list.add(qdo.reasonName.like(SqlUtil.toSqlLikeString(query.getReasonName())));
        }
        /** 申请人资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 费用承担方（类型） 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseByType())) {
            list.add(qdo.expenseByType.eq(query.getExpenseByType()));
        }
        /** 费用承担bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getExpenseBuId())) {
            list.add(qdo.expenseBuId.eq(query.getExpenseBuId()));
        }
        /** 费用承担公司id 精确 */
        if (!ObjectUtils.isEmpty(query.getOuId())) {
            list.add(qdo.ouId.eq(query.getOuId()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyBeginDate())) {
            list.add(qdo.applyDate.goe(query.getApplyBeginDate()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyEndDate())) {
            list.add(qdo.applyDate.loe(query.getApplyEndDate()));
        }
        /** 出发日期 精确 */
        if (!ObjectUtils.isEmpty(query.getBeginDate())) {
            list.add(qdo.beginDate.goe(query.getBeginDate()));
        }
        /** 结束日期 精确 */
        if (!ObjectUtils.isEmpty(query.getEndDate())) {
            list.add(qdo.beginDate.loe(query.getEndDate()));
        }
        /** 天数 精确 */
        if (!ObjectUtils.isEmpty(query.getDays())) {
            list.add(qdo.days.eq(query.getDays()));
        }
        /** 客户id 精确 */
        if (!ObjectUtils.isEmpty(query.getCustId())) {
            list.add(qdo.custId.eq(query.getCustId()));
        }
        /** 是否行政订票 精确 */
        if (!ObjectUtils.isEmpty(query.getBookTicketFlag())) {
            list.add(qdo.bookTicketFlag.eq(query.getBookTicketFlag()));
        }
        /** 申请单是否被报销单关联 */
        if (!ObjectUtils.isEmpty(query.getReimRelateFlag()) && 0 == query.getReimRelateFlag()) {
            list.add(qdo.reimId.isNull());
        }
        if (query.getHwhtSyncFlag() != null) {
            list.add(qdo.hwhtSyncFlag.eq(query.getHwhtSyncFlag()));
        }
        if (query.getBaseCity() != null) {
            list.add(qdo.baseCity.eq(query.getBaseCity()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public AdmBusitripApplyVO queryByKey(Long id) {
        JPAQuery<AdmBusitripApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<AdmBusitripApplyVO> queryListDynamic(AdmBusitripApplyQuery query) {
        JPAQuery<AdmBusitripApplyVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<AdmBusitripApplyVO> queryPaging(AdmBusitripApplyQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<AdmBusitripApplyVO> jpaQuery = getJpaQueryWhere(query);
        List<AdmBusitripApplyVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<AdmBusitripApplyVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public AdmBusitripApplyDO save(AdmBusitripApplyDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<AdmBusitripApplyDO> saveAll(List<AdmBusitripApplyDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(AdmBusitripApplyPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 申请单名称
        if (payload.getApplyName() != null) {
            update.set(qdo.applyName, payload.getApplyName());
        }
        // 申请单号
        if (payload.getApplyNo() != null) {
            update.set(qdo.applyNo, payload.getApplyNo());
        }
        // 申请状态
        if (payload.getApplyStatus() != null) {
            update.set(qdo.applyStatus, payload.getApplyStatus());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 事由类型 01 项目 02 售前 03 bu
        if (payload.getReasonType() != null) {
            update.set(qdo.reasonType, payload.getReasonType());
        }
        // 事由id
        if (payload.getReasonId() != null) {
            update.set(qdo.reasonId, payload.getReasonId());
        }
        // 申请人资源id
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 费用承担方（类型）
        if (payload.getExpenseByType() != null) {
            update.set(qdo.expenseByType, payload.getExpenseByType());
        }
        // 费用承担bu_id
        if (payload.getExpenseBuId() != null) {
            update.set(qdo.expenseBuId, payload.getExpenseBuId());
        }
        // 费用承担公司id
        if (payload.getOuId() != null) {
            update.set(qdo.ouId, payload.getOuId());
        }
        // 出发日期
        if (payload.getBeginDate() != null) {
            update.set(qdo.beginDate, payload.getBeginDate());
        }
        // 结束日期
        if (payload.getEndDate() != null) {
            update.set(qdo.endDate, payload.getEndDate());
        }
        // 天数
        if (payload.getDays() != null) {
            update.set(qdo.days, payload.getDays());
        }
        // 客户id
        if (payload.getCustId() != null) {
            update.set(qdo.custId, payload.getCustId());
        }
        // 是否行政订票
        if (payload.getBookTicketFlag() != null) {
            update.set(qdo.bookTicketFlag, payload.getBookTicketFlag());
        }
        // 被驳回提交到提交人类型
        if (payload.getRejectType() != null) {
            update.set(qdo.rejectType, payload.getRejectType());
        }
        // 删除表示
        if (payload.getDeleteFlag() != null) {
            update.set(qdo.deleteFlag, payload.getDeleteFlag());
        }
        if (payload.getReimId() != null) {
            update.set(qdo.reimId, payload.getReimId());
        }
        if (payload.getReimDefaultFlag() != null) {
            update.setNull(qdo.reimId);
        }
        if (payload.getHwhtSyncFlag() != null) {
            update.set(qdo.hwhtSyncFlag, payload.getHwhtSyncFlag());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 申请单名称
            if (nullFields.contains("applyName")) {
                update.setNull(qdo.applyName);
            }
            // 申请单号
            if (nullFields.contains("applyNo")) {
                update.setNull(qdo.applyNo);
            }
            // 申请状态
            if (nullFields.contains("applyStatus")) {
                update.setNull(qdo.applyStatus);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 事由类型 01 项目 02 售前 03 bu
            if (nullFields.contains("reasonType")) {
                update.setNull(qdo.reasonType);
            }
            // 事由id
            if (nullFields.contains("reasonId")) {
                update.setNull(qdo.reasonId);
            }
            // 申请人资源id
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 费用承担方（类型）
            if (nullFields.contains("expenseByType")) {
                update.setNull(qdo.expenseByType);
            }
            // 费用承担bu_id
            if (nullFields.contains("expenseBuId")) {
                update.setNull(qdo.expenseBuId);
            }
            // 费用承担公司id
            if (nullFields.contains("ouId")) {
                update.setNull(qdo.ouId);
            }
            // 出发日期
            if (nullFields.contains("beginDate")) {
                update.setNull(qdo.beginDate);
            }
            // 结束日期
            if (nullFields.contains("endDate")) {
                update.setNull(qdo.endDate);
            }
            // 天数
            if (nullFields.contains("days")) {
                update.setNull(qdo.days);
            }
            // 客户id
            if (nullFields.contains("custId")) {
                update.setNull(qdo.custId);
            }
            // 是否行政订票
            if (nullFields.contains("bookTicketFlag")) {
                update.setNull(qdo.bookTicketFlag);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<AdmBusitripApplyVO> queryByKeys(List<Long> ids) {
        JPAQuery<AdmBusitripApplyVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        return jpaQuery.fetch();
    }

    /**
     * 解绑报销
     *
     * @param reimId
     */
    public long unbindReim(Long reimId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo);
        update.setNull(qdo.reimId);
        update.where(qdo.reimId.eq(reimId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 更新慧通同步标记
     *
     * @param ids
     * @return
     */
    public long updateHwhtSyncFlag(List<Long> ids) {
        JPAUpdateClause updater = jpaQueryFactory.update(qdo)
                .set(qdo.hwhtSyncFlag, 1)
                .where(qdo.id.in(ids));
        return updater.execute();
    }

}

