package com.elitesland.tw.tw5.server.prd.adm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 出差申请管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Entity
@Table(name = "adm_busitrip_apply", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "adm_busitrip_apply", comment = "出差申请管理")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class AdmBusitripApplyDO extends BaseModel implements Serializable {
    /**
     * 申请单名称
     */
    @Comment("申请单名称")
    @Column()
    private String applyName;
    /**
     * 申请单号
     */
    @Comment("申请单号")
    @Column()
    private String applyNo;
    /**
     * 申请状态
     */
    @Comment("申请状态")
    @Column()
    private String applyStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 流程实例ID
     */
    @Comment("流程实例ID")
    @Column()
    private String procInstId;
    /**
     * 申请日期
     */
    @Comment("申请日期")
    @Column()
    private LocalDate applyDate;
    /**
     * 事由类型 01 项目 02 售前 03 bu
     */
    @Comment("事由类型 01 项目 02 售前 03 bu")
    @Column()
    private String reasonType;
    /**
     * 事由id
     */
    @Comment("事由id")
    @Column()
    private Long reasonId;
    /**
     * 事由名称（冗余字段）
     */
    @Comment("事由名称（冗余字段）")
    @Column()
    private String reasonName;
    /**
     * 申请人资源id
     */
    @Comment("申请人资源id")
    @Column()
    private Long applyResId;
    /**
     * 费用承担方（类型）
     */
    @Comment("费用承担方（类型）")
    @Column()
    private String expenseByType;
    /**
     * 费用承担bu_id
     */
    @Comment("费用承担bu_id")
    @Column()
    private Long expenseBuId;
    /**
     * 费用承担公司id
     */
    @Comment("费用承担公司id")
    @Column()
    private Long ouId;
    /**
     * 申请人bu_id
     */
    @Comment("申请人bu_id")
    @Column()
    private Long applyBuId;
    /**
     * 出发日期
     */
    @Comment("出发日期")
    @Column()
    private LocalDate beginDate;
    /**
     * 结束日期
     */
    @Comment("结束日期")
    @Column()
    private LocalDate endDate;
    /**
     * 天数
     */
    @Comment("天数")
    @Column()
    private BigDecimal days;
    /**
     * 客户id
     */
    @Comment("客户id")
    @Column()
    private Long custId;
    /**
     * 是否行政订票
     */
    @Comment("是否行政订票")
    @Column()
    private Integer bookTicketFlag;
    /**
     * 被驳回提交到提交人类型 0：其他，1：行政订票
     */
    @Comment("被驳回提交到提交人类型 0：其他，1：行政订票")
    @Column()
    private Integer rejectType;

    @Comment("报销单ID")
    @Column()
    private Long reimId;

    @Comment("财务期间id")
    @Column()
    private Long finPeriodId;

    @Comment("慧通同步标记")
    @Column(columnDefinition = "tinyint  DEFAULT 0")
    private Integer hwhtSyncFlag;

    /**
     * 主服务地址
     */
    @Comment("主服务地")
    @Column()
    private String baseCity;

    public void copy(AdmBusitripApplyDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
