package com.elitesland.tw.tw5.server.prd.adm.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.adm.payload.AdmBusitripApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.adm.query.AdmBusitripApplyDetailQuery;
import com.elitesland.tw.tw5.api.prd.adm.service.AdmBusitripApplyDetailService;
import com.elitesland.tw.tw5.api.prd.adm.vo.AdmBusitripApplyDetailVO;
import com.elitesland.tw.tw5.server.prd.adm.convert.AdmBusitripApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.adm.dao.AdmBusitripApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.adm.entity.AdmBusitripApplyDetailDO;
import com.elitesland.tw.tw5.server.prd.adm.repo.AdmBusitripApplyDetailRepo;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 出差申请明细管理
 *
 * @author carl
 * @date 2023-10-30
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AdmBusitripApplyDetailServiceImpl extends BaseServiceImpl implements AdmBusitripApplyDetailService {

    private final AdmBusitripApplyDetailRepo admBusitripApplyDetailRepo;
    private final AdmBusitripApplyDetailDAO admBusitripApplyDetailDAO;

    @Override
    public PagingVO<AdmBusitripApplyDetailVO> queryPaging(AdmBusitripApplyDetailQuery query) {
        return admBusitripApplyDetailDAO.queryPaging(query);
    }

    @UdcNameClass
    @Override
    public List<AdmBusitripApplyDetailVO> queryListDynamic(AdmBusitripApplyDetailQuery query) {
        List<AdmBusitripApplyDetailVO> admBusitripApplyDetailVOS = admBusitripApplyDetailDAO.queryListDynamic(query);
        Set<String> citySet = new HashSet<>();
        admBusitripApplyDetailVOS.forEach(item -> {
            citySet.add(item.getFromPlace());
            citySet.add(item.getToPlace());
        });
        if(!citySet.isEmpty()){
            List<Map<String, Object>> hwhtCityByCityCode = admBusitripApplyDetailRepo.findHwhtCityByCityCode((new ArrayList<>(citySet)));
            Map<Object, Object> objectMap = hwhtCityByCityCode.stream().collect(Collectors.toMap(item -> item.get("cityId"), item -> item.get("cityName")));
            admBusitripApplyDetailVOS.forEach(item -> {
                item.setFromPlaceDesc(objectMap.get(item.getFromPlace()).toString());
                item.setToPlaceDesc(objectMap.get(item.getToPlace()).toString());
            });
        }
        return admBusitripApplyDetailVOS;
    }

    @Override
    public AdmBusitripApplyDetailVO queryByKey(Long key) {
        AdmBusitripApplyDetailDO entity = admBusitripApplyDetailRepo.findById(key).orElseGet(AdmBusitripApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AdmBusitripApplyDetailVO vo = AdmBusitripApplyDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmBusitripApplyDetailVO insert(AdmBusitripApplyDetailPayload payload) {
        AdmBusitripApplyDetailDO entityDo = AdmBusitripApplyDetailConvert.INSTANCE.toDo(payload);
        return AdmBusitripApplyDetailConvert.INSTANCE.toVo(admBusitripApplyDetailRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AdmBusitripApplyDetailVO update(AdmBusitripApplyDetailPayload payload) {
        AdmBusitripApplyDetailDO entity = admBusitripApplyDetailRepo.findById(payload.getId()).orElseGet(AdmBusitripApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AdmBusitripApplyDetailDO entityDo = AdmBusitripApplyDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AdmBusitripApplyDetailConvert.INSTANCE.toVo(admBusitripApplyDetailRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AdmBusitripApplyDetailPayload payload) {
        AdmBusitripApplyDetailDO entity = admBusitripApplyDetailRepo.findById(payload.getId()).orElseGet(AdmBusitripApplyDetailDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = admBusitripApplyDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            admBusitripApplyDetailDAO.deleteSoft(keys);
        }
    }

    @Override
    public List<AdmBusitripApplyDetailVO> bacthInsert(List<AdmBusitripApplyDetailPayload> payloads) {
        List<AdmBusitripApplyDetailDO> dos = AdmBusitripApplyDetailConvert.INSTANCE.toDos(payloads);
        admBusitripApplyDetailRepo.saveAll(dos);
        return null;
    }

    @Override
    public void deleteSoftByApplyId(List<Long> busitripIds) {
        admBusitripApplyDetailDAO.deleteSoftByBusitripId(busitripIds);
    }

}
