package com.elitesland.tw.tw5.server.prd.budget.common.functionEnum;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author sunxw
 * @description 预算单据关联枚举
 * @Date 2024/9/5
 */
@Getter
@AllArgsConstructor
public enum BudgetDocRelateEnum {

    /**
     * 相关单据类型 relateDocType
     */
    INTERNAL_TICKET_AIR("INTERNAL_TICKET_AIR", "国内机票", "飞机"),
    INTERNAL_HOTEL("INTERNAL_HOTEL", "国内酒店", "酒店住宿费"),
    INTERNAL_TAX("INTERNAL_TAX", "国内打车", "市内交通费"),
    INTERNAL_TRAIN("INTERNAL_TRAIN", "国内火车票", "火车"),
    FOREIGN_TICKET_AIR("FOREIGN_TICKET_AIR", "国际机票", "飞机"),
    FOREIGN_HOTEL("FOREIGN_HOTEL", "国外酒店", "酒店住宿费"),
    FOREIGN_TAX("FOREIGN_TAX", "国外打车", "市内交通费"),
    ;

    private final String code;

    /**
     * 第三方描述信息
     */
    private final String otherDesc;

    private final String desc;

}
