package com.elitesland.tw.tw5.server.prd.budget.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetDocRelatePayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetDocRelateQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetDocRelateService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetDocRelateVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 预算单据关联管理
 *
 * @author sunxw
 * @date 2024-09-05
 */
@Api(tags = "预算单据关联管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/budget/docRelate")
@Slf4j
public class PmsBudgetDocRelateController {

    private final PmsBudgetDocRelateService pmsBudgetDocRelateService;

    /**
     * 预算单据关联管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("预算单据关联管理-新增")
    public TwOutputUtil<PmsBudgetDocRelateVO> insert(@RequestBody PmsBudgetDocRelatePayload payload) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.insert(payload));
    }

    /**
     * 预算单据关联管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("预算单据关联管理-更新")
    public TwOutputUtil<PmsBudgetDocRelateVO> update(@RequestBody PmsBudgetDocRelatePayload payload) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.update(payload));
    }

    /**
     * 预算单据关联管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("预算单据关联管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody PmsBudgetDocRelatePayload payload) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.updateByKeyDynamic(payload));
    }

    /**
     * 预算单据关联管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("预算单据关联管理-主键查询")
    public TwOutputUtil<PmsBudgetDocRelateVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.queryByKey(key));
    }

    /**
     * 预算单据关联管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("预算单据关联管理-分页")
    public TwOutputUtil<PagingVO<PmsBudgetDocRelateVO>> paging(PmsBudgetDocRelateQuery query) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.queryPaging(query));
    }

    /**
     * 预算单据关联管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("预算单据关联管理-查询列表")
    public TwOutputUtil<List<PmsBudgetDocRelateVO>> queryList(PmsBudgetDocRelateQuery query) {
        return TwOutputUtil.ok(pmsBudgetDocRelateService.queryListDynamic(query));
    }

    /**
     * 预算单据关联管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("预算单据关联管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        pmsBudgetDocRelateService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

