package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author sunxw
 * @description
 * @Date 2024/9/5
 */
@Entity
@Table(name = "pms_budget_doc_relate", indexes = {
        @Index(name = "idx_reason_id_type", columnList = "reason_id,reason_type"),
        @Index(name = "idx_bus_item_id", columnList = "bus_item_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_doc_relate", comment = "预算单据关联表")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PmsBudgetDocRelateDO extends BaseModel {

    @Comment("来源单据ID")
    @Column(name = "relate_doc_id")
    private Long relateDocId;

    @Comment("来源单据类型")
    @Column(name = "relate_doc_type")
    private String relateDocType;

    @Comment("事由ID")
    @Column(name = "reason_id")
    private Long reasonId;

    @Comment("事由类型")
    @Column(name = "reason_type")
    private String reasonType;

    @Comment("核算项目ID")
    @Column(name = "bus_item_id")
    private Long busItemId;

    @Comment("占用金额")
    @Column(name = "occupy_amt")
    private BigDecimal occupyAmt;

    @Comment("已使用金额")
    @Column(name = "used_amt")
    private BigDecimal usedAmt;

    @Comment("扩展字段1")
    @Column()
    private String extString1;

    @Comment("扩展字段2")
    @Column()
    private String extString2;

    @Comment("扩展字段3")
    @Column()
    private String extString3;

    public void copy(PmsBudgetDocRelateDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
