package com.elitesland.tw.tw5.server.prd.budget.service;


import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetDocRelatePayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetDocRelateQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.PmsBudgetDocRelateService;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetDocRelateVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.PmsBudgetDocRelateConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.PmsBudgetDocRelateDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetDocRelateDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.PmsBudgetDocRelateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import java.util.Collections;
import java.util.List;

/**
 * 预算单据关联管理
 *
 * @author sunxw
 * @date 2024-09-05
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PmsBudgetDocRelateServiceImpl extends BaseServiceImpl implements PmsBudgetDocRelateService {

    private final PmsBudgetDocRelateRepo pmsBudgetDocRelateRepo;
    private final PmsBudgetDocRelateDAO pmsBudgetDocRelateDAO;

    @Override
    public PagingVO<PmsBudgetDocRelateVO> queryPaging(PmsBudgetDocRelateQuery query) {
        return pmsBudgetDocRelateDAO.queryPaging(query);
    }

    @Override
    public List<PmsBudgetDocRelateVO> queryListDynamic(PmsBudgetDocRelateQuery query) {
        return pmsBudgetDocRelateDAO.queryListDynamic(query);
    }

    @Override
    public PmsBudgetDocRelateVO queryByKey(Long key) {
        PmsBudgetDocRelateDO entity = pmsBudgetDocRelateRepo.findById(key).orElseGet(PmsBudgetDocRelateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsBudgetDocRelateVO vo = PmsBudgetDocRelateConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsBudgetDocRelateVO insert(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateDO entityDo = PmsBudgetDocRelateConvert.INSTANCE.toDo(payload);
        return PmsBudgetDocRelateConvert.INSTANCE.toVo(pmsBudgetDocRelateRepo.save(entityDo));
    }

    @Transactional
    @Override
    public List<PmsBudgetDocRelateVO> batchInsert(List<PmsBudgetDocRelatePayload> payloadList) {
        if (ObjectUtils.isEmpty(payloadList)) {
            log.info("待插入的预算关联数据为空！");
            return Collections.emptyList();
        }
        List<PmsBudgetDocRelateDO> entityDOList = PmsBudgetDocRelateConvert.INSTANCE.toDoList(payloadList);
        return PmsBudgetDocRelateConvert.INSTANCE.toVoList(pmsBudgetDocRelateRepo.saveAll(entityDOList));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public PmsBudgetDocRelateVO update(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateDO entity = pmsBudgetDocRelateRepo.findById(payload.getId()).orElseGet(PmsBudgetDocRelateDO::new);
        Assert.notNull(entity.getId(), "不存在");
        PmsBudgetDocRelateDO entityDo = PmsBudgetDocRelateConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsBudgetDocRelateConvert.INSTANCE.toVo(pmsBudgetDocRelateRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateVO pmsBudgetDocRelateVO = pmsBudgetDocRelateDAO.queryByKey(payload.getId());
        if (ObjectUtils.isEmpty(pmsBudgetDocRelateVO)) {
            return -1L;
        }
        return pmsBudgetDocRelateDAO.updateByKeyDynamic(payload);
    }

    @Transactional
    @Override
    public long updateByRelateDocId(PmsBudgetDocRelatePayload payload) {
        PmsBudgetDocRelateVO pmsBudgetDocRelateVO = pmsBudgetDocRelateDAO.queryByRelateDocId(payload.getId());
        if (ObjectUtils.isEmpty(pmsBudgetDocRelateVO)) {
            return -1L;
        }
        return pmsBudgetDocRelateDAO.updateByRelateDocId(payload);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            pmsBudgetDocRelateDAO.deleteSoft(keys);
        }
    }

    @Transactional
    @Override
    public void deleteByRelateDocId(List<Long> relateDocIds) {
        if (!relateDocIds.isEmpty()) {
            pmsBudgetDocRelateDAO.deleteByRelateDocId(relateDocIds);
        }
    }

    @Transactional
    @Override
    public void deleteByRelateDocType(List<String> relateDocTypes) {
        pmsBudgetDocRelateDAO.deleteByRelateDocType(relateDocTypes);
    }

}
