package com.elitesland.tw.tw5.server.prd.cas.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSettingService;
import com.elitesland.tw.tw5.api.prd.cas.service.PrdCasSsoService;
import com.elitesland.tw.tw5.api.prd.cas.vo.PrdCasSettingVO;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.scheduling.TimeUtil;
import com.elitesland.tw.tw5.server.common.util.JwtUtil;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.cas.constant.SsoAppEnum;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import net.sf.jsqlparser.statement.select.KSQLWindow;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.net.CookieManager;
import java.net.CookieStore;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @author zoey
 * @Description:
 * @date 2024/1/25 - 16:23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class PrdCasSsoServiceImpl extends BaseServiceImpl implements PrdCasSsoService {

    private final PrdCasSettingService casSettingService;

    private final RedisUtils redisUtils;
    private final HttpUtil httpUtil;


    /**
     * 获取ticket和重定向地址
     * @param appId
     * @return
     */
    @Override
    public Map getTicketAndUrl(String appId, HttpServletRequest request, HttpServletResponse response) {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if(ObjectUtils.isEmpty(loginUser)){
            throw TwException.error("","登录失败,获取用户信息失败！");
        }
        //读取CAS配置表
        PrdCasSettingVO prdCasSettingVO = casSettingService.queryByAppId(appId);

        // 获取CASTGC
        String castgc = getCastgc(request.getCookies());
        String ticket ="";
        Map<String, Object> userInfoMap = new HashMap<>();
        boolean reGet =false;

        if(castgc !=null){
            ticket = castgc;
            // 在这里可以使用获取到的Cookie值进行进一步处理
            userInfoMap = (Map<String, Object>) redisUtils.get(castgc);
            if(userInfoMap==null || userInfoMap.get("LoginName")==null){
                userInfoMap = new HashMap<>();
                reGet = true;
            }else{
                //判断当前登录人是否一致
                if(!loginUser.getEmail().equals(userInfoMap.get("LoginName"))){
                    reGet = true;
                }
            }
        }

        if(castgc == null || reGet){
            // 生成ticket并存储用户信息
            ticket = UUID.randomUUID().toString();
            //将ticket放到cookie中(CASTGC)
            response.addCookie(new Cookie("CASTGC",ticket));

            userInfoMap.put("LoginName",loginUser.getEmail());
            userInfoMap.put("UserName",loginUser.getUsername());
            userInfoMap.put("UserMail",loginUser.getEmail());

            // 缓存ticket,30分钟过期
            redisUtils.set(ticket,userInfoMap,30, TimeUnit.MINUTES);
        }

        // 获取交叉校验token,并进行交叉验证
        Boolean vaildateResult = vaildateCasLogin(userInfoMap, appId, ticket,prdCasSettingVO);

        //通知浏览器携带ticket进行重定向
        if(vaildateResult){
            Map resultMap = new HashMap<>();
            resultMap.put("ticket", ticket);
            resultMap.put("redirectUri", prdCasSettingVO.getRedirectUri());
            return resultMap;
        }else{
            throw TwException.error("","交叉验证失败，登录失败！");
        }

    }




    /**
     * 交叉验证
     * @param userInfoMap
     * @param appId
     * @param ticket
     * @param prdCasSettingVO
     * @return
     */
    private Boolean vaildateCasLogin(Map userInfoMap, String appId,String ticket,PrdCasSettingVO prdCasSettingVO) {
        Boolean vaildateResult =false;

        switch (SsoAppEnum.valueOf(appId)){
            case YEEDOC :
                Map payloadMap = new HashMap<>();
                payloadMap.put("jwt", JSONUtil.toJsonStr(userInfoMap));
                payloadMap.put("exp", DateUtil.offsetDay(new Date(),30));
                String validateToken = JwtUtil.getToken(null, payloadMap, prdCasSettingVO.getSecret());
                //调用交叉验证的接口
                String validateUri = prdCasSettingVO.getValidateUri();

                if (StringUtils.hasText(validateToken)) {

                    HttpRequest request = HttpRequest.get(validateUri);
                    request.header("ticket",ticket);
                    request.header("userInfo",validateToken);

                    String requestHeaders = prdCasSettingVO.getRequestHeaders();
                    Map<String,String> requestHeadersMap = (Map<String,String>) JSON.parse(requestHeaders);
                    for (String s : requestHeadersMap.keySet()) {
                        request.header(s,String.valueOf(requestHeadersMap.get(s)));
                    }
                    String body = request.execute().body();
                    Map parse = (Map) JSON.parse(body);
                    // TODO:解析结果
                    if(parse.get("IsSuccess").equals(true)){
                        vaildateResult =true;
                    }
                }
            break;
            case FR_REPORT:
                // 帆软已经不走cas登录了
                vaildateResult =true;
                break;
            default:
                //
        }
        return vaildateResult;
    }



    private String getCastgc(Cookie[] cookies) {
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie.getName().equals("CASTGC")) {  // 检查特定的Cookie名称
                    return cookie.getValue();
                }
                return null;
            }
        }
        return null;
    }







}
