package com.elitesland.tw.tw5.server.prd.common;

import com.elitescloud.cloudt.system.vo.SysUserDTO;
import com.elitesland.tw.tw5.api.common.util.TreeListUtil;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.api.prd.org.vo.*;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.system.query.*;
import com.elitesland.tw.tw5.api.prd.system.vo.*;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.OrgEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.my.dao.PrdUserDAO;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgEmployeeConvert;
import com.elitesland.tw.tw5.server.prd.org.convert.PrdOrgOrganizationConvert;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgEmployeeDO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgOrganizationDO;
import com.elitesland.tw.tw5.server.prd.partner.common.dao.BusinessPartnerDAO;
import com.elitesland.tw.tw5.server.prd.system.dao.*;
import com.elitesland.tw.tw5.server.yeedoc.service.YeedocService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

@Component
public class CacheUtil {
    @Autowired
    private PrdSystemRemindDAO systemRemindDAO;
    @Autowired
    private PrdSystemSelectionDAO prdSystemSelectionDAO;
    @Autowired
    private PrdSystemTagDAO prdSystemTagDAO;
    @Autowired
    private PrdSystemSettingDAO prdSystemSettingDAO;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    private PrdSystemFunctionDAO prdSystemFunctionDAO;
    @Autowired
    private PrdSystemFunctionSpecialDAO prdSystemFunctionSpecialDAO;

    @Autowired
    private PrdSystemFunctionDataDAO prdSystemFunctionDataDAO;

    @Autowired
    private PrdSystemConfigDAO prdSystemConfigDAO;

    @Autowired
    private PrdSystemNewFunctionDAO prdSystemNewFunctionDAO;

    @Autowired
    private PrdOrgEmployeeDAO employeeDAO;
    @Autowired
    private PrdOrgOrganizationDAO orgOrganizationDAO;
    @Autowired
    private PrdSystemRoleDAO systemRoleDAO;
    @Autowired
    private PrdUserDAO prdUserDAO;
    // private PrdOrgCompanyDAO orgCompanyDAO;
    @Autowired
    private YeedocService yeedocService;
    @Autowired
    private BusinessPartnerDAO businessPartnerDAO;

    @Lazy
    @Autowired
    private PrdOrgOrganizationService organizationService;
    /**
     * 用户登录
     */
    private final Map<Long, String> userRoleMaps = new HashMap<>();

    /**
     * 系统提醒缓存
     */
    private final Map<String, PrdSystemRemindVO> remindCacheMap = new HashMap<>();
    /**
     * 系统选择项缓存
     */
    private final Map<String, PrdSystemSelectionVO> systemSelectionCacheMap = new HashMap<>();
    /**
     * 系统标签缓存
     */
    private final List<PrdSystemTagVO> systemTagCacheMap = new ArrayList<>();
    /**
     * 系统设置项缓存
     */
    private final Map<String, PrdSystemSettingVO> systemSettingCacheMap = new HashMap<>();


    /**
     * 系统功能项缓存
     */
    private final Map<String, PrdSystemFunctionVO> systemFunctionCacheMap = new HashMap<>();

    /**
     * 系统功能项缓存
     */
    private final Map<Long, PrdSystemFunctionVO> systemFunctionCacheMap0 = new HashMap<>();
    /**
     * 系统关键行为缓存
     */
    private final Map<String, PrdSystemFunctionSpecialVO> systemFunctionSpecialCacheMap = new HashMap<>();

    /**
     * 系统功能权限缓存
     */
    private final Map<Long, List<PrdSystemFunctionDataVO>> systemFunctionDataCacheMap = new HashMap<Long, List<PrdSystemFunctionDataVO>>();

    /**
     * 系统功能配置缓存
     */
    private final Map<String, PrdSystemConfigVO> systemConfigCacheMap = new HashMap<String, PrdSystemConfigVO>();

    /**
     * 用户信息缓存
     */
    private final Map<Long, PrdOrgEmployeeVO> employeeCacheMap = new HashMap<>();

    /**
     * bu对应的一级事业部缓存
     */
    private final Map<Long, PrdOrgOrganizationRefVO> buLevel1Map = new HashMap<>();

    /**
     * 子部门缓存
     */
    private final Map<Long, List<Long>> orgChildMap = new HashMap<>();

    /**
     * 业务对象功能缓存
     */
    private final Map<String, Long> objFunctionMap = new HashMap<>();

    /**
     * 负责部门 子部门 缓存
     */
    private final Map<Long, List<Long>> allOrgChildMap = new HashMap<>();


    /**
     * 系统快捷入口
     */
    private final List<PrdSystemShortcutVO> systemShortcutCache = new ArrayList<PrdSystemShortcutVO>();


    /**
     * 公司信息缓存
     */
    private final Map<Long, BusinessPartnerVO> companyCacheMap = new HashMap<>();

    /**
     * 公司信息缓存
     */
    private final Map<Long, BusinessPartnerVO> companyBookCacheMap = new HashMap<>();
    /**
     * 员工默认组织信息
     */
    private final Map<Long, PrdOrgEmployeeRefVO> orgEmployeeRefCacheMap = new HashMap<>();
    /**
     * 角色编号对应的员工id
     */
    private final Map<String, List<Long>> roleCodeUserIdsMap = new HashMap<>();

    /**
     * 组织信息缓存 key
     */
    private final static String ORGANIZATION_CACHE_KEY = "ORGANIZATION_CACHE_KEY";

    /**
     * 资源组织信息缓存 key
     */
    private final static String EMPLOYEES_ORGANIZATION_CACHE_KEY = "EMPLOYEES_ORGANIZATION_CACHE_KEY";

    /**
     * 员工信息缓存 key
     */
    private final static String EMPLOYEES_CACHE_KEY = "EMPLOYEES_CACHE_KEY";
    /**
     * 默认资源组织信息缓存 key
     */
    private final static String EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY = "EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY";


    private static long lastLoadTimeRemind = 0L;
    private static long lastLoadTimeSystemSelection = 0L;
    private static long lastLoadTimeSystemSetting = 0L;
    private static long lastLoadTimeSystemFunction = 0L;
    private static long lastLoadTimeSystemFunctionSpecial = 0L;
    private static long lastLoadTimeSystemFunctionData = 0L;
    private static long lastLoadTimeSystemConfig = 0L;
    private static long lastLoadTimeSystemTag = 0L;
    private static long lastLoadTimeSystemNewFunction = 0L;
    private static long lastLoadTimeSystemResStatus = 0L;

    private static long lastLoadTimeBULevel1 = 0L;


    /**
     * 清除系统缓存
     *
     * @param clearType
     */
    public void clearSystemCache(Integer clearType) {
        if (clearType == null || clearType == 0) {

            remindCacheMap.clear();
            systemSelectionCacheMap.clear();
            systemTagCacheMap.clear();
            systemTagCacheMap.clear();
            systemSettingCacheMap.clear();
            systemFunctionCacheMap.clear();
            systemFunctionCacheMap0.clear();
            systemFunctionSpecialCacheMap.clear();
            systemFunctionDataCacheMap.clear();
            systemConfigCacheMap.clear();
            objFunctionMap.clear();

            userRoleMaps.clear();
            employeeCacheMap.clear();
            orgChildMap.clear();
            allOrgChildMap.clear();
            companyCacheMap.clear();
            companyBookCacheMap.clear();
            orgEmployeeRefCacheMap.clear();
            buLevel1Map.clear();


        } else if (clearType == 1) {
            remindCacheMap.clear();
            systemSelectionCacheMap.clear();
            systemTagCacheMap.clear();
            systemTagCacheMap.clear();
            systemSettingCacheMap.clear();
            systemFunctionCacheMap.clear();
            systemFunctionCacheMap0.clear();
            systemFunctionSpecialCacheMap.clear();
            systemFunctionDataCacheMap.clear();
            systemConfigCacheMap.clear();
            objFunctionMap.clear();
        } else if (clearType == 2) {
            userRoleMaps.clear();
            employeeCacheMap.clear();
            orgChildMap.clear();
            allOrgChildMap.clear();
            companyCacheMap.clear();
            companyBookCacheMap.clear();
            orgEmployeeRefCacheMap.clear();
            buLevel1Map.clear();
        }
    }

    /**
     * 加载系统配置缓存
     */
    public void loadSystemTagCache() {
        systemTagCacheMap.clear();
        List<PrdSystemTagVO> functionVOs = prdSystemTagDAO.queryListDynamic(new PrdSystemTagQuery());
        functionVOs.forEach(functionVO -> {
            systemTagCacheMap.add(functionVO);
        });
        lastLoadTimeSystemTag = new Date().getTime();
    }

    /**
     * 获取系统标签值
     */
    public List<PrdSystemTagVO> getSystemTag(Long id) {
        if (id == null) {
            if ((this.systemTagCacheMap == null || this.systemTagCacheMap.size() == 0) && shouldLoadCache(lastLoadTimeSystemTag)) {
                loadSystemTagCache();
            }
            return this.systemTagCacheMap;
        } else {
            List<PrdSystemTagVO> functionVOs = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
            if ((functionVOs == null || functionVOs.size() == 0) && shouldLoadCache(lastLoadTimeSystemTag)) {
                loadSystemTagCache();
                List<PrdSystemTagVO> functionVO0 = this.systemTagCacheMap.stream().filter(systemTag -> systemTag.getId().longValue() == id.longValue()).collect(Collectors.toList());
                return functionVO0;
            } else {
                return functionVOs;
            }
        }

    }

    /**
     * 加载系统配置缓存
     */
    public void loadSystemConfigCache() {
        systemConfigCacheMap.clear();
        List<PrdSystemConfigVO> functionVOs = prdSystemConfigDAO.queryListDynamic();
        functionVOs.forEach(functionVO -> {
            systemConfigCacheMap.put(functionVO.getConfigCode(), functionVO);
        });
        lastLoadTimeSystemConfig = new Date().getTime();
    }

    /**
     * 加载系统配置缓存
     */
    public PrdSystemConfigVO getSystemConfig(String code) {
        PrdSystemConfigVO functionVO = this.systemConfigCacheMap.get(code);
        if (functionVO == null && shouldLoadCache(lastLoadTimeSystemConfig)) {
            loadSystemConfigCache();
            return this.systemConfigCacheMap.get(code);
        } else {
            return functionVO;
        }
    }

    /**
     * 加载系统功能权限缓存
     */
    public void loadSystemFunctionDataCache() {
        systemFunctionDataCacheMap.clear();
        PrdSystemFunctionDataQuery query = new PrdSystemFunctionDataQuery();

        List<PrdSystemFunctionDataVO> functionVOs = prdSystemFunctionDataDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            Long functionId = functionVO.getFunctionId();
            List<PrdSystemFunctionDataVO> list = systemFunctionDataCacheMap.get(functionId);
            if (list != null && list.size() > 0) {
                list.add(functionVO);
            } else {
                list = new ArrayList<>();
                list.add(functionVO);
                systemFunctionDataCacheMap.put(functionId, list);
            }
        });
        lastLoadTimeSystemFunctionData = new Date().getTime();
    }

    /**
     * 获取系统功权限
     *
     * @param functionId
     * @return 系统功能
     */
    public List<PrdSystemFunctionDataVO> getFunctionData(Long functionId) {
        List<PrdSystemFunctionDataVO> list = systemFunctionDataCacheMap.get(functionId);
        if (list == null && shouldLoadCache(lastLoadTimeSystemFunctionData)) {
            loadSystemFunctionDataCache();
            return this.systemFunctionDataCacheMap.get(functionId);
        } else {
            return list;
        }
    }

    /**
     * 加载系统功能缓存
     */
    public void loadSystemFunctionSpecialCache() {
        systemFunctionSpecialCacheMap.clear();
        PrdSystemFunctionSpecialQuery query = new PrdSystemFunctionSpecialQuery();

        List<PrdSystemFunctionSpecialVO> functionVOs = prdSystemFunctionSpecialDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            systemFunctionSpecialCacheMap.put(functionVO.getSpecialUrl(), functionVO);
        });

        lastLoadTimeSystemFunctionSpecial = new Date().getTime();
    }

    /**
     * 获取系统功能
     *
     * @param url
     * @return 系统功能
     */
    public PrdSystemFunctionSpecialVO getFunctionSpecial(String url) {
        PrdSystemFunctionSpecialVO functionVO = this.systemFunctionSpecialCacheMap.get(url);
        if (functionVO == null && shouldLoadCache(lastLoadTimeSystemFunctionSpecial)) {
            loadSystemFunctionSpecialCache();
            return this.systemFunctionSpecialCacheMap.get(url);
        } else {
            return functionVO;
        }
    }

    /**
     * 加载系统功能缓存
     */
    public void loadSystemFunctionCache() {
        systemFunctionCacheMap.clear();
        systemFunctionCacheMap0.clear();
        PrdSystemFunctionQuery query = new PrdSystemFunctionQuery();

        List<PrdSystemFunctionVO> functionVOs = prdSystemFunctionDAO.queryListDynamic(query);
        functionVOs.forEach(functionVO -> {
            systemFunctionCacheMap.put(functionVO.getFunctionCode(), functionVO);
            systemFunctionCacheMap0.put(functionVO.getId(), functionVO);
        });
        TreeListUtil.toTree(functionVOs);
        lastLoadTimeSystemFunction = new Date().getTime();
    }

    /**
     * 获取系统功能
     *
     * @param id
     * @return 系统功能
     */
    public PrdSystemFunctionVO getFunctionById(Long id) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap0.get(id);
        if (functionVO == null && shouldLoadCache(lastLoadTimeSystemFunction)) {
            loadSystemFunctionCache();
            return this.systemFunctionCacheMap0.get(id);
        } else {
            return functionVO;
        }
    }

    /**
     * 获取系统功能
     *
     * @param functionCode
     * @return 系统功能
     */
    public PrdSystemFunctionVO getFunction(String functionCode) {
        PrdSystemFunctionVO functionVO = this.systemFunctionCacheMap.get(functionCode);
        if (functionVO == null && shouldLoadCache(lastLoadTimeSystemFunction)) {
            loadSystemFunctionCache();
            return this.systemFunctionCacheMap.get(functionCode);
        } else {
            return functionVO;
        }
    }

    /**
     * 加载系统提醒缓存
     */
    public void loadRemindCache() {
        remindCacheMap.clear();
        PrdSystemRemindQuery query = new PrdSystemRemindQuery();
//        query.setLimit(0);
        List<PrdSystemRemindVO> remindViews = systemRemindDAO.queryListDynamic(query);
        remindViews.forEach(remindView -> {
            remindCacheMap.put(remindView.getRemindCode(), remindView);
        });
        lastLoadTimeRemind = new Date().getTime();
    }

    /**
     * 获取消息提醒
     *
     * @param remindCode 消息提醒码
     * @return 消息提醒
     */
    public PrdSystemRemindVO getRemind(String remindCode) {
        PrdSystemRemindVO remindView = this.remindCacheMap.get(remindCode);
        if (remindView == null && shouldLoadCache(lastLoadTimeRemind)) {
            loadRemindCache();
            return this.remindCacheMap.get(remindCode);
        } else {
            return remindView;
        }
    }

    /**
     * 获取不到缓存时是否应该重新
     *
     * @param lastLoadTime 上次加载缓存时间
     * @return 是否
     */
    private boolean shouldLoadCache(long lastLoadTime) {
        long interval = 1000L * 3600;
        return new Date().getTime() - lastLoadTime > interval;

    }

    /**
     * 加载系统选择项缓存
     */
    public void loadSystemSelectionCache() {
        systemSelectionCacheMap.clear();
        PrdSystemSelectionQuery query = new PrdSystemSelectionQuery();

        List<PrdSystemSelectionVO> selectionViews = prdSystemSelectionDAO.queryListDynamic(query);
        selectionViews.forEach(selectionView -> {
            systemSelectionCacheMap.put(selectionView.getSelectionKey(), selectionView);
        });
        TreeListUtil.toTree(selectionViews);
        lastLoadTimeSystemSelection = new Date().getTime();
    }

    /**
     * 翻译系统选择项
     *
     * @param selectionKey 选择项key
     * @param value        选择项值
     * @return 选择项描述
     */
    public String transferSystemSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<PrdSystemSelectionVO> children = new ArrayList<>();
        getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView.getSelectionName();
                }
            }
        }
        return result;
    }

    /**
     * 翻译系统选择项
     *
     * @param selectionKey 选择项key
     * @param value        选择项值
     * @return 选择项描述
     */
    public PrdSystemSelectionVO querySystemSelection(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        PrdSystemSelectionVO result = null;
        if (selection == null) {
            return result;
        }
        List<PrdSystemSelectionVO> children = new ArrayList<>();
        getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView;
                }
            }
        }
        return result;
    }


    public BigDecimal queryEqvaRatioByJob(String job) {
        if (!StringUtils.hasText(job)) {
            throw TwException.error("", "岗位不可为空");
        }
        //根据岗位获取当量系数
        PrdSystemSelectionVO prdSystemSelectionVO = querySystemSelection("org:employee:job", job);
        if (prdSystemSelectionVO == null) {
            throw TwException.error("", "岗位数据未匹配");
        }
        String extString1 = prdSystemSelectionVO.getExtString1();
        if (StringUtils.hasText(extString1)) {
            return new BigDecimal(extString1);
        } else {
            throw TwException.error("", "未正确配置岗位和系数对应关系，请联系管理员");
        }
    }

    /**
     * 翻译系统选择项
     *
     * @param selectionKey 选择项key
     * @param name         选择项name
     * @return 选择项描述
     */
    public PrdSystemSelectionVO transferSystemObjByName(String selectionKey, String name) {
        if (name == null) {
            return null;
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        if (selection == null) {
            return null;
        }
        List<PrdSystemSelectionVO> children = new ArrayList<>();
        getAllChildren(selection, children);
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (name.equals(selectionView.getSelectionName())) {
                    selection = selectionView;
                    break;
                }
            }
        }
        return selection;
    }

    public void getAllChildren(PrdSystemSelectionVO parent, List<PrdSystemSelectionVO> allChildren) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(parent.getChildren())) {
            return;
        }
        allChildren.addAll(parent.getChildren());
        for (var child : parent.getChildren()) {
            getAllChildren(child, allChildren);
        }
    }

    /**
     * 系统选择项 根据选项名称 获取选项值
     *
     * @param selectionKey 选择关键
     * @param name         名字
     * @return {@link String}
     */
    public String getSystemSelectionValueByName(String selectionKey, String name) {
        if (!StringUtils.hasText(name)) {
            return null;
        } else {
            name = name.trim();
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        String result = name;
        if (selection == null) {
            return result;
        }
        List<PrdSystemSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (name.equals(selectionView.getSelectionName())) {
                    result = selectionView.getSelectionValue();
                }
            }
        }
        return result;
    }

    /**
     * 系统选择项 根据选项值 获取选项名称
     *
     * @param selectionKey 选择关键
     * @param value        名字
     * @return {@link String}
     */
    public String getSystemSelectionNameByValue(String selectionKey, String value) {
        if (!StringUtils.hasText(value)) {
            return null;
        } else {
            value = value.trim();
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        String result = value;
        if (selection == null) {
            return result;
        }
        List<PrdSystemSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView.getSelectionName();
                }
            }
        }
        return result;
    }


    /**
     * 翻译系统选择项的index
     *
     * @param selectionKey 选择项key
     * @param value        选择项值
     * @return 选择项描述
     */
    public Integer transferSystemSelectionSortIndex(String selectionKey, String value) {
        if (value == null) {
            return null;
        }
        PrdSystemSelectionVO selection = getSystemSelection(selectionKey);
        Integer result = 0;
        if (selection == null) {
            return result;
        }
        List<PrdSystemSelectionVO> children = selection.getChildren();
        if (children != null && children.size() > 0) {
            for (PrdSystemSelectionVO selectionView : children) {
                if (value.equals(selectionView.getSelectionValue())) {
                    result = selectionView.getSortNo() == null ? 0 : selectionView.getSortNo();
                }
            }
        }
        return result;
    }

    /**
     * 获取系统选择项
     *
     * @param selectionKey 选择项key
     * @return 消息提醒
     */
    public PrdSystemSelectionVO getSystemSelection(String selectionKey) {
        PrdSystemSelectionVO prdSystemSelectionVO = this.systemSelectionCacheMap.get(selectionKey);
        if (prdSystemSelectionVO == null && shouldLoadCache(lastLoadTimeSystemSelection)) {
            loadSystemSelectionCache();
            return this.systemSelectionCacheMap.get(selectionKey);
        } else {
            return prdSystemSelectionVO;
        }
    }

    /**
     * 加载系统设置缓存
     */
    public void loadSystemSettingCache() {
        systemSettingCacheMap.clear();
        PrdSystemSettingQuery query = new PrdSystemSettingQuery();
        List<PrdSystemSettingVO> systemSettingViews = prdSystemSettingDAO.queryListDynamic(query);
        systemSettingViews.forEach(systemSettingView -> {
            systemSettingCacheMap.put(systemSettingView.getSettingKey(), systemSettingView);
        });
        lastLoadTimeSystemSetting = new Date().getTime();
    }

    /**
     * 获取系统设置
     *
     * @param settingKey 设置项key
     * @return 系统设置
     */
    public PrdSystemSettingVO getSystemSetting(String settingKey) {
        PrdSystemSettingVO systemSettingView = this.systemSettingCacheMap.get(settingKey);
        if (systemSettingView == null && shouldLoadCache(lastLoadTimeSystemSetting)) {
            loadSystemSettingCache();
            return this.systemSettingCacheMap.get(settingKey);
        } else {
            return systemSettingView;
        }
    }


    /**
     * 获取用户姓名
     *
     * @param userId 用户id
     * @return 系统设置
     */
    public String getUserName(Long userId) {
        if (userId == null) {
            return "";
        }
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null) {
            //加载缓存数据
            PrdOrgEmployeeVO prdOrgEmployeeVO = employeeDAO.queryWholeByUserId(userId);
            if (prdOrgEmployeeVO == null) {
                return null;
            }
            employeeCacheMap.put(userId, prdOrgEmployeeVO);
            employeeVO = this.employeeCacheMap.get(userId);
        }
        return employeeVO.getEmployeeName();
    }


    /**
     * 获取用户userId
     *
     * @param employeeName 员工姓名
     * @return 系统设置
     */
    public Long getUserIdByName(String employeeName) {
        String key = EMPLOYEES_CACHE_KEY + ":" + employeeName;
        final PrdOrgEmployeeVO vo = (PrdOrgEmployeeVO) redisUtils.get(key);
        if (vo == null) {
            //加载缓存数据
            final PrdOrgEmployeeDO employeeDO = employeeDAO.queryByUserName(employeeName);
            if (employeeDO == null) {
                return null;
            }
            final PrdOrgEmployeeVO orgEmployeeVO = PrdOrgEmployeeConvert.INSTANCE.toVo(employeeDO);
            redisUtils.set(key, orgEmployeeVO, 10, TimeUnit.MINUTES);
            return orgEmployeeVO.getUserId();
        }
        return vo.getUserId();
    }

    /**
     * 根据员工姓名查询重名的员工
     *
     * @param employeeNameList 员工名字
     * @return {@link PrdOrgEmployeeDO}
     */
    public List<String> queryRepeatedNameByUserName(List<String> employeeNameList) {
        return employeeDAO.queryRepeatedNameByUserName(employeeNameList);
    }

    /**
     * 查询用户默认组织id
     *
     * @param userId 用户id
     * @return {@link Long}
     */
    public Long getDefaultOrgIdByUserId(Long userId) {
        if (null == userId) {
            return null;
        }
        String key = EMPLOYEES_ORGANIZATION_CACHE_KEY + ":" + userId;
        final Long orgId = (Long) redisUtils.get(key);
        if (orgId == null) {
            final List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdUserDAO.queryOrgListByKey(userId);
            if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
                final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                        .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    final Long orgIdDb = list.get(0).getOrgId();
                    if (null == orgIdDb) {
                        return null;
                    }
                    redisUtils.set(key, orgIdDb, 10, TimeUnit.MINUTES);
                    return orgIdDb;
                }
            }
        }
        return orgId;
    }

    /**
     * 得到组织名字
     *
     * @param ordId 奥德id
     * @return {@link String}
     */
    public String getOrgName(Long ordId) {
        if (ordId == null) {
            return "";
        }
        String key = ORGANIZATION_CACHE_KEY + ":" + ordId;
        final PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO) redisUtils.get(key);
        if (vo == null) {
            //加载缓存数据
            final PrdOrgOrganizationVO prdOrgOrganizationVO = orgOrganizationDAO.queryByIdWhole(ordId);
            if (prdOrgOrganizationVO == null) {
                return null;
            }
            redisUtils.set(key, prdOrgOrganizationVO, 10, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getOrgName();
        }
        return vo.getOrgName();
    }

    /**
     * 得到组织
     *
     * @param orgId 组织id
     * @return {@link String}
     */
    public PrdOrgOrganizationVO getOrg(Long orgId) {
        if (orgId == null) {
            return null;
        }
        String key = ORGANIZATION_CACHE_KEY + ":" + orgId;
        final Object object = redisUtils.get(key);
        if (object == null) {
            //加载缓存数据
            final PrdOrgOrganizationVO prdOrgOrganizationVO = orgOrganizationDAO.queryByIdWhole(orgId);
            if (prdOrgOrganizationVO == null) {
                return null;
            }
            redisUtils.set(key, prdOrgOrganizationVO, 10, TimeUnit.MINUTES);
            return prdOrgOrganizationVO;
        }
        PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO) object;
        return vo;
    }

    /**
     * 得到组织名字
     *
     * @param orgName 组织名称
     * @return {@link String}
     */
    public Long getOrgIdByOrgName(String orgName) {
        String key = ORGANIZATION_CACHE_KEY + ":" + orgName;
        final PrdOrgOrganizationVO vo = (PrdOrgOrganizationVO) redisUtils.get(key);
        if (vo == null) {
            //加载缓存数据
            final PrdOrgOrganizationDO prdOrgOrganizationDO = orgOrganizationDAO.queryByName(orgName);
            if (prdOrgOrganizationDO == null) {
                return null;
            }
            final PrdOrgOrganizationVO prdOrgOrganizationVO = PrdOrgOrganizationConvert.INSTANCE.toVo(prdOrgOrganizationDO);
            redisUtils.set(key, prdOrgOrganizationVO, 10, TimeUnit.MINUTES);
            return prdOrgOrganizationVO.getId();
        }
        return vo.getId();
    }

    /**
     * 获取用户编号
     *
     * @param userId 用户id
     * @return 系统设置
     */
    public PrdOrgEmployeeVO getEmployee(Long userId) {
        PrdOrgEmployeeVO employeeVO = this.employeeCacheMap.get(userId);
        if (employeeVO == null || shouldLoadCache(lastLoadTimeSystemResStatus)) {
            //加载缓存数据
            PrdOrgEmployeeVO prdOrgEmployeeVO = employeeDAO.queryWholeByUserId(userId);
            if (prdOrgEmployeeVO == null) {
                return null;
            }
            employeeCacheMap.put(userId, prdOrgEmployeeVO);
            employeeVO = this.employeeCacheMap.get(userId);
            lastLoadTimeSystemResStatus = new Date().getTime();
        }

        return employeeVO;
    }

    //    /**
//     * 获取系统设置
//     *
//     * @param settingKey 设置项key
//     * @return 系统设置
//     */
//    public PrdSystemSettingVO getSystemSetting(String settingKey) {
//        PrdSystemSettingVO systemSettingView = this.systemSettingCacheMap.get(settingKey);
//        if (systemSettingView == null && shouldLoadCache(lastLoadTimeSystemSetting)) {
//            loadSystemSettingCache();
//            return this.systemSettingCacheMap.get(settingKey);
//        } else {
//            return systemSettingView;
//        }
//    }


    /**
     * 判断某个用户是否拥有这个角色
     *
     * @param roleList
     * @return
     */
    public Boolean hasSystemRolePermission(List<String> roleList) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        String longString = userRoleMaps.get(loginUserId);
        if (!StringUtils.hasText(longString) || shouldLoadCache(Long.valueOf(longString.split(",")[0]))) {
            loadSystemRoleCache(loginUserId);
            return hasSystemRolePermission(roleList);
        }
        List<String> stringList = Arrays.asList(longString.split(","));
        for (String roleCode : roleList) {
            if (stringList.contains(roleCode)) {
                return true;
            }
        }
        return false;
    }

    /**
     * 判断某个用户是否拥有这个角色
     *
     * @param args args
     * @return {@link Boolean}
     */
    public Boolean hasSystemRolePermission(String... args) {
        if (!ObjectUtils.isEmpty(args)) {
            return hasSystemRolePermission(Arrays.asList(args));
        }
        return false;
    }

    /**
     * 是否是系统管理员
     *
     * @return {@link Boolean}
     */
    public boolean isSystemAdmin() {
        return GlobalUtil.getLoginGeneralUser().isSystemAdmin() || hasSystemRolePermission(RoleEnum.SYS.getCode());
    }

    /**
     * 返回用户的系统角色编码
     *
     * @param userId
     * @return
     */
    public List<String> getSystemRoleCodes(Long userId) {
        String roleCodesStr = userRoleMaps.get(userId);
        if (!StringUtils.hasText(roleCodesStr) || shouldLoadCache(Long.valueOf(roleCodesStr.split(",")[0]))) {
            loadSystemRoleCache(userId);
            roleCodesStr = userRoleMaps.get(userId);
        }
        if (StringUtils.hasText(roleCodesStr)) {
            List<String> roleCodes = Arrays.asList(roleCodesStr.split(","));
            return roleCodes;
        }
        return new ArrayList<>();
    }

    /**
     * 加载系统设置缓存
     */
    public void loadSystemRoleCache(Long loginUserId) {
        List<String> roleCodes = systemRoleDAO.queryUserRoleCodes(loginUserId);

        String str = new Date().getTime() + "";
        if (!ObjectUtils.isEmpty(roleCodes)) {
            str = str.concat(",").concat(StringUtils.collectionToCommaDelimitedString(roleCodes));
        }
        userRoleMaps.put(loginUserId, str);
    }

    /**
     * 根据用户id默认组织信息 包含上级、组织等信息
     *
     * @param userId 用户id
     * @return {@link PrdOrgDataRefVO}
     */
    public PrdOrgDataRefVO getDefaultOrgInfoByUserId(Long userId) {
        if (null == userId) {
            return null;
        }
        String key = EMPLOYEES_DEFAULT_ORGANIZATION_INFO_CACHE_KEY + ":" + userId;
        final PrdOrgDataRefVO result = (PrdOrgDataRefVO) redisUtils.get(key);
        if (result == null) {
            final List<PrdOrgDataRefVO> prdOrgDataRefVOS = prdUserDAO.queryOrgListByKey(userId);
            if (!CollectionUtils.isEmpty(prdOrgDataRefVOS)) {
                final List<PrdOrgDataRefVO> list = prdOrgDataRefVOS.stream()
                        .filter(prdOrgDataRefVO -> prdOrgDataRefVO.getIsDefault().equals(0))
                        .collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    final PrdOrgDataRefVO prdOrgDataRefVO = list.get(0);
                    if (null == prdOrgDataRefVO) {
                        return null;
                    }
                    redisUtils.set(key, prdOrgDataRefVO, 10, TimeUnit.MINUTES);
                    return prdOrgDataRefVO;
                }
            }
        }
        return result;
    }

    /**
     * 获取业务对象 通过功能编码
     *
     * @param code
     * @return
     */
    public Long getObjectIdByFunctionCode(String code) {
        Long objectId = this.objFunctionMap.get(code);
        if (ObjectUtils.isEmpty(objectId) && shouldLoadCache(lastLoadTimeSystemNewFunction)) {
            loadSystemNewFunctionCache(code);
            return this.objFunctionMap.get(code);
        } else {
            return objectId;
        }
    }

    /**
     * 加载业务对象功能缓存
     *
     * @param code
     */
    private void loadSystemNewFunctionCache(String code) {
        Long objectId = prdSystemNewFunctionDAO.getObjectIdByFunctionCode(code);

        objFunctionMap.put(code, objectId);

        lastLoadTimeSystemNewFunction = new Date().getTime();
    }

    public List<Long> getAllChildOrgIds(Long orgId) {
        if (orgChildMap.containsKey(orgId)) {
            return orgChildMap.get(orgId);
        }
        Set<Long> childOrgIds = orgOrganizationDAO.queryAllChildOrgs(Collections.singleton(orgId));

        if (CollectionUtils.isEmpty(childOrgIds)) {
            return new ArrayList<>();
        }

        orgChildMap.put(orgId, new ArrayList<>(childOrgIds));

        return orgChildMap.get(orgId);

    }

    /**
     * 获取公司姓名 2023/12/13 修改为查询业务伙伴 wly
     * 目前map中只有id bookId 是否有客户身份 是否有供应商身份
     * 是否有合伙伙伴身份 内部/外部几个字段 需要的请自行加
     *
     * @param companyId 公司id
     * @return 系统设置
     */
    public String getCompanyName(Long companyId) {
        if (companyId == null) {
            return null;
        }
        BusinessPartnerVO businessPartnerVO = this.companyCacheMap.get(companyId);
        if (businessPartnerVO == null) {
            //加载缓存数据
            businessPartnerVO = businessPartnerDAO.findById(companyId);
            if (businessPartnerVO == null) {
                return null;
            }
            companyCacheMap.put(companyId, businessPartnerVO);
        }
        return businessPartnerVO.getPartnerName();
    }

    /**
     * 根据地址簿id获取公司姓名 2023/12/13 修改为查询业务伙伴 wly
     * 目前map中只有id bookId 是否有客户身份 是否有供应商身份
     * 是否有合伙伙伴身份 内部/外部几个字段 需要的请自行加
     *
     * @param bookId 地址簿id
     * @return 系统设置
     */
    public String getCompanyNameByBookId(Long bookId) {
        if (bookId == null) {
            return null;
        }
        BusinessPartnerVO businessPartnerVO = this.companyBookCacheMap.get(bookId);
        if (businessPartnerVO == null) {
            //加载缓存数据
            List<BusinessPartnerVO> businessPartnerVOList = businessPartnerDAO.queryByBookId(bookId);
            if (CollectionUtils.isEmpty(businessPartnerVOList)) {
                return null;
            }
            businessPartnerVO = businessPartnerVOList.get(0);
            companyBookCacheMap.put(bookId, businessPartnerVO);
        }
        return businessPartnerVO.getPartnerName();
    }

    /**
     * 根据角色编号获取对应员工
     *
     * @param roleCodes 角色编号
     * @return 系统设置
     */
    public List<Long> getUserIdByRoleCodes(List<String> roleCodes) {
        if (roleCodes == null) {
            return null;
        }
        Set<Long> userIds = new HashSet<>();
        roleCodes.forEach(code -> {
            List<Long> longs = this.roleCodeUserIdsMap.get(code);
            if (ObjectUtils.isEmpty(longs)) {
                longs = systemRoleDAO.queryUserIdByRoleCode(code);
            }
            if (ObjectUtils.isEmpty(longs)) {
                roleCodeUserIdsMap.put(code, longs);
                userIds.addAll(new HashSet<>(longs));
            }
        });
        return new ArrayList<>(userIds);
    }

    /**
     * 获取员工默认事业部信息
     *
     * @param userId 用户id
     * @return 系统设置
     */
    public PrdOrgOrganizationRefVO getUserBuLevel1(Long userId) {
        if (userId == null) {
            return null;
        }
        PrdOrgEmployeeRefVO employeeRefVO = this.orgEmployeeRefCacheMap.get(userId);
        if (employeeRefVO == null) {
            //加载缓存数据
            employeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (employeeRefVO == null) {
                return null;
            }
            orgEmployeeRefCacheMap.put(userId, employeeRefVO);
        }
        return getBULevel1ByOrgId(employeeRefVO.getOrgId());
    }

    /**
     * 获取员工默认组织信息
     *
     * @param userId 用户id
     * @return 系统设置
     */
    public PrdOrgEmployeeRefVO getUserDefaultOrg(Long userId) {
        if (userId == null) {
            return null;
        }
        PrdOrgEmployeeRefVO employeeRefVO = this.orgEmployeeRefCacheMap.get(userId);
        if (employeeRefVO == null) {
            //加载缓存数据
            employeeRefVO = employeeDAO.queryUserOrgData(userId);
            if (employeeRefVO == null) {
                return null;
            }
            orgEmployeeRefCacheMap.put(userId, employeeRefVO);
        }
        return employeeRefVO;
    }

    public PrdOrgOrganizationRefVO getBULevel1ByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        PrdOrgOrganizationRefVO prdOrgOrganizationRefVO = this.buLevel1Map.get(orgId);
        if (prdOrgOrganizationRefVO == null || shouldLoadCache(lastLoadTimeBULevel1)) {
            this.lastLoadTimeBULevel1 = new Date().getTime();
            List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = organizationService.queryAllFatherOrgByOrgId(orgId);
            Optional<PrdOrgOrganizationRefVO> first = prdOrgOrganizationRefVOS.stream().filter(vo -> StringUtils.hasText(vo.getBuLevel()) && vo.getBuLevel().equals(OrgEnum.BuLevel.BU_LEVEL1.getCode()) && vo.getOrgStatus().equalsIgnoreCase(OrgEnum.OrgStatus.ACTIVE.getCode())).findFirst();
            if (first.isPresent()) {
                buLevel1Map.put(orgId, first.get());
                return first.get();
            }
        }
        return prdOrgOrganizationRefVO;
    }

    public List<PrdOrgOrganizationRefVO> getAllFatherOrgByOrgId(Long orgId) {
        if (orgId == null) {
            return null;
        }
        List<PrdOrgOrganizationRefVO> prdOrgOrganizationRefVOS = organizationService.queryAllFatherOrgByOrgId(orgId);
        return prdOrgOrganizationRefVOS;
    }

    /**
     * 查询该资源作为组织负责人所在的所有组织id
     *
     * @param userId 用户id
     * @return 系统设置
     */
    public List<Long> getOrgIdsByManageId(Long userId) {
        if (userId == null) {
            return null;
        }
        return orgOrganizationDAO.queryByManageIdOrgIds(userId);
    }

    /**
     * 获取yeedoc Token jwt
     *
     * @param loginUser 登录用户
     * @return {@link String}
     */
    public String getYeedocJwt(SysUserDTO loginUser) {
        if (loginUser == null) {
            return null;
        }
        String yeedocJwt = yeedocService.getYeedocJwt(loginUser);
        return yeedocJwt;
    }

    /**
     * 获取yeedoc Token jwt
     *
     * @return {@link String}
     */
    public String getYeedocJwt() {
        SysUserDTO loginUser = GlobalUtil.getLoginUser();
        if (loginUser == null) {
            return null;
        }
        String yeedocJwt = yeedocService.getYeedocJwt(loginUser);
        return yeedocJwt;
    }


    /**
     * 返回用户的系统角色编码  不走缓存
     *
     * @param userId 用户id
     * @return {@link List}<{@link String}>
     */
    public List<String> getSystemRoleCodesNoCache(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }
        List<String> roleCodes = systemRoleDAO.queryUserRoleCodes(userId);
        return roleCodes;
    }


    public List<Long> getAllChildOrgByUserId(Long userId) {
        if (null == userId) {
            userId = GlobalUtil.getLoginUserId();
        }

        if (allOrgChildMap.containsKey(userId)) {
            return allOrgChildMap.get(userId);
        }

        List<PrdOrgOrganizationRefVO> organization = organizationService.queryAllChildOrgByUserId(userId);

        if (!CollectionUtils.isEmpty(organization)) {
            List<Long> orgIds = organization.stream().map(PrdOrgOrganizationRefVO::getOrgId).toList();
            allOrgChildMap.put(userId, orgIds);
            return orgIds;
        }

        // 如果为空
        allOrgChildMap.put(userId, Collections.emptyList());

        return allOrgChildMap.get(userId);
    }
}
