package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 组织bu相关枚举
 *
 * @author eason.shi
 * @since 2018/12/20
 */
public interface OrgEnum {
    /**
     * 事业部等级
     */
    enum BuLevel implements OrgEnum {
        BU_LEVEL1("BU_LEVEL1", "一级事业部"),
        BU_LEVEL2("BU_LEVEL2", "二级事业部"),
        BU_LEVEL3("BU_LEVEL3", "三级事业部"),


        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        BuLevel(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 组织类型
     */
    enum OrgType implements OrgEnum {
        BM("BM", "平台支持类BU"),
        BS("BS", "销售BU"),
        BD("BD", "事业部BU"),
        BY("BY", "研发事业部BU"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        OrgType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }

    /**
     * 组织状态
     */
    enum OrgStatus implements OrgEnum {
        CREATE("CREATE", "新建"),
        CREATING("CREATING", "审批中"),
        ACTIVE("ACTIVE", "激活"),
        PENDING("PENDING", "暂挂"),
        changing("changing", "变更中"),
        CLOSED("CLOSED", "关闭"),
        ;
        /**
         * 状态
         */
        @Getter
        private final String code;

        /**
         * 描述
         */
        @Getter
        private final String desc;

        OrgStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }
    }
}
