package com.elitesland.tw.tw5.server.prd.common.functionEnum;

import lombok.Getter;

/**
 * 销售合同工作类型
 *
 * @author carl
 * @date 2023/9/5
 */
public enum SaleConWorkTypeEnum {
    DELIVERY("DELIVERY", "交付项目"),
    OPERATION("OPERATION", "运维项目"),
    DEVELOP("DEVELOP", "内部研发项目"),
    SERVICETRADE("SERVICETRADE", "贸易含服务项目"),
    PURETRADE("PURETRADE", "纯贸易项目"),
    MANAGE("MANAGE", "管理类项目"),
    SPECIAL("SPECIAL", "专项项目"),
    INDEPENDENT("INDEPENDENT", "自主研发（软件)"),
    CONSULT("CONSULT", "咨询业务项目"),
    TM("T&M", "T&M项目"),

    ;


    @Getter
    private final String code;

    /**
     * 描述
     */
    @Getter
    private final String desc;

    SaleConWorkTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
}
