package com.elitesland.tw.tw5.server.prd.crm.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitesland.tw.tw5.api.common.annotation.FieldCreateLog;
import com.elitesland.tw.tw5.api.common.annotation.FieldUpdateLog;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author zoey
 * @Description:线索客户表，保存线索的客户信息
 * @date 2022/5/17 - 17:12
 */
@Entity
@Table(name = "crm_leads_customer",indexes = {})
@org.hibernate.annotations.Table(appliesTo = "crm_leads_customer", comment = "线索客户表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmLeadsCustomerDO extends BaseModel {
//    @Comment("线索id")
//    @Column(name = "leads_id", nullable = false)
//    private Long leadsId;

    @FieldUpdateLog(fieldName = "企业名称")
    @FieldCreateLog(fieldName = "企业名称")
    @Comment("客户名称")
    @Column(name = "customer_name", nullable = false)
    private String customerName;

    @FieldUpdateLog(fieldName = "客户行业",selectionKey = "crm:leads_customer_industry")
    @FieldCreateLog(fieldName = "客户行业",selectionKey = "crm:leads_customer_industry")
    @Comment("客户行业")
    @Column(name = "customer_industry")
    private String customerIndustry;

    @FieldUpdateLog(fieldName = "客户级别",selectionKey = "crm:customer_grade")
    @FieldCreateLog(fieldName = "客户级别",selectionKey = "crm:customer_grade")
    @Comment("客户级别")
    @Column(name = "customer_grade")
    private String customerGrade;

    @FieldUpdateLog(fieldName = "客户联系人")
    @FieldCreateLog(fieldName = "客户联系人")
    @Comment("客户联系人")
    @Column(name = "customer_contacts", nullable = false)
    private String customerContacts;

    @FieldUpdateLog(fieldName = "联系人部门")
    @FieldCreateLog(fieldName = "联系人部门")
    @Comment("联系人部门")
    @Column(name = "contacts_department")
    private String contactsDepartment;

    @FieldUpdateLog(fieldName = "联系人岗位")
    @FieldCreateLog(fieldName = "联系人岗位")
    @Comment("联系人岗位")
    @Column(name = "contacts_position")
    private String contactsPosition;

    @FieldUpdateLog(fieldName = "联系人电话")
    @FieldCreateLog(fieldName = "联系人电话")
    @Comment("联系人电话")
    @Column(name = "contacts_phone")
    private String contactsPhone;

    @FieldUpdateLog(fieldName = "联系人邮箱")
    @FieldCreateLog(fieldName = "联系人邮箱")
    @Comment("联系人邮箱")
    @Column(name = "contacts_email")
    private String contactsEmail;

    @FieldUpdateLog(fieldName = "客户区域",selectionKey = "crm:customer_region")
    @FieldCreateLog(fieldName = "客户区域",selectionKey = "crm:customer_region")
    @Comment("客户区域")
    @Column(name = "cust_region")
    private String custRegion;


    @Comment("销售产品")
    @Column()
    private String saleProduct;

    public void copy(CrmPotentialCustomerDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }

}
