package com.elitesland.tw.tw5.server.prd.humanresources.examination.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdExamTempGradePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdExamTempGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdExamTempGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdExamTempGradeVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import org.springframework.web.bind.annotation.*;
import java.util.Arrays;


/**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板等级
 */

@RestController
@RequestMapping("/api/prdExamTempGrade")
@RequiredArgsConstructor
@Api(value = "绩效考核模板等级", tags = {"绩效考核模板等级"})
public class PrdExamTempGradeController{
    
    private final PrdExamTempGradeService prdExamTempGradeService;
    
    
    @GetMapping("get/{id}")
    @ApiOperation("详情-绩效考核模板等级")
    public TwOutputUtil<PrdExamTempGradeVO> get(@PathVariable Long id) {
    
        PrdExamTempGradeVO res = prdExamTempGradeService.get(id);
        return TwOutputUtil.ok(res);
        
    }
    
    
    @PostMapping("save")
    @ApiOperation("新增-绩效考核模板等级")
    public TwOutputUtil<Long> save(@RequestBody PrdExamTempGradePayload prdExamTempGradePayload) {
        
        PrdExamTempGradeVO res = prdExamTempGradeService.save(prdExamTempGradePayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @PostMapping("update")
    @ApiOperation("修改-绩效考核模板等级")
    public TwOutputUtil<Long> update(@RequestBody PrdExamTempGradePayload prdExamTempGradePayload) {
        
        PrdExamTempGradeVO res = prdExamTempGradeService.update(prdExamTempGradePayload);
        return TwOutputUtil.ok(res.getId());
        
    }
    
    
    @DeleteMapping("del")
    @ApiOperation("删除-绩效考核模板等级")
    public TwOutputUtil<Long> del(Long[] ids) {
    
        Long res = prdExamTempGradeService.del(Arrays.asList(ids));
        return TwOutputUtil.ok(res);
        
    }
    
    
    @GetMapping("/page")
    @UdcNameClass
    @ApiOperation("分页查询-绩效考核模板等级")
    public TwOutputUtil<PagingVO<PrdExamTempGradeVO>> page(PrdExamTempGradeQuery prdExamTempGradeQuery) {
        
        PagingVO<PrdExamTempGradeVO> res = prdExamTempGradeService.page(prdExamTempGradeQuery);
        return TwOutputUtil.ok(res);
        
    }
    
    
    
}

