package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Data;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;
import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


 /**
 * @author : WWW
 * @date : 2023-11-13
 * @desc : 绩效考核模板
 */
 
@Entity
@Table(name="prd_exam_temp")
@org.hibernate.annotations.Table(appliesTo = "prd_exam_temp", comment = "绩效考核模板")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdExamTempDO extends BaseModel {


    /**
     * 模板名称
     */
    @Column(name = "name", columnDefinition = "varchar(255) comment '模板名称'")
    private String name;
    
    /**
     * 分数上限
     */
    @Column(name = "score_max", columnDefinition = "decimal(20,2) comment '分数上限'")
    private BigDecimal scoreMax;
    
    /**
     * 分数下限
     */
    @Column(name = "score_min", columnDefinition = "decimal(20,2) comment '分数下限'")
    private BigDecimal scoreMin;
    
    /**
     * 启用标志
     */
    @Column(name = "enable_flag", columnDefinition = "tinyint(1) comment '启用标志'")
    private Boolean enableFlag;
    

}

