package com.elitesland.tw.tw5.server.prd.humanresources.examination.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamRelatePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamRelateQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamRelateService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamRelateVO;
import com.elitesland.tw.tw5.server.prd.humanresources.convert.PrdPerformanceExamRelateConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.dao.PrdPerformanceExamRelateDao;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamRelateDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.repo.PrdPerformanceExamRelateRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.collection.CollectionUtil;

import java.util.List;


 /**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 可查看考核相关人员Service
 */

@Slf4j
@Service
@RequiredArgsConstructor
public class PrdPerformanceExamRelateServiceImpl implements PrdPerformanceExamRelateService {
    
    
    private final PrdPerformanceExamRelateDao prdPerformanceExamRelateDao;
    
    private final PrdPerformanceExamRelateRepo prdPerformanceExamRelateRepo;
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamRelateVO save(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
    
        checkData(prdPerformanceExamRelatePayload);
        PrdPerformanceExamRelateDO prdPerformanceExamRelateDO = new PrdPerformanceExamRelateDO();
        prdPerformanceExamRelateDO = PrdPerformanceExamRelateConvert.INSTANCE.p2d(prdPerformanceExamRelatePayload);
        PrdPerformanceExamRelateDO res = prdPerformanceExamRelateRepo.save(prdPerformanceExamRelateDO);
        return PrdPerformanceExamRelateConvert.INSTANCE.d2v(res);
        
    }
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public PrdPerformanceExamRelateVO update(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
    
        Assert.notNull(prdPerformanceExamRelatePayload.getId(), "id is null");
        PrdPerformanceExamRelateVO res = save(prdPerformanceExamRelatePayload);
        return res;
        
    }
    
    
    @Override
    public PrdPerformanceExamRelateVO get(Long id) {
    
        if (null == id) {
            return null;
        }
        PrdPerformanceExamRelateVO res = prdPerformanceExamRelateDao.get(id);
        return res;
        
    }
    
    
    @Override
    public PagingVO<PrdPerformanceExamRelateVO> page(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        PagingVO<PrdPerformanceExamRelateVO> res = prdPerformanceExamRelateDao.page(prdPerformanceExamRelateQuery);
        return res;
        
    }
    
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long del(List<Long> ids) {
    
        if (CollectionUtil.isEmpty(ids)) {
            return 0L;
        }
        Long res = prdPerformanceExamRelateDao.del(ids);
        return res;
        
    }
    
    @Override
    public List<PrdPerformanceExamRelateVO> getList(PrdPerformanceExamRelateQuery prdPerformanceExamRelateQuery) {
        
        List<PrdPerformanceExamRelateVO> res = prdPerformanceExamRelateDao.getList(prdPerformanceExamRelateQuery);
        return res;
    
    }
    
    
    /**
     * 数据校验
     * @param prdPerformanceExamRelatePayload
     */
    private void checkData(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
    
//        if (StringUtils.isBlank(prdPerformanceExamRelatePayload.getState())) {
//            throw new BusinessException("状态不能为空");
//        }
    
    }
    
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long updateByCondition(PrdPerformanceExamRelatePayload prdPerformanceExamRelatePayload) {
        Assert.notNull(prdPerformanceExamRelatePayload.getId(), "id不能为空");
        Long res = prdPerformanceExamRelateDao.update(prdPerformanceExamRelatePayload);
        return res;
    }
    
    
}

