package com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity;

import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.time.LocalDate;

@Entity
@Table(name = "person_reward_punish", indexes = {
        @Index(name = "person_index", columnList = "person_id"),
})
@org.hibernate.annotations.Table(appliesTo = "person_reward_punish", comment = "人员-奖惩信息表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PersonRewardPunishDO extends BaseModel {

    @Comment("自然人ID")
    @Column(name = "person_id", nullable = false)
    private Long personId;

    @Comment("奖惩类型")
    @Column
    private String type;

    @Comment("奖惩名称")
    @Column
    private String name;

    @Comment("获得时间")
    @Column
    private LocalDate obtainDate;

    @Comment("到期日期")
    @Column
    private LocalDate expireDate;

    @Comment("原因")
    @Column
    private String reason;

    @Comment("证书")
    @Column
    private String certCodes;

}
